/*
 * Decompiled with CFR 0.152.
 */
package com.tspoon.traceur;

import com.tspoon.traceur.TraceurException;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;

final class SingleOnAssembly<T>
extends Single<T> {
    final SingleSource<T> source;
    final TraceurException assembled;

    SingleOnAssembly(SingleSource<T> source) {
        this.source = source;
        this.assembled = TraceurException.create();
    }

    protected void subscribeActual(SingleObserver<? super T> s) {
        this.source.subscribe(new OnAssemblySingleObserver<T>(s, this.assembled));
    }

    static final class OnAssemblySingleObserver<T>
    implements SingleObserver<T>,
    Disposable {
        final SingleObserver<? super T> actual;
        final TraceurException assembled;
        Disposable d;

        OnAssemblySingleObserver(SingleObserver<? super T> actual, TraceurException assembled) {
            this.actual = actual;
            this.assembled = assembled;
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)this.d, (Disposable)d)) {
                this.d = d;
                this.actual.onSubscribe((Disposable)this);
            }
        }

        public void onSuccess(T value) {
            this.actual.onSuccess(value);
        }

        public void onError(Throwable t) {
            this.actual.onError(this.assembled.appendTo(t));
        }

        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        public void dispose() {
            this.d.dispose();
        }
    }
}

