/*
 * Decompiled with CFR 0.152.
 */
package moxy.viewstate;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import moxy.MvpView;
import moxy.viewstate.ViewCommand;
import moxy.viewstate.ViewCommands;

public abstract class MvpViewState<View extends MvpView> {
    protected ViewCommands<View> viewCommands = new ViewCommands();
    protected Set<View> views = Collections.newSetFromMap(new WeakHashMap());
    protected Set<View> inRestoreState = Collections.newSetFromMap(new WeakHashMap());
    protected Map<View, Set<ViewCommand<View>>> viewStates = new WeakHashMap<View, Set<ViewCommand<View>>>();

    protected void restoreState(View view, Set<ViewCommand<View>> currentState) {
        if (this.viewCommands.isEmpty()) {
            return;
        }
        this.viewCommands.reapply(view, currentState);
    }

    protected Boolean hasNotView() {
        return this.views == null || this.views.isEmpty();
    }

    public void attachView(View view) {
        if (view == null) {
            throw new IllegalArgumentException("Mvp view must be not null");
        }
        boolean isViewAdded = this.views.add(view);
        if (!isViewAdded) {
            return;
        }
        this.inRestoreState.add(view);
        Set<ViewCommand<Object>> currentState = this.viewStates.get(view);
        currentState = currentState == null ? Collections.emptySet() : currentState;
        this.restoreState(view, currentState);
        this.viewStates.remove(view);
        this.inRestoreState.remove(view);
    }

    public void detachView(View view) {
        this.views.remove(view);
        this.inRestoreState.remove(view);
        Set currentState = Collections.newSetFromMap(new WeakHashMap());
        currentState.addAll(this.viewCommands.getCurrentState());
        this.viewStates.put(view, currentState);
    }

    public void destroyView(View view) {
        this.viewStates.remove(view);
    }

    public Set<View> getViews() {
        return this.views;
    }

    public boolean isInRestoreState(View view) {
        return this.inRestoreState.contains(view);
    }
}

