/*
 * Decompiled with CFR 0.152.
 */
package moxy;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import moxy.MvpView;
import moxy.locators.ViewStateLocator;
import moxy.viewstate.MvpViewState;

public abstract class MvpPresenter<View extends MvpView> {
    private boolean isFirstLaunch = true;
    private String tag;
    private Set<View> views;
    private View viewStateAsView;
    private MvpViewState<View> viewState;
    private Class<? extends MvpPresenter> presenterClass;

    public MvpPresenter() {
        Binder.bind(this);
        this.views = Collections.newSetFromMap(new WeakHashMap());
    }

    public void attachView(View view) {
        if (this.viewState != null) {
            this.viewState.attachView(view);
        } else {
            this.views.add(view);
        }
        if (this.isFirstLaunch) {
            this.isFirstLaunch = false;
            this.onFirstViewAttach();
        }
    }

    protected void onFirstViewAttach() {
    }

    public void detachView(View view) {
        if (this.viewState != null) {
            this.viewState.detachView(view);
        } else {
            this.views.remove(view);
        }
    }

    public void destroyView(View view) {
        if (this.viewState != null) {
            this.viewState.destroyView(view);
        }
    }

    public Set<View> getAttachedViews() {
        if (this.viewState != null) {
            return this.viewState.getViews();
        }
        return this.views;
    }

    public View getViewState() {
        return this.viewStateAsView;
    }

    public void setViewState(MvpViewState<View> viewState) {
        this.viewStateAsView = (MvpView)((Object)viewState);
        this.viewState = viewState;
    }

    public boolean isInRestoreState(View view) {
        if (this.viewState != null) {
            return this.viewState.isInRestoreState(view);
        }
        return false;
    }

    String getTag() {
        return this.tag;
    }

    void setTag(String tag) {
        this.tag = tag;
    }

    Class<? extends MvpPresenter> getPresenterClass() {
        return this.presenterClass;
    }

    void setPresenterClass(Class<? extends MvpPresenter> presenterClass) {
        this.presenterClass = presenterClass;
    }

    public void onDestroy() {
    }

    private static class Binder {
        private Binder() {
        }

        static void bind(MvpPresenter presenter) {
            MvpViewState viewState = ViewStateLocator.getViewState(presenter.getClass());
            presenter.viewStateAsView = (MvpView)((Object)viewState);
            presenter.viewState = viewState;
        }
    }
}

