/*
 * Decompiled with CFR 0.152.
 */
package moxy;

import android.os.Bundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import moxy.MvpFacade;
import moxy.MvpPresenter;
import moxy.MvpView;
import moxy.PresenterStore;
import moxy.PresentersCounter;
import moxy.presenter.PresenterField;

public class MvpDelegate<Delegated> {
    public static final String MOXY_DELEGATE_TAGS_KEY = "MoxyDelegateBundle";
    private static final String KEY_TAG = "moxy.MvpDelegate.KEY_TAG";
    private static final Comparator<PresenterField> COMPARE_BY_TAGS = (f1, f2) -> f1.getTag(null).compareTo(f2.getTag(null));
    private final Delegated delegated;
    private String keyTag = "moxy.MvpDelegate.KEY_TAG";
    private String delegateTag;
    private boolean isAttached;
    private MvpDelegate parentDelegate;
    private Set<PresenterField<? super Delegated>> externalPresenterFields = new TreeSet<PresenterField>(COMPARE_BY_TAGS);
    private List<MvpPresenter<? super Delegated>> presenters = Collections.emptyList();
    private List<MvpDelegate> childDelegates;
    private Bundle bundle;

    public MvpDelegate(Delegated delegated) {
        this.delegated = delegated;
        this.childDelegates = new ArrayList<MvpDelegate>();
    }

    public void setParentDelegate(MvpDelegate delegate, String childId) {
        if (this.bundle != null) {
            throw new IllegalStateException("You should call setParentDelegate() before first call to onCreate()");
        }
        if (this.childDelegates != null && this.childDelegates.size() > 0) {
            throw new IllegalStateException("You could not set parent delegate when there are some child presenters already");
        }
        this.parentDelegate = delegate;
        this.keyTag = this.parentDelegate.keyTag + "$" + childId;
        delegate.addChildDelegate(this);
    }

    private void addChildDelegate(MvpDelegate delegate) {
        this.childDelegates.add(delegate);
    }

    private void removeChildDelegate(MvpDelegate delegate) {
        this.childDelegates.remove(delegate);
    }

    public void freeParentDelegate() {
        if (this.parentDelegate == null) {
            throw new IllegalStateException("You should call freeParentDelegate() before first call to setParentDelegate()");
        }
        this.parentDelegate.removeChildDelegate(this);
    }

    public void removeAllChildDelegates() {
        ArrayList<MvpDelegate> childDelegatesClone = new ArrayList<MvpDelegate>(this.childDelegates.size());
        childDelegatesClone.addAll(this.childDelegates);
        for (MvpDelegate childDelegate : childDelegatesClone) {
            childDelegate.freeParentDelegate();
        }
        this.childDelegates = new ArrayList<MvpDelegate>();
    }

    public void onCreate() {
        Bundle bundle = new Bundle();
        if (this.parentDelegate != null) {
            bundle = this.parentDelegate.bundle;
        }
        this.onCreate(bundle);
    }

    public void onCreate(Bundle bundle) {
        if (this.parentDelegate == null && bundle != null) {
            bundle = bundle.getBundle(MOXY_DELEGATE_TAGS_KEY);
        }
        this.isAttached = false;
        this.bundle = bundle != null ? bundle : new Bundle();
        this.delegateTag = bundle == null || !this.bundle.containsKey(this.keyTag) ? this.generateTag() : bundle.getString(this.keyTag);
        this.presenters = MvpFacade.getInstance().getMvpProcessor().getMvpPresenters(this.delegated, this.delegateTag, this.externalPresenterFields);
        for (MvpDelegate childDelegate : this.childDelegates) {
            childDelegate.onCreate(bundle);
        }
    }

    public void onAttach() {
        for (MvpPresenter<Delegated> presenter : this.presenters) {
            if (this.isAttached && presenter.getAttachedViews().contains(this.delegated)) continue;
            presenter.attachView((MvpView)this.delegated);
        }
        for (MvpDelegate childDelegate : this.childDelegates) {
            childDelegate.onAttach();
        }
        this.isAttached = true;
    }

    public void onDetach() {
        for (MvpPresenter<Delegated> presenter : this.presenters) {
            if (!this.isAttached && !presenter.getAttachedViews().contains(this.delegated)) continue;
            presenter.detachView((MvpView)this.delegated);
        }
        this.isAttached = false;
        for (MvpDelegate childDelegate : this.childDelegates) {
            childDelegate.onDetach();
        }
    }

    public void onDestroyView() {
        for (MvpPresenter<Delegated> presenter : this.presenters) {
            presenter.destroyView((MvpView)this.delegated);
        }
        ArrayList<MvpDelegate> childDelegatesClone = new ArrayList<MvpDelegate>(this.childDelegates.size());
        childDelegatesClone.addAll(this.childDelegates);
        for (MvpDelegate childDelegate : childDelegatesClone) {
            childDelegate.onDestroyView();
        }
        if (this.parentDelegate != null) {
            this.freeParentDelegate();
        }
    }

    public void onDestroy() {
        PresentersCounter presentersCounter = MvpFacade.getInstance().getPresentersCounter();
        PresenterStore presenterStore = MvpFacade.getInstance().getPresenterStore();
        Set<MvpPresenter> allChildPresenters = presentersCounter.getAll(this.delegateTag);
        for (MvpPresenter presenter : allChildPresenters) {
            boolean isRejected = presentersCounter.rejectPresenter(presenter, this.delegateTag);
            if (!isRejected) continue;
            presenterStore.remove(presenter.getTag());
            presenter.onDestroy();
        }
    }

    public void onSaveInstanceState() {
        Bundle bundle = new Bundle();
        if (this.parentDelegate != null && this.parentDelegate.bundle != null) {
            bundle = this.parentDelegate.bundle;
        }
        this.onSaveInstanceState(bundle);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.parentDelegate == null) {
            Bundle moxyDelegateBundle = new Bundle();
            outState.putBundle(MOXY_DELEGATE_TAGS_KEY, moxyDelegateBundle);
            outState = moxyDelegateBundle;
        }
        outState.putAll(this.bundle);
        outState.putString(this.keyTag, this.delegateTag);
        for (MvpDelegate childDelegate : this.childDelegates) {
            childDelegate.onSaveInstanceState(outState);
        }
    }

    public Bundle getChildrenSaveState() {
        return this.bundle;
    }

    private String generateTag() {
        String tag = this.parentDelegate != null ? this.parentDelegate.delegateTag + " " : "";
        tag = tag + this.delegated.getClass().getSimpleName() + "$" + this.getClass().getSimpleName() + this.toString().replace(this.getClass().getName(), "");
        return tag;
    }

    public void registerExternalPresenterField(PresenterField<? super Delegated> field) {
        this.externalPresenterFields.add(field);
    }
}

