/*
 * Decompiled with CFR 0.152.
 */
package moxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import moxy.MvpFacade;
import moxy.MvpPresenter;
import moxy.PresenterBinder;
import moxy.PresenterStore;
import moxy.PresentersCounter;
import moxy.locators.PresenterBinderLocator;
import moxy.presenter.PresenterField;

public class MvpProcessor {
    public static final String PRESENTER_BINDER_SUFFIX = "$$PresentersBinder";
    public static final String PRESENTER_BINDER_INNER_SUFFIX = "Binder";
    public static final String VIEW_STATE_SUFFIX = "$$State";
    public static final String VIEW_STATE_PROVIDER_SUFFIX = "$$ViewStateProvider";

    private <Delegated> MvpPresenter<? super Delegated> getMvpPresenter(Delegated target, PresenterField<Delegated> presenterField, String delegateTag) {
        String tag;
        Class<MvpPresenter> presenterClass = presenterField.getPresenterClass();
        PresenterStore presenterStore = MvpFacade.getInstance().getPresenterStore();
        MvpPresenter<?> presenter = presenterStore.get(tag = delegateTag + "$" + presenterField.getTag(target));
        if (presenter != null) {
            return presenter;
        }
        presenter = presenterField.providePresenter(target);
        if (presenter == null) {
            return null;
        }
        presenter.setTag(tag);
        presenter.setPresenterClass(presenterClass);
        presenterStore.add(tag, presenter);
        return presenter;
    }

    <Delegated> List<MvpPresenter<? super Delegated>> getMvpPresenters(Delegated delegated, String delegateTag, Set<PresenterField<? super Delegated>> externalPresenterFields) {
        Class<?> aClass = delegated.getClass();
        PresenterBinder presenterBinder = PresenterBinderLocator.getPresenterBinders(aClass);
        List<PresenterField<Delegated>> presenterFields = this.combinePresenterFields(presenterBinder, externalPresenterFields);
        if (presenterFields.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MvpPresenter<Delegated>> presenters = new ArrayList<MvpPresenter<Delegated>>();
        PresentersCounter presentersCounter = MvpFacade.getInstance().getPresentersCounter();
        for (PresenterField<Delegated> presenterField : presenterFields) {
            MvpPresenter<? super Delegated> presenter = this.getMvpPresenter(delegated, presenterField, delegateTag);
            if (presenter == null) continue;
            presentersCounter.injectPresenter(presenter, delegateTag);
            presenters.add(presenter);
            presenterField.bind(delegated, presenter);
        }
        return presenters;
    }

    private <Delegated> List<PresenterField<? super Delegated>> combinePresenterFields(PresenterBinder<Delegated> presenterBinder, Set<PresenterField<? super Delegated>> externalFields) {
        ArrayList<PresenterField<Delegated>> presenterFields = new ArrayList<PresenterField<Delegated>>();
        if (presenterBinder != null) {
            presenterFields.addAll(presenterBinder.getPresenterFields());
        }
        presenterFields.addAll(externalFields);
        return presenterFields;
    }
}

