/*
 * Decompiled with CFR 0.152.
 */
package moxy;

import android.os.Bundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import moxy.MvpFacade;
import moxy.MvpPresenter;
import moxy.MvpView;
import moxy.PresenterStore;
import moxy.PresentersCounter;

public class MvpDelegate<Delegated> {
    private static final String KEY_TAG = "moxy.MvpDelegate.KEY_TAG";
    public static final String MOXY_DELEGATE_TAGS_KEY = "MoxyDelegateBundle";
    private String mKeyTag = "moxy.MvpDelegate.KEY_TAG";
    private String mDelegateTag;
    private final Delegated mDelegated;
    private boolean mIsAttached;
    private MvpDelegate mParentDelegate;
    private List<MvpPresenter<? super Delegated>> mPresenters = Collections.emptyList();
    private List<MvpDelegate> mChildDelegates;
    private Bundle mBundle;

    public MvpDelegate(Delegated delegated) {
        this.mDelegated = delegated;
        this.mChildDelegates = new ArrayList<MvpDelegate>();
    }

    public void setParentDelegate(MvpDelegate delegate, String childId) {
        if (this.mBundle != null) {
            throw new IllegalStateException("You should call setParentDelegate() before first onCreate()");
        }
        if (this.mChildDelegates != null && this.mChildDelegates.size() > 0) {
            throw new IllegalStateException("You could not set parent delegate when there are already has child presenters");
        }
        this.mParentDelegate = delegate;
        this.mKeyTag = this.mParentDelegate.mKeyTag + "$" + childId;
        delegate.addChildDelegate(this);
    }

    private void addChildDelegate(MvpDelegate delegate) {
        this.mChildDelegates.add(delegate);
    }

    private void removeChildDelegate(MvpDelegate delegate) {
        this.mChildDelegates.remove(delegate);
    }

    public void freeParentDelegate() {
        if (this.mParentDelegate == null) {
            throw new IllegalStateException("You should call freeParentDelegate() before first setParentDelegate()");
        }
        this.mParentDelegate.removeChildDelegate(this);
    }

    public void removeAllChildDelegates() {
        ArrayList<MvpDelegate> childDelegatesClone = new ArrayList<MvpDelegate>(this.mChildDelegates.size());
        childDelegatesClone.addAll(this.mChildDelegates);
        for (MvpDelegate childDelegate : childDelegatesClone) {
            childDelegate.freeParentDelegate();
        }
        this.mChildDelegates = new ArrayList<MvpDelegate>();
    }

    public void onCreate() {
        Bundle bundle = new Bundle();
        if (this.mParentDelegate != null) {
            bundle = this.mParentDelegate.mBundle;
        }
        this.onCreate(bundle);
    }

    public void onCreate(Bundle bundle) {
        if (this.mParentDelegate == null && bundle != null) {
            bundle = bundle.getBundle(MOXY_DELEGATE_TAGS_KEY);
        }
        this.mIsAttached = false;
        this.mBundle = bundle != null ? bundle : new Bundle();
        this.mDelegateTag = bundle == null || !this.mBundle.containsKey(this.mKeyTag) ? this.generateTag() : bundle.getString(this.mKeyTag);
        this.mPresenters = MvpFacade.getInstance().getMvpProcessor().getMvpPresenters(this.mDelegated, this.mDelegateTag);
        for (MvpDelegate childDelegate : this.mChildDelegates) {
            childDelegate.onCreate(bundle);
        }
    }

    public void onAttach() {
        for (MvpPresenter<Delegated> presenter : this.mPresenters) {
            if (this.mIsAttached && presenter.getAttachedViews().contains(this.mDelegated)) continue;
            presenter.attachView((MvpView)this.mDelegated);
        }
        for (MvpDelegate childDelegate : this.mChildDelegates) {
            childDelegate.onAttach();
        }
        this.mIsAttached = true;
    }

    public void onDetach() {
        for (MvpPresenter<Delegated> presenter : this.mPresenters) {
            if (!this.mIsAttached && !presenter.getAttachedViews().contains(this.mDelegated)) continue;
            presenter.detachView((MvpView)this.mDelegated);
        }
        this.mIsAttached = false;
        for (MvpDelegate childDelegate : this.mChildDelegates) {
            childDelegate.onDetach();
        }
    }

    public void onDestroyView() {
        for (MvpPresenter<Delegated> presenter : this.mPresenters) {
            presenter.destroyView((MvpView)this.mDelegated);
        }
        ArrayList<MvpDelegate> childDelegatesClone = new ArrayList<MvpDelegate>(this.mChildDelegates.size());
        childDelegatesClone.addAll(this.mChildDelegates);
        for (MvpDelegate childDelegate : childDelegatesClone) {
            childDelegate.onDestroyView();
        }
        if (this.mParentDelegate != null) {
            this.freeParentDelegate();
        }
    }

    public void onDestroy() {
        PresentersCounter presentersCounter = MvpFacade.getInstance().getPresentersCounter();
        PresenterStore presenterStore = MvpFacade.getInstance().getPresenterStore();
        Set<MvpPresenter> allChildPresenters = presentersCounter.getAll(this.mDelegateTag);
        for (MvpPresenter presenter : allChildPresenters) {
            boolean isRejected = presentersCounter.rejectPresenter(presenter, this.mDelegateTag);
            if (!isRejected) continue;
            presenterStore.remove(presenter.getTag());
            presenter.onDestroy();
        }
    }

    public void onSaveInstanceState() {
        Bundle bundle = new Bundle();
        if (this.mParentDelegate != null && this.mParentDelegate.mBundle != null) {
            bundle = this.mParentDelegate.mBundle;
        }
        this.onSaveInstanceState(bundle);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.mParentDelegate == null) {
            Bundle moxyDelegateBundle = new Bundle();
            outState.putBundle(MOXY_DELEGATE_TAGS_KEY, moxyDelegateBundle);
            outState = moxyDelegateBundle;
        }
        outState.putAll(this.mBundle);
        outState.putString(this.mKeyTag, this.mDelegateTag);
        for (MvpDelegate childDelegate : this.mChildDelegates) {
            childDelegate.onSaveInstanceState(outState);
        }
    }

    public Bundle getChildrenSaveState() {
        return this.mBundle;
    }

    private String generateTag() {
        String tag = this.mParentDelegate != null ? this.mParentDelegate.mDelegateTag + " " : "";
        tag = tag + this.mDelegated.getClass().getSimpleName() + "$" + this.getClass().getSimpleName() + this.toString().replace(this.getClass().getName(), "");
        return tag;
    }
}

