/*
 * Decompiled with CFR 0.152.
 */
package com.grum.geocalc;

import com.grum.geocalc.Coordinate;
import com.grum.geocalc.Point;

public class BoundingArea {
    public final Point northEast;
    public final Point southWest;
    public final Point southEast;
    public final Point northWest;

    private BoundingArea(Point northEast, Point southWest) {
        this.northEast = northEast;
        this.southWest = southWest;
        this.southEast = Point.at(Coordinate.fromDegrees(southWest.latitude), Coordinate.fromDegrees(northEast.longitude));
        this.northWest = Point.at(Coordinate.fromDegrees(northEast.latitude), Coordinate.fromDegrees(southWest.longitude));
    }

    public static BoundingArea at(Point northEast, Point southWest) {
        return new BoundingArea(northEast, southWest);
    }

    public String toString() {
        return "BoundingArea{northEast=" + this.northEast + ", southWest=" + this.southWest + '}';
    }

    @Deprecated
    public boolean isContainedWithin(Point point) {
        return this.contains(point);
    }

    public boolean contains(Point point) {
        boolean predicate2;
        boolean predicate1;
        boolean bl = predicate1 = point.latitude >= this.southWest.latitude && point.latitude <= this.northEast.latitude;
        if (!predicate1) {
            return false;
        }
        if (this.southWest.longitude > this.northEast.longitude) {
            boolean predicate3 = point.longitude <= this.northEast.longitude && point.longitude >= -180.0;
            boolean predicate4 = point.longitude >= this.southWest.longitude && point.longitude <= 180.0;
            predicate2 = predicate3 || predicate4;
        } else {
            predicate2 = point.longitude >= this.southWest.longitude && point.longitude <= this.northEast.longitude;
        }
        return predicate2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingArea other = (BoundingArea)obj;
        if (!(this.northEast == other.northEast || this.northEast != null && this.northEast.equals(other.northEast))) {
            return false;
        }
        return this.southWest == other.southWest || this.southWest != null && this.southWest.equals(other.southWest);
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (this.northEast != null ? this.northEast.hashCode() : 0);
        hash = 13 * hash + (this.southWest != null ? this.southWest.hashCode() : 0);
        return hash;
    }
}

