/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.BarHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.utils.MPPointD;

public class HorizontalBarHighlighter
extends BarHighlighter {
    public HorizontalBarHighlighter(BarDataProvider chart) {
        super(chart);
    }

    @Override
    public Highlight getHighlight(float x, float y) {
        BarData barData = ((BarDataProvider)this.mChart).getBarData();
        MPPointD pos = this.getValsForTouch(y, x);
        Highlight high = this.getHighlightForX((float)pos.y, y, x);
        if (high == null) {
            return null;
        }
        IBarDataSet set = (IBarDataSet)barData.getDataSetByIndex(high.getDataSetIndex());
        if (set.isStacked()) {
            return this.getStackedHighlight(high, set, (float)pos.y, (float)pos.x);
        }
        MPPointD.recycleInstance(pos);
        return high;
    }

    @Override
    protected Highlight buildHighlight(IDataSet set, int dataSetIndex, float xVal, DataSet.Rounding rounding) {
        Object e = set.getEntryForXPos(xVal, rounding);
        MPPointD pixels = ((BarDataProvider)this.mChart).getTransformer(set.getAxisDependency()).getPixelsForValues(((BaseEntry)e).getY(), ((Entry)e).getX());
        return new Highlight(((Entry)e).getX(), ((BaseEntry)e).getY(), (float)pixels.x, (float)pixels.y, dataSetIndex, set.getAxisDependency());
    }

    @Override
    protected float getDistance(float x1, float y1, float x2, float y2) {
        return Math.abs(y1 - y2);
    }
}

