/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.interfaces.datasets.IRadarDataSet;
import com.github.mikephil.charting.renderer.YAxisRenderer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class YAxisRendererRadarChart
extends YAxisRenderer {
    private RadarChart mChart;

    public YAxisRendererRadarChart(ViewPortHandler viewPortHandler, YAxis yAxis, RadarChart chart) {
        super(viewPortHandler, yAxis, null);
        this.mChart = chart;
    }

    @Override
    protected void computeAxisValues(float min, float max) {
        boolean centeringEnabled;
        int n;
        double intervalMagnitude;
        int intervalSigDigit;
        float yMin = min;
        float yMax = max;
        int labelCount = this.mAxis.getLabelCount();
        double range = Math.abs(yMax - yMin);
        if (labelCount == 0 || range <= 0.0) {
            this.mAxis.mEntries = new float[0];
            this.mAxis.mEntryCount = 0;
            return;
        }
        double rawInterval = range / (double)labelCount;
        double interval = Utils.roundToNextSignificant(rawInterval);
        if (this.mAxis.isGranularityEnabled()) {
            double d = interval = interval < (double)this.mAxis.getGranularity() ? (double)this.mAxis.getGranularity() : interval;
        }
        if ((intervalSigDigit = (int)(interval / (intervalMagnitude = (double)Utils.roundToNextSignificant(Math.pow(10.0, (int)Math.log10(interval)))))) > 5) {
            interval = Math.floor(10.0 * intervalMagnitude);
        }
        int n2 = n = (centeringEnabled = this.mAxis.isCenterAxisLabelsEnabled()) ? 1 : 0;
        if (this.mAxis.isForceLabelsEnabled()) {
            float step = (float)range / (float)(labelCount - 1);
            this.mAxis.mEntryCount = labelCount;
            if (this.mAxis.mEntries.length < labelCount) {
                this.mAxis.mEntries = new float[labelCount];
            }
            float v = min;
            for (int i = 0; i < labelCount; ++i) {
                this.mAxis.mEntries[i] = v;
                v += step;
            }
            n = labelCount;
        } else {
            double f;
            double last;
            double first;
            double d = first = interval == 0.0 ? 0.0 : Math.ceil((double)yMin / interval) * interval;
            if (centeringEnabled) {
                first -= interval;
            }
            double d2 = last = interval == 0.0 ? 0.0 : Utils.nextUp(Math.floor((double)yMax / interval) * interval);
            if (interval != 0.0) {
                for (f = first; f <= last; f += interval) {
                    ++n;
                }
            }
            this.mAxis.mEntryCount = ++n;
            if (this.mAxis.mEntries.length < n) {
                this.mAxis.mEntries = new float[n];
            }
            f = first;
            for (int i = 0; i < n; ++i) {
                if (f == 0.0) {
                    f = 0.0;
                }
                this.mAxis.mEntries[i] = (float)f;
                f += interval;
            }
        }
        this.mAxis.mDecimals = interval < 1.0 ? (int)Math.ceil(-Math.log10(interval)) : 0;
        if (centeringEnabled) {
            if (this.mAxis.mCenteredEntries.length < n) {
                this.mAxis.mCenteredEntries = new float[n];
            }
            float offset = (this.mAxis.mEntries[1] - this.mAxis.mEntries[0]) / 2.0f;
            for (int i = 0; i < n; ++i) {
                this.mAxis.mCenteredEntries[i] = this.mAxis.mEntries[i] + offset;
            }
        }
        this.mAxis.mAxisMinimum = this.mAxis.mEntries[0];
        this.mAxis.mAxisMaximum = this.mAxis.mEntries[n - 1];
        this.mAxis.mAxisRange = Math.abs(this.mAxis.mAxisMaximum - this.mAxis.mAxisMinimum);
    }

    @Override
    public void renderAxisLabels(Canvas c) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawLabelsEnabled()) {
            return;
        }
        this.mAxisLabelPaint.setTypeface(this.mYAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mYAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mYAxis.getTextColor());
        PointF center = this.mChart.getCenterOffsets();
        float factor = this.mChart.getFactor();
        int labelCount = this.mYAxis.mEntryCount;
        for (int j = 0; j < labelCount && (j != labelCount - 1 || this.mYAxis.isDrawTopYLabelEntryEnabled()); ++j) {
            float r = (this.mYAxis.mEntries[j] - this.mYAxis.mAxisMinimum) * factor;
            PointF p = Utils.getPosition(center, r, this.mChart.getRotationAngle());
            String label = this.mYAxis.getFormattedLabel(j);
            c.drawText(label, p.x + 10.0f, p.y, this.mAxisLabelPaint);
        }
    }

    @Override
    public void renderLimitLines(Canvas c) {
        List<LimitLine> limitLines = this.mYAxis.getLimitLines();
        if (limitLines == null) {
            return;
        }
        float sliceangle = this.mChart.getSliceAngle();
        float factor = this.mChart.getFactor();
        PointF center = this.mChart.getCenterOffsets();
        for (int i = 0; i < limitLines.size(); ++i) {
            LimitLine l = limitLines.get(i);
            if (!l.isEnabled()) continue;
            this.mLimitLinePaint.setColor(l.getLineColor());
            this.mLimitLinePaint.setPathEffect((PathEffect)l.getDashPathEffect());
            this.mLimitLinePaint.setStrokeWidth(l.getLineWidth());
            float r = (l.getLimit() - this.mChart.getYChartMin()) * factor;
            Path limitPath = new Path();
            for (int j = 0; j < ((IRadarDataSet)((RadarData)this.mChart.getData()).getMaxEntryCountSet()).getEntryCount(); ++j) {
                PointF p = Utils.getPosition(center, r, sliceangle * (float)j + this.mChart.getRotationAngle());
                if (j == 0) {
                    limitPath.moveTo(p.x, p.y);
                    continue;
                }
                limitPath.lineTo(p.x, p.y);
            }
            limitPath.close();
            c.drawPath(limitPath, this.mLimitLinePaint);
        }
    }
}

