/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.data.RadarEntry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IRadarDataSet;
import com.github.mikephil.charting.renderer.LineRadarRenderer;
import com.github.mikephil.charting.utils.ColorTemplate;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;

public class RadarChartRenderer
extends LineRadarRenderer {
    protected RadarChart mChart;
    protected Paint mWebPaint;
    protected Paint mHighlightCirclePaint;

    public RadarChartRenderer(RadarChart chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(2.0f);
        this.mHighlightPaint.setColor(Color.rgb((int)255, (int)187, (int)115));
        this.mWebPaint = new Paint(1);
        this.mWebPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightCirclePaint = new Paint(1);
    }

    public Paint getWebPaint() {
        return this.mWebPaint;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas c) {
        RadarData radarData = (RadarData)this.mChart.getData();
        int mostEntries = ((IRadarDataSet)radarData.getMaxEntryCountSet()).getEntryCount();
        for (IRadarDataSet set : radarData.getDataSets()) {
            if (!set.isVisible() || set.getEntryCount() <= 0) continue;
            this.drawDataSet(c, set, mostEntries);
        }
    }

    protected void drawDataSet(Canvas c, IRadarDataSet dataSet, int mostEntries) {
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        float sliceangle = this.mChart.getSliceAngle();
        float factor = this.mChart.getFactor();
        PointF center = this.mChart.getCenterOffsets();
        Path surface = new Path();
        boolean hasMovedToPoint = false;
        for (int j = 0; j < dataSet.getEntryCount(); ++j) {
            this.mRenderPaint.setColor(dataSet.getColor(j));
            RadarEntry e = (RadarEntry)dataSet.getEntryForIndex(j);
            PointF p = Utils.getPosition(center, (e.getY() - this.mChart.getYChartMin()) * factor * phaseY, sliceangle * (float)j * phaseX + this.mChart.getRotationAngle());
            if (Float.isNaN(p.x)) continue;
            if (!hasMovedToPoint) {
                surface.moveTo(p.x, p.y);
                hasMovedToPoint = true;
                continue;
            }
            surface.lineTo(p.x, p.y);
        }
        if (dataSet.getEntryCount() > mostEntries) {
            surface.lineTo(center.x, center.y);
        }
        surface.close();
        if (dataSet.isDrawFilledEnabled()) {
            Drawable drawable = dataSet.getFillDrawable();
            if (drawable != null) {
                this.drawFilledPath(c, surface, drawable);
            } else {
                this.drawFilledPath(c, surface, dataSet.getFillColor(), dataSet.getFillAlpha());
            }
        }
        this.mRenderPaint.setStrokeWidth(dataSet.getLineWidth());
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        if (!dataSet.isDrawFilledEnabled() || dataSet.getFillAlpha() < 255) {
            c.drawPath(surface, this.mRenderPaint);
        }
    }

    @Override
    public void drawValues(Canvas c) {
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        float sliceangle = this.mChart.getSliceAngle();
        float factor = this.mChart.getFactor();
        PointF center = this.mChart.getCenterOffsets();
        float yoffset = Utils.convertDpToPixel(5.0f);
        for (int i = 0; i < ((RadarData)this.mChart.getData()).getDataSetCount(); ++i) {
            IRadarDataSet dataSet = (IRadarDataSet)((RadarData)this.mChart.getData()).getDataSetByIndex(i);
            if (!dataSet.isDrawValuesEnabled() || dataSet.getEntryCount() == 0) continue;
            this.applyValueTextStyle(dataSet);
            for (int j = 0; j < dataSet.getEntryCount(); ++j) {
                RadarEntry entry = (RadarEntry)dataSet.getEntryForIndex(j);
                PointF p = Utils.getPosition(center, (entry.getY() - this.mChart.getYChartMin()) * factor * phaseY, sliceangle * (float)j * phaseX + this.mChart.getRotationAngle());
                this.drawValue(c, dataSet.getValueFormatter(), entry.getY(), entry, i, p.x, p.y - yoffset, dataSet.getValueTextColor(j));
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        this.drawWeb(c);
    }

    protected void drawWeb(Canvas c) {
        float sliceangle = this.mChart.getSliceAngle();
        float factor = this.mChart.getFactor();
        float rotationangle = this.mChart.getRotationAngle();
        PointF center = this.mChart.getCenterOffsets();
        this.mWebPaint.setStrokeWidth(this.mChart.getWebLineWidth());
        this.mWebPaint.setColor(this.mChart.getWebColor());
        this.mWebPaint.setAlpha(this.mChart.getWebAlpha());
        int xIncrements = 1 + this.mChart.getSkipWebLineCount();
        int maxEntryCount = ((IRadarDataSet)((RadarData)this.mChart.getData()).getMaxEntryCountSet()).getEntryCount();
        for (int i = 0; i < maxEntryCount; i += xIncrements) {
            PointF p = Utils.getPosition(center, this.mChart.getYRange() * factor, sliceangle * (float)i + rotationangle);
            c.drawLine(center.x, center.y, p.x, p.y, this.mWebPaint);
        }
        this.mWebPaint.setStrokeWidth(this.mChart.getWebLineWidthInner());
        this.mWebPaint.setColor(this.mChart.getWebColorInner());
        this.mWebPaint.setAlpha(this.mChart.getWebAlpha());
        int labelCount = this.mChart.getYAxis().mEntryCount;
        for (int j = 0; j < labelCount; ++j) {
            for (int i = 0; i < ((RadarData)this.mChart.getData()).getEntryCount(); ++i) {
                float r = (this.mChart.getYAxis().mEntries[j] - this.mChart.getYChartMin()) * factor;
                PointF p1 = Utils.getPosition(center, r, sliceangle * (float)i + rotationangle);
                PointF p2 = Utils.getPosition(center, r, sliceangle * (float)(i + 1) + rotationangle);
                c.drawLine(p1.x, p1.y, p2.x, p2.y, this.mWebPaint);
            }
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        float sliceangle = this.mChart.getSliceAngle();
        float factor = this.mChart.getFactor();
        PointF center = this.mChart.getCenterOffsets();
        RadarData radarData = (RadarData)this.mChart.getData();
        for (Highlight high : indices) {
            RadarEntry e;
            IRadarDataSet set = (IRadarDataSet)radarData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !this.isInBoundsX(e = (RadarEntry)set.getEntryForIndex((int)high.getX()), set)) continue;
            float y = e.getY() - this.mChart.getYChartMin();
            PointF p = Utils.getPosition(center, y * factor * this.mAnimator.getPhaseY(), sliceangle * high.getX() * this.mAnimator.getPhaseX() + this.mChart.getRotationAngle());
            high.setDraw(p.x, p.y);
            this.drawHighlightLines(c, p.x, p.y, set);
            if (!set.isDrawHighlightCircleEnabled() || Float.isNaN(p.x) || Float.isNaN(p.y)) continue;
            int strokeColor = set.getHighlightCircleStrokeColor();
            if (strokeColor == 0x112233) {
                strokeColor = set.getColor(0);
            }
            if (set.getHighlightCircleStrokeAlpha() < 255) {
                strokeColor = ColorTemplate.getColorWithAlphaComponent(strokeColor, set.getHighlightCircleStrokeAlpha());
            }
            this.drawHighlightCircle(c, p, set.getHighlightCircleInnerRadius(), set.getHighlightCircleOuterRadius(), set.getHighlightCircleFillColor(), strokeColor, set.getHighlightCircleStrokeWidth());
        }
    }

    public void drawHighlightCircle(Canvas c, PointF point, float innerRadius, float outerRadius, int fillColor, int strokeColor, float strokeWidth) {
        c.save();
        outerRadius = Utils.convertDpToPixel(outerRadius);
        innerRadius = Utils.convertDpToPixel(innerRadius);
        if (fillColor != 0x112233) {
            Path p = new Path();
            p.addCircle(point.x, point.y, outerRadius, Path.Direction.CW);
            if (innerRadius > 0.0f) {
                p.addCircle(point.x, point.y, innerRadius, Path.Direction.CCW);
            }
            this.mHighlightCirclePaint.setColor(fillColor);
            this.mHighlightCirclePaint.setStyle(Paint.Style.FILL);
            c.drawPath(p, this.mHighlightCirclePaint);
        }
        if (strokeColor != 0x112233) {
            this.mHighlightCirclePaint.setColor(strokeColor);
            this.mHighlightCirclePaint.setStyle(Paint.Style.STROKE);
            this.mHighlightCirclePaint.setStrokeWidth(Utils.convertDpToPixel(strokeWidth));
            c.drawCircle(point.x, point.y, outerRadius, this.mHighlightCirclePaint);
        }
        c.restore();
    }
}

