/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import android.graphics.PointF;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.PieRadarHighlighter;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class RadarHighlighter
extends PieRadarHighlighter<RadarChart> {
    public RadarHighlighter(RadarChart chart) {
        super(chart);
    }

    @Override
    protected Highlight getClosestHighlight(int index, float x, float y) {
        List<Highlight> highlights = this.getHighlightsAtIndex(index);
        float distanceToCenter = ((RadarChart)this.mChart).distanceToCenter(x, y) / ((RadarChart)this.mChart).getFactor();
        Highlight closest = null;
        float distance = Float.MAX_VALUE;
        for (int i = 0; i < highlights.size(); ++i) {
            Highlight high = highlights.get(i);
            float cdistance = Math.abs(high.getY() - distanceToCenter);
            if (!(cdistance < distance)) continue;
            closest = high;
            distance = cdistance;
        }
        return closest;
    }

    protected List<Highlight> getHighlightsAtIndex(int index) {
        ArrayList<Highlight> vals = new ArrayList<Highlight>();
        float phaseX = ((RadarChart)this.mChart).getAnimator().getPhaseX();
        float phaseY = ((RadarChart)this.mChart).getAnimator().getPhaseY();
        float sliceangle = ((RadarChart)this.mChart).getSliceAngle();
        float factor = ((RadarChart)this.mChart).getFactor();
        for (int i = 0; i < ((RadarData)((RadarChart)this.mChart).getData()).getDataSetCount(); ++i) {
            Object dataSet = ((RadarData)((RadarChart)this.mChart).getData()).getDataSetByIndex(i);
            Object entry = dataSet.getEntryForIndex(index);
            float y = ((BaseEntry)entry).getY() - ((RadarChart)this.mChart).getYChartMin();
            PointF p = Utils.getPosition(((RadarChart)this.mChart).getCenterOffsets(), y * factor * phaseY, sliceangle * (float)index * phaseX + ((RadarChart)this.mChart).getRotationAngle());
            vals.add(new Highlight(index, ((BaseEntry)entry).getY(), p.x, p.y, i, dataSet.getAxisDependency()));
        }
        return vals;
    }
}

