/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.LineDataProvider;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.github.mikephil.charting.renderer.LineRadarRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.List;

public class LineChartRenderer
extends LineRadarRenderer {
    protected LineDataProvider mChart;
    protected Paint mCirclePaintInner;
    protected WeakReference<Bitmap> mDrawBitmap;
    protected Canvas mBitmapCanvas;
    protected Bitmap.Config mBitmapConfig = Bitmap.Config.ARGB_8888;
    protected Path cubicPath = new Path();
    protected Path cubicFillPath = new Path();
    private float[] mLineBuffer = new float[4];

    public LineChartRenderer(LineDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mCirclePaintInner = new Paint(1);
        this.mCirclePaintInner.setStyle(Paint.Style.FILL);
        this.mCirclePaintInner.setColor(-1);
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas c) {
        int width = (int)this.mViewPortHandler.getChartWidth();
        int height = (int)this.mViewPortHandler.getChartHeight();
        if (this.mDrawBitmap == null || ((Bitmap)this.mDrawBitmap.get()).getWidth() != width || ((Bitmap)this.mDrawBitmap.get()).getHeight() != height) {
            if (width > 0 && height > 0) {
                this.mDrawBitmap = new WeakReference<Bitmap>(Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)this.mBitmapConfig));
                this.mBitmapCanvas = new Canvas((Bitmap)this.mDrawBitmap.get());
            } else {
                return;
            }
        }
        ((Bitmap)this.mDrawBitmap.get()).eraseColor(0);
        LineData lineData = this.mChart.getLineData();
        for (ILineDataSet set : lineData.getDataSets()) {
            if (!set.isVisible() || set.getEntryCount() <= 0) continue;
            this.drawDataSet(c, set);
        }
        c.drawBitmap((Bitmap)this.mDrawBitmap.get(), 0.0f, 0.0f, this.mRenderPaint);
    }

    protected void drawDataSet(Canvas c, ILineDataSet dataSet) {
        if (dataSet.getEntryCount() < 1) {
            return;
        }
        this.mRenderPaint.setStrokeWidth(dataSet.getLineWidth());
        this.mRenderPaint.setPathEffect((PathEffect)dataSet.getDashPathEffect());
        if (dataSet.isDrawCubicEnabled()) {
            this.drawCubic(c, dataSet);
        } else {
            this.drawLinear(c, dataSet);
        }
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawCubic(Canvas c, ILineDataSet dataSet) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        int entryCount = dataSet.getEntryCount();
        Object entryFrom = dataSet.getEntryForXIndex(this.mMinX < 0 ? 0 : this.mMinX, DataSet.Rounding.DOWN);
        Object entryTo = dataSet.getEntryForXIndex(this.mMaxX, DataSet.Rounding.UP);
        int diff = entryFrom == entryTo ? 1 : 0;
        int minx = Math.max(dataSet.getEntryIndex(entryFrom) - diff, 0);
        int maxx = Math.min(Math.max(minx + 2, dataSet.getEntryIndex(entryTo) + 1), entryCount);
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        float intensity = dataSet.getCubicIntensity();
        this.cubicPath.reset();
        int size = (int)Math.ceil((float)(maxx - minx) * phaseX + (float)minx);
        if (size - minx >= 2) {
            Object prevPrev;
            Object prev;
            float prevDx = 0.0f;
            float prevDy = 0.0f;
            float curDx = 0.0f;
            float curDy = 0.0f;
            Object cur = prev = (prevPrev = dataSet.getEntryForIndex(minx));
            Object next = dataSet.getEntryForIndex(minx + 1);
            this.cubicPath.moveTo((float)((Entry)cur).getXIndex(), ((Entry)cur).getVal() * phaseY);
            int count = Math.min(size, entryCount - 1);
            for (int j = minx + 1; j < count; ++j) {
                prevPrev = dataSet.getEntryForIndex(j == 1 ? 0 : j - 2);
                prev = dataSet.getEntryForIndex(j - 1);
                cur = dataSet.getEntryForIndex(j);
                next = dataSet.getEntryForIndex(j + 1);
                prevDx = (float)(((Entry)cur).getXIndex() - ((Entry)prevPrev).getXIndex()) * intensity;
                prevDy = (((Entry)cur).getVal() - ((Entry)prevPrev).getVal()) * intensity;
                curDx = (float)(((Entry)next).getXIndex() - ((Entry)prev).getXIndex()) * intensity;
                curDy = (((Entry)next).getVal() - ((Entry)prev).getVal()) * intensity;
                this.cubicPath.cubicTo((float)((Entry)prev).getXIndex() + prevDx, (((Entry)prev).getVal() + prevDy) * phaseY, (float)((Entry)cur).getXIndex() - curDx, (((Entry)cur).getVal() - curDy) * phaseY, (float)((Entry)cur).getXIndex(), ((Entry)cur).getVal() * phaseY);
            }
            if (size > entryCount - 1) {
                prevPrev = dataSet.getEntryForIndex(entryCount >= 3 ? entryCount - 3 : entryCount - 2);
                prev = dataSet.getEntryForIndex(entryCount - 2);
                next = cur = dataSet.getEntryForIndex(entryCount - 1);
                prevDx = (float)(((Entry)cur).getXIndex() - ((Entry)prevPrev).getXIndex()) * intensity;
                prevDy = (((Entry)cur).getVal() - ((Entry)prevPrev).getVal()) * intensity;
                curDx = (float)(((Entry)next).getXIndex() - ((Entry)prev).getXIndex()) * intensity;
                curDy = (((Entry)next).getVal() - ((Entry)prev).getVal()) * intensity;
                this.cubicPath.cubicTo((float)((Entry)prev).getXIndex() + prevDx, (((Entry)prev).getVal() + prevDy) * phaseY, (float)((Entry)cur).getXIndex() - curDx, (((Entry)cur).getVal() - curDy) * phaseY, (float)((Entry)cur).getXIndex(), ((Entry)cur).getVal() * phaseY);
            }
        }
        if (dataSet.isDrawFilledEnabled()) {
            this.cubicFillPath.reset();
            this.cubicFillPath.addPath(this.cubicPath);
            this.drawCubicFill(this.mBitmapCanvas, dataSet, this.cubicFillPath, trans, minx, size);
        }
        this.mRenderPaint.setColor(dataSet.getColor());
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        trans.pathValueToPixel(this.cubicPath);
        this.mBitmapCanvas.drawPath(this.cubicPath, this.mRenderPaint);
        this.mRenderPaint.setPathEffect(null);
    }

    protected void drawCubicFill(Canvas c, ILineDataSet dataSet, Path spline, Transformer trans, int from, int to) {
        if (to - from <= 1) {
            return;
        }
        float fillMin = dataSet.getFillFormatter().getFillLinePosition(dataSet, this.mChart);
        Object toEntry = dataSet.getEntryForIndex(to - 1);
        Object fromEntry = dataSet.getEntryForIndex(from);
        float xTo = toEntry == null ? 0.0f : (float)((Entry)toEntry).getXIndex();
        float xFrom = fromEntry == null ? 0.0f : (float)((Entry)fromEntry).getXIndex();
        spline.lineTo(xTo, fillMin);
        spline.lineTo(xFrom, fillMin);
        spline.close();
        trans.pathValueToPixel(spline);
        Drawable drawable = dataSet.getFillDrawable();
        if (drawable != null) {
            this.drawFilledPath(c, spline, drawable);
        } else {
            this.drawFilledPath(c, spline, dataSet.getFillColor(), dataSet.getFillAlpha());
        }
    }

    protected void drawLinear(Canvas c, ILineDataSet dataSet) {
        int entryCount = dataSet.getEntryCount();
        boolean isDrawSteppedEnabled = dataSet.isDrawSteppedEnabled();
        int pointsPerEntryPair = isDrawSteppedEnabled ? 4 : 2;
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        this.mRenderPaint.setStyle(Paint.Style.STROKE);
        Canvas canvas = null;
        canvas = dataSet.isDashedLineEnabled() ? this.mBitmapCanvas : c;
        Object entryFrom = dataSet.getEntryForXIndex(this.mMinX < 0 ? 0 : this.mMinX, DataSet.Rounding.DOWN);
        Object entryTo = dataSet.getEntryForXIndex(this.mMaxX, DataSet.Rounding.UP);
        int diff = entryFrom == entryTo ? 1 : 0;
        int minx = Math.max(dataSet.getEntryIndex(entryFrom) - diff, 0);
        int maxx = Math.min(Math.max(minx + 2, dataSet.getEntryIndex(entryTo) + 1), entryCount);
        int count = (int)Math.ceil((float)(maxx - minx) * phaseX + (float)minx);
        if (dataSet.getColors().size() > 1) {
            if (this.mLineBuffer.length != pointsPerEntryPair * 2) {
                this.mLineBuffer = new float[pointsPerEntryPair * 2];
            }
            for (int j = minx; j < count && (count <= 1 || j != count - 1); ++j) {
                Object e = dataSet.getEntryForIndex(j);
                if (e == null) continue;
                this.mLineBuffer[0] = ((Entry)e).getXIndex();
                this.mLineBuffer[1] = ((Entry)e).getVal() * phaseY;
                if (j + 1 < count) {
                    e = dataSet.getEntryForIndex(j + 1);
                    if (e == null) break;
                    if (isDrawSteppedEnabled) {
                        this.mLineBuffer[2] = ((Entry)e).getXIndex();
                        this.mLineBuffer[3] = this.mLineBuffer[1];
                        this.mLineBuffer[4] = this.mLineBuffer[2];
                        this.mLineBuffer[5] = this.mLineBuffer[3];
                        this.mLineBuffer[6] = ((Entry)e).getXIndex();
                        this.mLineBuffer[7] = ((Entry)e).getVal() * phaseY;
                    } else {
                        this.mLineBuffer[2] = ((Entry)e).getXIndex();
                        this.mLineBuffer[3] = ((Entry)e).getVal() * phaseY;
                    }
                } else {
                    this.mLineBuffer[2] = this.mLineBuffer[0];
                    this.mLineBuffer[3] = this.mLineBuffer[1];
                }
                trans.pointValuesToPixel(this.mLineBuffer);
                if (this.mViewPortHandler.isInBoundsRight(this.mLineBuffer[0])) {
                    if (!this.mViewPortHandler.isInBoundsLeft(this.mLineBuffer[2]) || !this.mViewPortHandler.isInBoundsTop(this.mLineBuffer[1]) && !this.mViewPortHandler.isInBoundsBottom(this.mLineBuffer[3]) || !this.mViewPortHandler.isInBoundsTop(this.mLineBuffer[1]) && !this.mViewPortHandler.isInBoundsBottom(this.mLineBuffer[3])) continue;
                    this.mRenderPaint.setColor(dataSet.getColor(j));
                    canvas.drawLines(this.mLineBuffer, 0, pointsPerEntryPair * 2, this.mRenderPaint);
                    continue;
                }
                break;
            }
        } else {
            Object e1;
            if (this.mLineBuffer.length != Math.max((entryCount - 1) * pointsPerEntryPair, pointsPerEntryPair) * 2) {
                this.mLineBuffer = new float[Math.max((entryCount - 1) * pointsPerEntryPair, pointsPerEntryPair) * 2];
            }
            if ((e1 = dataSet.getEntryForIndex(minx)) != null) {
                int j = 0;
                for (int x = count > 1 ? minx + 1 : minx; x < count; ++x) {
                    e1 = dataSet.getEntryForIndex(x == 0 ? 0 : x - 1);
                    Object e2 = dataSet.getEntryForIndex(x);
                    if (e1 == null || e2 == null) continue;
                    this.mLineBuffer[j++] = ((Entry)e1).getXIndex();
                    this.mLineBuffer[j++] = ((Entry)e1).getVal() * phaseY;
                    if (isDrawSteppedEnabled) {
                        this.mLineBuffer[j++] = ((Entry)e2).getXIndex();
                        this.mLineBuffer[j++] = ((Entry)e1).getVal() * phaseY;
                        this.mLineBuffer[j++] = ((Entry)e2).getXIndex();
                        this.mLineBuffer[j++] = ((Entry)e1).getVal() * phaseY;
                    }
                    this.mLineBuffer[j++] = ((Entry)e2).getXIndex();
                    this.mLineBuffer[j++] = ((Entry)e2).getVal() * phaseY;
                }
                trans.pointValuesToPixel(this.mLineBuffer);
                int size = Math.max((count - minx - 1) * pointsPerEntryPair, pointsPerEntryPair) * 2;
                this.mRenderPaint.setColor(dataSet.getColor());
                canvas.drawLines(this.mLineBuffer, 0, size, this.mRenderPaint);
            }
        }
        this.mRenderPaint.setPathEffect(null);
        if (dataSet.isDrawFilledEnabled() && entryCount > 0) {
            this.drawLinearFill(c, dataSet, minx, maxx, trans);
        }
    }

    protected void drawLinearFill(Canvas c, ILineDataSet dataSet, int minx, int maxx, Transformer trans) {
        Path filled = this.generateFilledPath(dataSet, minx, maxx);
        trans.pathValueToPixel(filled);
        Drawable drawable = dataSet.getFillDrawable();
        if (drawable != null) {
            this.drawFilledPath(c, filled, drawable);
        } else {
            this.drawFilledPath(c, filled, dataSet.getFillColor(), dataSet.getFillAlpha());
        }
    }

    private Path generateFilledPath(ILineDataSet dataSet, int from, int to) {
        float fillMin = dataSet.getFillFormatter().getFillLinePosition(dataSet, this.mChart);
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        boolean isDrawSteppedEnabled = dataSet.isDrawSteppedEnabled();
        Path filled = new Path();
        Object entry = dataSet.getEntryForIndex(from);
        filled.moveTo((float)((Entry)entry).getXIndex(), fillMin);
        filled.lineTo((float)((Entry)entry).getXIndex(), ((Entry)entry).getVal() * phaseY);
        int count = (int)Math.ceil((float)(to - from) * phaseX + (float)from);
        for (int x = from + 1; x < count; ++x) {
            Object e = dataSet.getEntryForIndex(x);
            if (isDrawSteppedEnabled) {
                Object ePrev = dataSet.getEntryForIndex(x - 1);
                if (ePrev == null) continue;
                filled.lineTo((float)((Entry)e).getXIndex(), ((Entry)ePrev).getVal() * phaseY);
            }
            filled.lineTo((float)((Entry)e).getXIndex(), ((Entry)e).getVal() * phaseY);
        }
        filled.lineTo((float)((Entry)dataSet.getEntryForIndex(Math.max(Math.min((int)Math.ceil((float)(to - from) * phaseX + (float)from) - 1, dataSet.getEntryCount() - 1), 0))).getXIndex(), fillMin);
        filled.close();
        return filled;
    }

    @Override
    public void drawValues(Canvas c) {
        if ((float)this.mChart.getLineData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX()) {
            List dataSets = this.mChart.getLineData().getDataSets();
            block0: for (int i = 0; i < dataSets.size(); ++i) {
                ILineDataSet dataSet = (ILineDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled() || dataSet.getEntryCount() == 0) continue;
                this.applyValueTextStyle(dataSet);
                Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                int valOffset = (int)(dataSet.getCircleRadius() * 1.75f);
                if (!dataSet.isDrawCirclesEnabled()) {
                    valOffset /= 2;
                }
                int entryCount = dataSet.getEntryCount();
                Object entryFrom = dataSet.getEntryForXIndex(this.mMinX < 0 ? 0 : this.mMinX, DataSet.Rounding.DOWN);
                Object entryTo = dataSet.getEntryForXIndex(this.mMaxX, DataSet.Rounding.UP);
                int diff = entryFrom == entryTo ? 1 : 0;
                int minx = Math.max(dataSet.getEntryIndex(entryFrom) - diff, 0);
                int maxx = Math.min(Math.max(minx + 2, dataSet.getEntryIndex(entryTo) + 1), entryCount);
                float[] positions = trans.generateTransformedValuesLine(dataSet, this.mAnimator.getPhaseX(), this.mAnimator.getPhaseY(), minx, maxx);
                for (int j = 0; j < positions.length; j += 2) {
                    float x = positions[j];
                    float y = positions[j + 1];
                    if (!this.mViewPortHandler.isInBoundsRight(x)) continue block0;
                    if (!this.mViewPortHandler.isInBoundsLeft(x) || !this.mViewPortHandler.isInBoundsY(y)) continue;
                    Object entry = dataSet.getEntryForIndex(j / 2 + minx);
                    this.drawValue(c, dataSet.getValueFormatter(), ((Entry)entry).getVal(), (Entry)entry, i, x, y - (float)valOffset, dataSet.getValueTextColor(j / 2));
                }
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        this.drawCircles(c);
    }

    protected void drawCircles(Canvas c) {
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        float[] circlesBuffer = new float[2];
        List dataSets = this.mChart.getLineData().getDataSets();
        block0: for (int i = 0; i < dataSets.size(); ++i) {
            Object e;
            ILineDataSet dataSet = (ILineDataSet)dataSets.get(i);
            if (!dataSet.isVisible() || !dataSet.isDrawCirclesEnabled() || dataSet.getEntryCount() == 0) continue;
            this.mCirclePaintInner.setColor(dataSet.getCircleHoleColor());
            Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
            int entryCount = dataSet.getEntryCount();
            Object entryFrom = dataSet.getEntryForXIndex(this.mMinX < 0 ? 0 : this.mMinX, DataSet.Rounding.DOWN);
            Object entryTo = dataSet.getEntryForXIndex(this.mMaxX, DataSet.Rounding.UP);
            int diff = entryFrom == entryTo ? 1 : 0;
            int minx = Math.max(dataSet.getEntryIndex(entryFrom) - diff, 0);
            int maxx = Math.min(Math.max(minx + 2, dataSet.getEntryIndex(entryTo) + 1), entryCount);
            float halfsize = dataSet.getCircleRadius() / 2.0f;
            int count = (int)Math.ceil((float)(maxx - minx) * phaseX + (float)minx);
            for (int j = minx; j < count && (e = dataSet.getEntryForIndex(j)) != null; ++j) {
                circlesBuffer[0] = ((Entry)e).getXIndex();
                circlesBuffer[1] = ((Entry)e).getVal() * phaseY;
                trans.pointValuesToPixel(circlesBuffer);
                if (!this.mViewPortHandler.isInBoundsRight(circlesBuffer[0])) continue block0;
                if (!this.mViewPortHandler.isInBoundsLeft(circlesBuffer[0]) || !this.mViewPortHandler.isInBoundsY(circlesBuffer[1])) continue;
                int circleColor = dataSet.getCircleColor(j);
                this.mRenderPaint.setColor(circleColor);
                c.drawCircle(circlesBuffer[0], circlesBuffer[1], dataSet.getCircleRadius(), this.mRenderPaint);
                if (!dataSet.isDrawCircleHoleEnabled() || circleColor == this.mCirclePaintInner.getColor()) continue;
                c.drawCircle(circlesBuffer[0], circlesBuffer[1], halfsize, this.mCirclePaintInner);
            }
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            float yVal;
            int xIndex;
            ILineDataSet set = (ILineDataSet)this.mChart.getLineData().getDataSetByIndex(indices[i].getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || (float)(xIndex = indices[i].getXIndex()) > this.mChart.getXChartMax() * this.mAnimator.getPhaseX() || (yVal = set.getYValForXIndex(xIndex)) == Float.NaN) continue;
            float y = yVal * this.mAnimator.getPhaseY();
            float[] pts = new float[]{xIndex, y};
            this.mChart.getTransformer(set.getAxisDependency()).pointValuesToPixel(pts);
            this.drawHighlightLines(c, pts, set);
        }
    }

    public void setBitmapConfig(Bitmap.Config config) {
        this.mBitmapConfig = config;
        this.releaseBitmap();
    }

    public Bitmap.Config getBitmapConfig() {
        return this.mBitmapConfig;
    }

    public void releaseBitmap() {
        if (this.mDrawBitmap != null) {
            ((Bitmap)this.mDrawBitmap.get()).recycle();
            this.mDrawBitmap.clear();
            this.mDrawBitmap = null;
        }
    }
}

