/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.highlight.ChartHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.Range;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;

public class BarHighlighter
extends ChartHighlighter<BarDataProvider> {
    public BarHighlighter(BarDataProvider chart) {
        super(chart);
    }

    @Override
    public Highlight getHighlight(float x, float y) {
        Highlight h = super.getHighlight(x, y);
        if (h == null) {
            return h;
        }
        IBarDataSet set = (IBarDataSet)((BarDataProvider)this.mChart).getBarData().getDataSetByIndex(h.getDataSetIndex());
        if (set.isStacked()) {
            float[] pts = new float[2];
            pts[1] = y;
            ((BarDataProvider)this.mChart).getTransformer(set.getAxisDependency()).pixelsToValue(pts);
            return this.getStackedHighlight(h, set, h.getXIndex(), h.getDataSetIndex(), pts[1]);
        }
        return h;
    }

    @Override
    protected int getXIndex(float x) {
        if (!((BarDataProvider)this.mChart).getBarData().isGrouped()) {
            return super.getXIndex(x);
        }
        float baseNoSpace = this.getBase(x);
        int setCount = ((BarDataProvider)this.mChart).getBarData().getDataSetCount();
        int xIndex = (int)baseNoSpace / setCount;
        int valCount = ((BarDataProvider)this.mChart).getData().getXValCount();
        if (xIndex < 0) {
            xIndex = 0;
        } else if (xIndex >= valCount) {
            xIndex = valCount - 1;
        }
        return xIndex;
    }

    @Override
    protected int getDataSetIndex(int xIndex, float x, float y) {
        int setCount;
        if (!((BarDataProvider)this.mChart).getBarData().isGrouped()) {
            return 0;
        }
        float baseNoSpace = this.getBase(x);
        int dataSetIndex = (int)baseNoSpace % (setCount = ((BarDataProvider)this.mChart).getBarData().getDataSetCount());
        if (dataSetIndex < 0) {
            dataSetIndex = 0;
        } else if (dataSetIndex >= setCount) {
            dataSetIndex = setCount - 1;
        }
        return dataSetIndex;
    }

    protected Highlight getStackedHighlight(Highlight old, IBarDataSet set, int xIndex, int dataSetIndex, double yValue) {
        BarEntry entry = (BarEntry)set.getEntryForXIndex(xIndex);
        if (entry == null || entry.getVals() == null) {
            return old;
        }
        Range[] ranges = this.getRanges(entry);
        int stackIndex = this.getClosestStackIndex(ranges, (float)yValue);
        Highlight h = new Highlight(xIndex, dataSetIndex, stackIndex, ranges[stackIndex]);
        return h;
    }

    protected int getClosestStackIndex(Range[] ranges, float value) {
        if (ranges == null || ranges.length == 0) {
            return 0;
        }
        int stackIndex = 0;
        for (Range range : ranges) {
            if (range.contains(value)) {
                return stackIndex;
            }
            ++stackIndex;
        }
        int length = Math.max(ranges.length - 1, 0);
        return value > ranges[length].to ? length : 0;
    }

    protected float getBase(float x) {
        float[] pts = new float[2];
        pts[0] = x;
        ((BarDataProvider)this.mChart).getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
        float xVal = pts[0];
        int setCount = ((BarDataProvider)this.mChart).getBarData().getDataSetCount();
        int steps = (int)(xVal / ((float)setCount + ((BarDataProvider)this.mChart).getBarData().getGroupSpace()));
        float groupSpaceSum = ((BarDataProvider)this.mChart).getBarData().getGroupSpace() * (float)steps;
        float baseNoSpace = xVal - groupSpaceSum;
        return baseNoSpace;
    }

    protected Range[] getRanges(BarEntry entry) {
        float[] values = entry.getVals();
        if (values == null || values.length == 0) {
            return null;
        }
        float negRemain = -entry.getNegativeSum();
        float posRemain = 0.0f;
        Range[] ranges = new Range[values.length];
        for (int i = 0; i < ranges.length; ++i) {
            float value = values[i];
            if (value < 0.0f) {
                ranges[i] = new Range(negRemain, negRemain + Math.abs(value));
                negRemain += Math.abs(value);
                continue;
            }
            ranges[i] = new Range(posRemain, posRemain + value);
            posRemain += value;
        }
        return ranges;
    }
}

