/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.highlight.Range;

public class Highlight {
    private int mXIndex;
    private int mDataSetIndex;
    private int mStackIndex = -1;
    private Range mRange;

    public Highlight(int x, int dataSet) {
        this.mXIndex = x;
        this.mDataSetIndex = dataSet;
    }

    public Highlight(int x, int dataSet, int stackIndex) {
        this(x, dataSet);
        this.mStackIndex = stackIndex;
    }

    public Highlight(int x, int dataSet, int stackIndex, Range range) {
        this(x, dataSet, stackIndex);
        this.mRange = range;
    }

    public int getDataSetIndex() {
        return this.mDataSetIndex;
    }

    public int getXIndex() {
        return this.mXIndex;
    }

    public int getStackIndex() {
        return this.mStackIndex;
    }

    public Range getRange() {
        return this.mRange;
    }

    public boolean equalTo(Highlight h) {
        if (h == null) {
            return false;
        }
        return this.mDataSetIndex == h.mDataSetIndex && this.mXIndex == h.mXIndex && this.mStackIndex == h.mStackIndex;
    }

    public String toString() {
        return "Highlight, xIndex: " + this.mXIndex + ", dataSetIndex: " + this.mDataSetIndex + ", stackIndex (only stacked barentry): " + this.mStackIndex;
    }
}

