/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.charts.ScatterChart;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineScatterCandleRadarDataSet;
import com.github.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class ScatterDataSet
extends LineScatterCandleRadarDataSet<Entry>
implements IScatterDataSet {
    private float mShapeSize = 15.0f;
    private ScatterChart.ScatterShape mScatterShape = ScatterChart.ScatterShape.SQUARE;

    public ScatterDataSet(List<Entry> yVals, String label) {
        super(yVals, label);
    }

    @Override
    public DataSet<Entry> copy() {
        ArrayList<Entry> yVals = new ArrayList<Entry>();
        for (int i = 0; i < this.mYVals.size(); ++i) {
            yVals.add(((Entry)this.mYVals.get(i)).copy());
        }
        ScatterDataSet copied = new ScatterDataSet((List<Entry>)yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mShapeSize = this.mShapeSize;
        copied.mScatterShape = this.mScatterShape;
        copied.mHighLightColor = this.mHighLightColor;
        return copied;
    }

    public void setScatterShapeSize(float size) {
        this.mShapeSize = Utils.convertDpToPixel(size);
    }

    @Override
    public float getScatterShapeSize() {
        return this.mShapeSize;
    }

    public void setScatterShape(ScatterChart.ScatterShape shape) {
        this.mScatterShape = shape;
    }

    @Override
    public ScatterChart.ScatterShape getScatterShape() {
        return this.mScatterShape;
    }
}

