/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.realm.implementation;

import com.github.mikephil.charting.charts.ScatterChart;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.realm.base.RealmLineScatterCandleRadarDataSet;
import com.github.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.mikephil.charting.utils.Utils;
import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.dynamic.DynamicRealmObject;

public class RealmScatterDataSet<T extends RealmObject>
extends RealmLineScatterCandleRadarDataSet<T, Entry>
implements IScatterDataSet {
    private float mShapeSize = 15.0f;
    private ScatterChart.ScatterShape mScatterShape = ScatterChart.ScatterShape.SQUARE;

    public RealmScatterDataSet(RealmResults<T> result, String yValuesField) {
        super(result, yValuesField);
        this.build(this.results);
        this.calcMinMax(0, this.results.size());
    }

    public RealmScatterDataSet(RealmResults<T> result, String yValuesField, String xIndexField) {
        super(result, yValuesField, xIndexField);
        this.build(this.results);
        this.calcMinMax(0, this.results.size());
    }

    @Override
    public void build(RealmResults<T> results) {
        if (this.mIndexField == null) {
            int xIndex = 0;
            for (RealmObject object : results) {
                DynamicRealmObject dynamicObject = new DynamicRealmObject(object);
                this.mValues.add(new Entry(dynamicObject.getFloat(this.mValuesField), xIndex));
                ++xIndex;
            }
        } else {
            for (RealmObject object : results) {
                DynamicRealmObject dynamicObject = new DynamicRealmObject(object);
                this.mValues.add(new Entry(dynamicObject.getFloat(this.mValuesField), dynamicObject.getInt(this.mIndexField)));
            }
        }
    }

    public void setScatterShapeSize(float size) {
        this.mShapeSize = Utils.convertDpToPixel(size);
    }

    @Override
    public float getScatterShapeSize() {
        return this.mShapeSize;
    }

    public void setScatterShape(ScatterChart.ScatterShape shape) {
        this.mScatterShape = shape;
    }

    @Override
    public ScatterChart.ScatterShape getScatterShape() {
        return this.mScatterShape;
    }
}

