/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.realm.implementation;

import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.realm.base.RealmBaseDataSet;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.utils.Utils;
import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.dynamic.DynamicRealmObject;

public class RealmPieDataSet<T extends RealmObject>
extends RealmBaseDataSet<T, Entry>
implements IPieDataSet {
    private float mSliceSpace = 0.0f;
    private float mShift = 18.0f;

    public RealmPieDataSet(RealmResults<T> result, String yValuesField) {
        super(result, yValuesField);
        this.build(this.results);
        this.calcMinMax(0, this.results.size());
    }

    public RealmPieDataSet(RealmResults<T> result, String yValuesField, String xIndexField) {
        super(result, yValuesField, xIndexField);
        this.build(this.results);
        this.calcMinMax(0, this.results.size());
    }

    @Override
    public void build(RealmResults<T> results) {
        if (this.mIndexField == null) {
            int xIndex = 0;
            for (RealmObject object : results) {
                DynamicRealmObject dynamicObject = new DynamicRealmObject(object);
                this.mValues.add(new Entry(dynamicObject.getFloat(this.mValuesField), xIndex));
                ++xIndex;
            }
        } else {
            for (RealmObject object : results) {
                DynamicRealmObject dynamicObject = new DynamicRealmObject(object);
                this.mValues.add(new Entry(dynamicObject.getFloat(this.mValuesField), dynamicObject.getInt(this.mIndexField)));
            }
        }
    }

    public void setSliceSpace(float degrees) {
        if (degrees > 45.0f) {
            degrees = 45.0f;
        }
        if (degrees < 0.0f) {
            degrees = 0.0f;
        }
        this.mSliceSpace = degrees;
    }

    @Override
    public float getSliceSpace() {
        return this.mSliceSpace;
    }

    public void setSelectionShift(float shift) {
        this.mShift = Utils.convertDpToPixel(shift);
    }

    @Override
    public float getSelectionShift() {
        return this.mShift;
    }
}

