/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.BarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.data.BubbleEntry;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.interfaces.datasets.IBubbleDataSet;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class BubbleDataSet
extends BarLineScatterCandleBubbleDataSet<BubbleEntry>
implements IBubbleDataSet {
    protected float mXMax;
    protected float mXMin;
    protected float mMaxSize;
    private float mHighlightCircleWidth = 2.5f;

    public BubbleDataSet(List<BubbleEntry> yVals, String label) {
        super(yVals, label);
    }

    @Override
    public void setHighlightCircleWidth(float width) {
        this.mHighlightCircleWidth = Utils.convertDpToPixel(width);
    }

    @Override
    public float getHighlightCircleWidth() {
        return this.mHighlightCircleWidth;
    }

    @Override
    public void calcMinMax(int start, int end) {
        if (this.mYVals == null) {
            return;
        }
        if (this.mYVals.size() == 0) {
            return;
        }
        int endValue = end == 0 || end >= this.mYVals.size() ? this.mYVals.size() - 1 : end;
        this.mYMin = this.yMin((BubbleEntry)this.mYVals.get(start));
        this.mYMax = this.yMax((BubbleEntry)this.mYVals.get(start));
        for (int i = start; i < endValue; ++i) {
            float size;
            BubbleEntry entry = (BubbleEntry)this.mYVals.get(i);
            float ymin = this.yMin(entry);
            float ymax = this.yMax(entry);
            if (ymin < this.mYMin) {
                this.mYMin = ymin;
            }
            if (ymax > this.mYMax) {
                this.mYMax = ymax;
            }
            float xmin = this.xMin(entry);
            float xmax = this.xMax(entry);
            if (xmin < this.mXMin) {
                this.mXMin = xmin;
            }
            if (xmax > this.mXMax) {
                this.mXMax = xmax;
            }
            if (!((size = this.largestSize(entry)) > this.mMaxSize)) continue;
            this.mMaxSize = size;
        }
    }

    @Override
    public DataSet<BubbleEntry> copy() {
        ArrayList<BubbleEntry> yVals = new ArrayList<BubbleEntry>();
        for (int i = 0; i < this.mYVals.size(); ++i) {
            yVals.add(((BubbleEntry)this.mYVals.get(i)).copy());
        }
        BubbleDataSet copied = new BubbleDataSet((List<BubbleEntry>)yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mHighLightColor = this.mHighLightColor;
        return copied;
    }

    @Override
    public float getXMax() {
        return this.mXMax;
    }

    @Override
    public float getXMin() {
        return this.mXMin;
    }

    @Override
    public float getMaxSize() {
        return this.mMaxSize;
    }

    private float yMin(BubbleEntry entry) {
        return entry.getVal();
    }

    private float yMax(BubbleEntry entry) {
        return entry.getVal();
    }

    private float xMin(BubbleEntry entry) {
        return entry.getXIndex();
    }

    private float xMax(BubbleEntry entry) {
        return entry.getXIndex();
    }

    private float largestSize(BubbleEntry entry) {
        return entry.getSize();
    }
}

