/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.buffer;

import com.github.mikephil.charting.buffer.AbstractBuffer;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;

public class CandleBodyBuffer
extends AbstractBuffer<ICandleDataSet> {
    private float mBodySpace = 0.0f;

    public CandleBodyBuffer(int size) {
        super(size);
    }

    public void setBodySpace(float bodySpace) {
        this.mBodySpace = bodySpace;
    }

    private void addBody(float left, float top, float right, float bottom) {
        this.buffer[this.index++] = left;
        this.buffer[this.index++] = top;
        this.buffer[this.index++] = right;
        this.buffer[this.index++] = bottom;
    }

    @Override
    public void feed(ICandleDataSet data) {
        int size = (int)Math.ceil((float)(this.mTo - this.mFrom) * this.phaseX + (float)this.mFrom);
        for (int i = this.mFrom; i < size; ++i) {
            CandleEntry e = (CandleEntry)data.getEntryForIndex(i);
            this.addBody((float)e.getXIndex() - 0.5f + this.mBodySpace, e.getClose() * this.phaseY, (float)e.getXIndex() + 0.5f - this.mBodySpace, e.getOpen() * this.phaseY);
        }
        this.reset();
    }
}

