/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.BarDataProvider;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ValueFormatter;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class BarChartRenderer
extends DataRenderer {
    protected BarDataProvider mChart;
    protected RectF mBarRect = new RectF();
    protected BarBuffer[] mBarBuffers;
    protected Paint mShadowPaint;

    public BarChartRenderer(BarDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setColor(Color.rgb((int)0, (int)0, (int)0));
        this.mHighlightPaint.setAlpha(120);
        this.mShadowPaint = new Paint(1);
        this.mShadowPaint.setStyle(Paint.Style.FILL);
    }

    @Override
    public void initBuffers() {
        BarData barData = this.mChart.getBarData();
        this.mBarBuffers = new BarBuffer[barData.getDataSetCount()];
        for (int i = 0; i < this.mBarBuffers.length; ++i) {
            BarDataSet set = (BarDataSet)barData.getDataSetByIndex(i);
            this.mBarBuffers[i] = new BarBuffer(set.getValueCount() * 4 * set.getStackSize(), barData.getGroupSpace(), barData.getDataSetCount(), set.isStacked());
        }
    }

    @Override
    public void drawData(Canvas c) {
        BarData barData = this.mChart.getBarData();
        for (int i = 0; i < barData.getDataSetCount(); ++i) {
            BarDataSet set = (BarDataSet)barData.getDataSetByIndex(i);
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set, i);
        }
    }

    protected void drawDataSet(Canvas c, BarDataSet dataSet, int index) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        this.mShadowPaint.setColor(dataSet.getBarShadowColor());
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        List<BarEntry> entries = dataSet.getYVals();
        BarBuffer buffer = this.mBarBuffers[index];
        buffer.setPhases(phaseX, phaseY);
        buffer.setBarSpace(dataSet.getBarSpace());
        buffer.setDataSet(index);
        buffer.setInverted(this.mChart.isInverted(dataSet.getAxisDependency()));
        buffer.feed(entries);
        trans.pointValuesToPixel(buffer.buffer);
        if (dataSet.getColors().size() > 1) {
            for (int j = 0; j < buffer.size(); j += 4) {
                if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[j + 2])) continue;
                if (this.mViewPortHandler.isInBoundsRight(buffer.buffer[j])) {
                    if (this.mChart.isDrawBarShadowEnabled()) {
                        c.drawRect(buffer.buffer[j], this.mViewPortHandler.contentTop(), buffer.buffer[j + 2], this.mViewPortHandler.contentBottom(), this.mShadowPaint);
                    }
                    this.mRenderPaint.setColor(dataSet.getColor(j / 4));
                    c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
                    continue;
                }
                break;
            }
        } else {
            this.mRenderPaint.setColor(dataSet.getColor());
            for (int j = 0; j < buffer.size(); j += 4) {
                if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[j + 2])) continue;
                if (this.mViewPortHandler.isInBoundsRight(buffer.buffer[j])) {
                    if (this.mChart.isDrawBarShadowEnabled()) {
                        c.drawRect(buffer.buffer[j], this.mViewPortHandler.contentTop(), buffer.buffer[j + 2], this.mViewPortHandler.contentBottom(), this.mShadowPaint);
                    }
                    c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
                    continue;
                }
                break;
            }
        }
    }

    protected void prepareBarHighlight(float x, float y1, float y2, float barspaceHalf, Transformer trans) {
        float barWidth = 0.5f;
        float left = x - barWidth + barspaceHalf;
        float right = x + barWidth - barspaceHalf;
        float top = y1;
        float bottom = y2;
        this.mBarRect.set(left, top, right, bottom);
        trans.rectValueToPixel(this.mBarRect, this.mAnimator.getPhaseY());
    }

    @Override
    public void drawValues(Canvas c) {
        if (this.passesCheck()) {
            List dataSets = this.mChart.getBarData().getDataSets();
            float valueOffsetPlus = Utils.convertDpToPixel(4.5f);
            float posOffset = 0.0f;
            float negOffset = 0.0f;
            boolean drawValueAboveBar = this.mChart.isDrawValueAboveBarEnabled();
            block0: for (int i = 0; i < this.mChart.getBarData().getDataSetCount(); ++i) {
                int j;
                BarDataSet dataSet = (BarDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled()) continue;
                this.applyValueTextStyle(dataSet);
                boolean isInverted = this.mChart.isInverted(dataSet.getAxisDependency());
                float valueTextHeight = Utils.calcTextHeight(this.mValuePaint, "8");
                posOffset = drawValueAboveBar ? -valueOffsetPlus : valueTextHeight + valueOffsetPlus;
                float f = negOffset = drawValueAboveBar ? valueTextHeight + valueOffsetPlus : -valueOffsetPlus;
                if (isInverted) {
                    posOffset = -posOffset - valueTextHeight;
                    negOffset = -negOffset - valueTextHeight;
                }
                ValueFormatter formatter = dataSet.getValueFormatter();
                Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                List<BarEntry> entries = dataSet.getYVals();
                float[] valuePoints = this.getTransformedValues(trans, entries, i);
                if (!dataSet.isStacked()) {
                    j = 0;
                    while ((float)j < (float)valuePoints.length * this.mAnimator.getPhaseX() && this.mViewPortHandler.isInBoundsRight(valuePoints[j])) {
                        if (this.mViewPortHandler.isInBoundsY(valuePoints[j + 1]) && this.mViewPortHandler.isInBoundsLeft(valuePoints[j])) {
                            float val = entries.get(j / 2).getVal();
                            this.drawValue(c, formatter.getFormattedValue(val), valuePoints[j], valuePoints[j + 1] + (val >= 0.0f ? posOffset : negOffset));
                        }
                        j += 2;
                    }
                    continue;
                }
                j = 0;
                while ((float)j < (float)(valuePoints.length - 1) * this.mAnimator.getPhaseX()) {
                    BarEntry e = entries.get(j / 2);
                    float[] vals = e.getVals();
                    if (vals == null) {
                        if (!this.mViewPortHandler.isInBoundsRight(valuePoints[j])) continue block0;
                        if (this.mViewPortHandler.isInBoundsY(valuePoints[j + 1]) && this.mViewPortHandler.isInBoundsLeft(valuePoints[j])) {
                            this.drawValue(c, formatter.getFormattedValue(e.getVal()), valuePoints[j], valuePoints[j + 1] + (e.getVal() >= 0.0f ? posOffset : negOffset));
                        }
                    } else {
                        float[] transformed = new float[vals.length * 2];
                        float posY = 0.0f;
                        float negY = -e.getNegativeSum();
                        int k = 0;
                        int idx = 0;
                        while (k < transformed.length) {
                            float y;
                            float value = vals[idx];
                            if (value >= 0.0f) {
                                y = posY += value;
                            } else {
                                y = negY;
                                negY -= value;
                            }
                            transformed[k + 1] = y * this.mAnimator.getPhaseY();
                            k += 2;
                            ++idx;
                        }
                        trans.pointValuesToPixel(transformed);
                        for (k = 0; k < transformed.length; k += 2) {
                            float x = valuePoints[j];
                            float y = transformed[k + 1] + (vals[k / 2] >= 0.0f ? posOffset : negOffset);
                            if (!this.mViewPortHandler.isInBoundsRight(x)) break;
                            if (!this.mViewPortHandler.isInBoundsY(y) || !this.mViewPortHandler.isInBoundsLeft(x)) continue;
                            this.drawValue(c, formatter.getFormattedValue(vals[k / 2]), x, y);
                        }
                    }
                    j += 2;
                }
            }
        }
    }

    protected void drawValue(Canvas c, String value, float xPos, float yPos) {
        c.drawText(value, xPos, yPos, this.mValuePaint);
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        int setCount = this.mChart.getBarData().getDataSetCount();
        for (int i = 0; i < indices.length; ++i) {
            float y2;
            float y1;
            BarEntry e;
            Highlight h = indices[i];
            int index = h.getXIndex();
            int dataSetIndex = h.getDataSetIndex();
            BarDataSet set = (BarDataSet)this.mChart.getBarData().getDataSetByIndex(dataSetIndex);
            if (set == null || !set.isHighlightEnabled()) continue;
            float barspaceHalf = set.getBarSpace() / 2.0f;
            Transformer trans = this.mChart.getTransformer(set.getAxisDependency());
            this.mHighlightPaint.setColor(set.getHighLightColor());
            this.mHighlightPaint.setAlpha(set.getHighLightAlpha());
            if (index < 0 || !((float)index < this.mChart.getXChartMax() * this.mAnimator.getPhaseX() / (float)setCount) || (e = (BarEntry)set.getEntryForXIndex(index)) == null || e.getXIndex() != index) continue;
            float groupspace = this.mChart.getBarData().getGroupSpace();
            boolean isStack = h.getStackIndex() >= 0;
            float x = (float)(index * setCount + dataSetIndex) + groupspace / 2.0f + groupspace * (float)index;
            if (isStack) {
                y1 = h.getRange().from;
                y2 = h.getRange().to * this.mAnimator.getPhaseY();
            } else {
                y1 = e.getVal();
                y2 = 0.0f;
            }
            this.prepareBarHighlight(x, y1, y2, barspaceHalf, trans);
            c.drawRect(this.mBarRect, this.mHighlightPaint);
            if (!this.mChart.isDrawHighlightArrowEnabled()) continue;
            this.mHighlightPaint.setAlpha(255);
            float offsetY = this.mAnimator.getPhaseY() * 0.07f;
            float[] values = new float[9];
            trans.getPixelToValueMatrix().getValues(values);
            float xToYRel = Math.abs(values[4] / values[0]);
            float arrowWidth = set.getBarSpace() / 2.0f;
            float arrowHeight = arrowWidth * xToYRel;
            float yArrow = y1 > -y2 ? y1 : y1;
            Path arrow = new Path();
            arrow.moveTo(x + 0.4f, yArrow + offsetY);
            arrow.lineTo(x + 0.4f + arrowWidth, yArrow + offsetY - arrowHeight);
            arrow.lineTo(x + 0.4f + arrowWidth, yArrow + offsetY + arrowHeight);
            trans.pathValueToPixel(arrow);
            c.drawPath(arrow, this.mHighlightPaint);
        }
    }

    public float[] getTransformedValues(Transformer trans, List<BarEntry> entries, int dataSetIndex) {
        return trans.generateTransformedValuesBarChart(entries, dataSetIndex, this.mChart.getBarData(), this.mAnimator.getPhaseY());
    }

    protected boolean passesCheck() {
        return (float)this.mChart.getBarData().getYValCount() < (float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX();
    }

    @Override
    public void drawExtras(Canvas c) {
    }
}

