/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.buffer;

import com.github.mikephil.charting.buffer.AbstractBuffer;
import com.github.mikephil.charting.data.CandleEntry;
import java.util.List;

public class CandleShadowBuffer
extends AbstractBuffer<CandleEntry> {
    public CandleShadowBuffer(int size) {
        super(size);
    }

    private void addShadow(float x1, float y1, float x2, float y2) {
        this.buffer[this.index++] = x1;
        this.buffer[this.index++] = y1;
        this.buffer[this.index++] = x2;
        this.buffer[this.index++] = y2;
    }

    @Override
    public void feed(List<CandleEntry> entries) {
        int size = (int)Math.ceil((float)(this.mTo - this.mFrom) * this.phaseX + (float)this.mFrom);
        for (int i = this.mFrom; i < size; ++i) {
            CandleEntry e = entries.get(i);
            this.addShadow(e.getXIndex(), e.getHigh() * this.phaseY, e.getXIndex(), e.getLow() * this.phaseY);
        }
        this.reset();
    }
}

