/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.formatter;

import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.FormattedStringCache;
import com.github.mikephil.charting.formatter.ValueFormatter;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.text.DecimalFormat;

public class StackedValueFormatter
implements ValueFormatter {
    private boolean mDrawWholeStack;
    private FormattedStringCache.Generic mFormattedStringCacheWholeStack;
    private FormattedStringCache.Generic mFormattedStringCache;
    private String mAppendix;
    private DecimalFormat mFormat;

    public StackedValueFormatter(boolean drawWholeStack, String appendix, int decimals) {
        this.mDrawWholeStack = drawWholeStack;
        this.mAppendix = appendix;
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < decimals; ++i) {
            if (i == 0) {
                b.append(".");
            }
            b.append("0");
        }
        this.mFormattedStringCache = new FormattedStringCache.Generic(new DecimalFormat("###,###,###,##0" + b.toString()));
        this.mFormattedStringCacheWholeStack = new FormattedStringCache.Generic(new DecimalFormat("###,###,###,##0" + b.toString()));
    }

    @Override
    public String getFormattedValue(float value, Entry entry, int dataSetIndex, ViewPortHandler viewPortHandler) {
        BarEntry barEntry;
        float[] vals;
        FormattedStringCache.Generic chosenCache = this.mFormattedStringCache;
        int chosenIndex = dataSetIndex;
        float chosenValue = value;
        if (!this.mDrawWholeStack && entry instanceof BarEntry && (vals = (barEntry = (BarEntry)entry).getYVals()) != null) {
            if (vals[vals.length - 1] == value) {
                chosenCache = this.mFormattedStringCacheWholeStack;
                chosenValue = barEntry.getY();
            } else {
                chosenCache = null;
            }
        }
        if (chosenCache == null) {
            return "";
        }
        return chosenCache.getFormattedValue(Float.valueOf(chosenValue), chosenIndex) + this.mAppendix;
    }
}

