/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.PieData;
import com.github.mikephil.charting.formatter.ValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.List;

public class PieChartRenderer
extends DataRenderer {
    protected PieChart mChart;
    protected Paint mHolePaint;
    protected Paint mTransparentCirclePaint;
    private TextPaint mCenterTextPaint;
    private StaticLayout mCenterTextLayout;
    private CharSequence mCenterTextLastValue;
    private RectF mCenterTextLastBounds = new RectF();
    private RectF[] mRectBuffer = new RectF[]{new RectF(), new RectF(), new RectF()};
    protected WeakReference<Bitmap> mDrawBitmap;
    protected Canvas mBitmapCanvas;
    private Path mPathBuffer = new Path();
    private RectF mInnerRectBuffer = new RectF();
    private Path mHoleCirclePath = new Path();

    public PieChartRenderer(PieChart chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mHolePaint = new Paint(1);
        this.mHolePaint.setColor(-1);
        this.mHolePaint.setStyle(Paint.Style.FILL);
        this.mTransparentCirclePaint = new Paint(1);
        this.mTransparentCirclePaint.setColor(-1);
        this.mTransparentCirclePaint.setStyle(Paint.Style.FILL);
        this.mTransparentCirclePaint.setAlpha(105);
        this.mCenterTextPaint = new TextPaint(1);
        this.mCenterTextPaint.setColor(-16777216);
        this.mCenterTextPaint.setTextSize(Utils.convertDpToPixel(12.0f));
        this.mValuePaint.setTextSize(Utils.convertDpToPixel(13.0f));
        this.mValuePaint.setColor(-1);
        this.mValuePaint.setTextAlign(Paint.Align.CENTER);
    }

    public Paint getPaintHole() {
        return this.mHolePaint;
    }

    public Paint getPaintTransparentCircle() {
        return this.mTransparentCirclePaint;
    }

    public TextPaint getPaintCenterText() {
        return this.mCenterTextPaint;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas c) {
        int width = (int)this.mViewPortHandler.getChartWidth();
        int height = (int)this.mViewPortHandler.getChartHeight();
        if (this.mDrawBitmap == null || ((Bitmap)this.mDrawBitmap.get()).getWidth() != width || ((Bitmap)this.mDrawBitmap.get()).getHeight() != height) {
            if (width > 0 && height > 0) {
                this.mDrawBitmap = new WeakReference<Bitmap>(Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_4444));
                this.mBitmapCanvas = new Canvas((Bitmap)this.mDrawBitmap.get());
            } else {
                return;
            }
        }
        ((Bitmap)this.mDrawBitmap.get()).eraseColor(0);
        PieData pieData = (PieData)this.mChart.getData();
        for (IPieDataSet set : pieData.getDataSets()) {
            if (!set.isVisible() || set.getEntryCount() <= 0) continue;
            this.drawDataSet(c, set);
        }
    }

    protected float calculateMinimumRadiusForSpacedSlice(PointF center, float radius, float angle, float arcStartPointX, float arcStartPointY, float startAngle, float sweepAngle) {
        float angleMiddle = startAngle + sweepAngle / 2.0f;
        float arcEndPointX = center.x + radius * (float)Math.cos((startAngle + sweepAngle) * ((float)Math.PI / 180));
        float arcEndPointY = center.y + radius * (float)Math.sin((startAngle + sweepAngle) * ((float)Math.PI / 180));
        float arcMidPointX = center.x + radius * (float)Math.cos(angleMiddle * ((float)Math.PI / 180));
        float arcMidPointY = center.y + radius * (float)Math.sin(angleMiddle * ((float)Math.PI / 180));
        double basePointsDistance = Math.sqrt(Math.pow(arcEndPointX - arcStartPointX, 2.0) + Math.pow(arcEndPointY - arcStartPointY, 2.0));
        float containedTriangleHeight = (float)(basePointsDistance / 2.0 * Math.tan((180.0 - (double)angle) / 2.0 * (Math.PI / 180)));
        float spacedRadius = radius - containedTriangleHeight;
        spacedRadius = (float)((double)spacedRadius - Math.sqrt(Math.pow(arcMidPointX - (arcEndPointX + arcStartPointX) / 2.0f, 2.0) + Math.pow(arcMidPointY - (arcEndPointY + arcStartPointY) / 2.0f, 2.0)));
        return spacedRadius;
    }

    protected void drawDataSet(Canvas c, IPieDataSet dataSet) {
        float angle = 0.0f;
        float rotationAngle = this.mChart.getRotationAngle();
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        RectF circleBox = this.mChart.getCircleBox();
        int entryCount = dataSet.getEntryCount();
        float[] drawAngles = this.mChart.getDrawAngles();
        PointF center = this.mChart.getCenterCircleBox();
        float radius = this.mChart.getRadius();
        boolean drawInnerArc = this.mChart.isDrawHoleEnabled() && !this.mChart.isDrawSlicesUnderHoleEnabled();
        float userInnerRadius = drawInnerArc ? radius * (this.mChart.getHoleRadius() / 100.0f) : 0.0f;
        int visibleAngleCount = 0;
        for (int j = 0; j < entryCount; ++j) {
            if (!((double)Math.abs(((Entry)dataSet.getEntryForIndex(j)).getVal()) > 1.0E-6)) continue;
            ++visibleAngleCount;
        }
        float sliceSpace = visibleAngleCount <= 1 ? 0.0f : dataSet.getSliceSpace();
        for (int j = 0; j < entryCount; ++j) {
            float sliceAngle = drawAngles[j];
            float innerRadius = userInnerRadius;
            Object e = dataSet.getEntryForIndex(j);
            if ((double)Math.abs(((Entry)e).getVal()) > 1.0E-6 && !this.mChart.needsHighlight(((Entry)e).getXIndex(), ((PieData)this.mChart.getData()).getIndexOfDataSet(dataSet))) {
                boolean accountForSliceSpacing = sliceSpace > 0.0f && sliceAngle <= 180.0f;
                this.mRenderPaint.setColor(dataSet.getColor(j));
                float sliceSpaceAngleOuter = visibleAngleCount == 1 ? 0.0f : sliceSpace / ((float)Math.PI / 180 * radius);
                float startAngleOuter = rotationAngle + (angle + sliceSpaceAngleOuter / 2.0f) * phaseY;
                float sweepAngleOuter = (sliceAngle - sliceSpaceAngleOuter) * phaseY;
                if (sweepAngleOuter < 0.0f) {
                    sweepAngleOuter = 0.0f;
                }
                this.mPathBuffer.reset();
                float arcStartPointX = 0.0f;
                float arcStartPointY = 0.0f;
                if (sweepAngleOuter % 360.0f == 0.0f) {
                    this.mPathBuffer.addCircle(center.x, center.y, radius, Path.Direction.CW);
                } else {
                    arcStartPointX = center.x + radius * (float)Math.cos(startAngleOuter * ((float)Math.PI / 180));
                    arcStartPointY = center.y + radius * (float)Math.sin(startAngleOuter * ((float)Math.PI / 180));
                    this.mPathBuffer.moveTo(arcStartPointX, arcStartPointY);
                    this.mPathBuffer.arcTo(circleBox, startAngleOuter, sweepAngleOuter);
                }
                this.mInnerRectBuffer.set(center.x - innerRadius, center.y - innerRadius, center.x + innerRadius, center.y + innerRadius);
                if (drawInnerArc && (innerRadius > 0.0f || accountForSliceSpacing)) {
                    if (accountForSliceSpacing) {
                        float minSpacedRadius = this.calculateMinimumRadiusForSpacedSlice(center, radius, sliceAngle * phaseY, arcStartPointX, arcStartPointY, startAngleOuter, sweepAngleOuter);
                        if (minSpacedRadius < 0.0f) {
                            minSpacedRadius = -minSpacedRadius;
                        }
                        innerRadius = Math.max(innerRadius, minSpacedRadius);
                    }
                    float sliceSpaceAngleInner = visibleAngleCount == 1 || innerRadius == 0.0f ? 0.0f : sliceSpace / ((float)Math.PI / 180 * innerRadius);
                    float startAngleInner = rotationAngle + (angle + sliceSpaceAngleInner / 2.0f) * phaseY;
                    float sweepAngleInner = (sliceAngle - sliceSpaceAngleInner) * phaseY;
                    if (sweepAngleInner < 0.0f) {
                        sweepAngleInner = 0.0f;
                    }
                    float endAngleInner = startAngleInner + sweepAngleInner;
                    if (sweepAngleOuter % 360.0f == 0.0f) {
                        this.mPathBuffer.addCircle(center.x, center.y, innerRadius, Path.Direction.CCW);
                    } else {
                        this.mPathBuffer.lineTo(center.x + innerRadius * (float)Math.cos(endAngleInner * ((float)Math.PI / 180)), center.y + innerRadius * (float)Math.sin(endAngleInner * ((float)Math.PI / 180)));
                        this.mPathBuffer.arcTo(this.mInnerRectBuffer, endAngleInner, -sweepAngleInner);
                    }
                } else if (sweepAngleOuter % 360.0f != 0.0f) {
                    if (accountForSliceSpacing) {
                        float angleMiddle = startAngleOuter + sweepAngleOuter / 2.0f;
                        float sliceSpaceOffset = this.calculateMinimumRadiusForSpacedSlice(center, radius, sliceAngle * phaseY, arcStartPointX, arcStartPointY, startAngleOuter, sweepAngleOuter);
                        float arcEndPointX = center.x + sliceSpaceOffset * (float)Math.cos(angleMiddle * ((float)Math.PI / 180));
                        float arcEndPointY = center.y + sliceSpaceOffset * (float)Math.sin(angleMiddle * ((float)Math.PI / 180));
                        this.mPathBuffer.lineTo(arcEndPointX, arcEndPointY);
                    } else {
                        this.mPathBuffer.lineTo(center.x, center.y);
                    }
                }
                this.mPathBuffer.close();
                this.mBitmapCanvas.drawPath(this.mPathBuffer, this.mRenderPaint);
            }
            angle += sliceAngle * phaseX;
        }
    }

    @Override
    public void drawValues(Canvas c) {
        PointF center = this.mChart.getCenterCircleBox();
        float r = this.mChart.getRadius();
        float rotationAngle = this.mChart.getRotationAngle();
        float[] drawAngles = this.mChart.getDrawAngles();
        float[] absoluteAngles = this.mChart.getAbsoluteAngles();
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        float off = r / 10.0f * 3.6f;
        if (this.mChart.isDrawHoleEnabled()) {
            off = (r - r / 100.0f * this.mChart.getHoleRadius()) / 2.0f;
        }
        r -= off;
        PieData data = (PieData)this.mChart.getData();
        List dataSets = data.getDataSets();
        float yValueSum = data.getYValueSum();
        boolean drawXVals = this.mChart.isDrawSliceTextEnabled();
        int xIndex = 0;
        for (int i = 0; i < dataSets.size(); ++i) {
            IPieDataSet dataSet = (IPieDataSet)dataSets.get(i);
            if (!dataSet.isDrawValuesEnabled() && !drawXVals) continue;
            this.applyValueTextStyle(dataSet);
            float lineHeight = (float)Utils.calcTextHeight(this.mValuePaint, "Q") + Utils.convertDpToPixel(4.0f);
            int entryCount = dataSet.getEntryCount();
            int maxEntry = Math.min((int)Math.ceil((float)entryCount * phaseX), entryCount);
            for (int j = 0; j < maxEntry; ++j) {
                Object entry = dataSet.getEntryForIndex(j);
                float angle = xIndex == 0 ? 0.0f : absoluteAngles[xIndex - 1] * phaseX;
                float sliceAngle = drawAngles[xIndex];
                float sliceSpace = dataSet.getSliceSpace();
                float sliceSpaceMiddleAngle = sliceSpace / ((float)Math.PI / 180 * r);
                float offset = (sliceAngle - sliceSpaceMiddleAngle / 2.0f) / 2.0f;
                float x = (float)((double)r * Math.cos(Math.toRadians(rotationAngle + (angle += offset))) + (double)center.x);
                float y = (float)((double)r * Math.sin(Math.toRadians(rotationAngle + angle)) + (double)center.y);
                float value = this.mChart.isUsePercentValuesEnabled() ? ((Entry)entry).getVal() / yValueSum * 100.0f : ((Entry)entry).getVal();
                ValueFormatter formatter = dataSet.getValueFormatter();
                boolean drawYVals = dataSet.isDrawValuesEnabled();
                if (drawXVals && drawYVals) {
                    this.drawValue(c, formatter, value, (Entry)entry, 0, x, y, dataSet.getValueTextColor(j));
                    if (j < data.getXValCount()) {
                        c.drawText(data.getXVals().get(j), x, y + lineHeight, this.mValuePaint);
                    }
                } else if (drawXVals) {
                    if (j < data.getXValCount()) {
                        this.mValuePaint.setColor(dataSet.getValueTextColor(j));
                        c.drawText(data.getXVals().get(j), x, y + lineHeight / 2.0f, this.mValuePaint);
                    }
                } else if (drawYVals) {
                    this.drawValue(c, formatter, value, (Entry)entry, 0, x, y + lineHeight / 2.0f, dataSet.getValueTextColor(j));
                }
                ++xIndex;
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        this.drawHole(c);
        c.drawBitmap((Bitmap)this.mDrawBitmap.get(), 0.0f, 0.0f, null);
        this.drawCenterText(c);
    }

    protected void drawHole(Canvas c) {
        if (this.mChart.isDrawHoleEnabled()) {
            float radius = this.mChart.getRadius();
            float holeRadius = radius * (this.mChart.getHoleRadius() / 100.0f);
            PointF center = this.mChart.getCenterCircleBox();
            if (Color.alpha((int)this.mHolePaint.getColor()) > 0) {
                this.mBitmapCanvas.drawCircle(center.x, center.y, holeRadius, this.mHolePaint);
            }
            if (Color.alpha((int)this.mTransparentCirclePaint.getColor()) > 0 && this.mChart.getTransparentCircleRadius() > this.mChart.getHoleRadius()) {
                int alpha = this.mTransparentCirclePaint.getAlpha();
                float secondHoleRadius = radius * (this.mChart.getTransparentCircleRadius() / 100.0f);
                this.mTransparentCirclePaint.setAlpha((int)((float)alpha * this.mAnimator.getPhaseX() * this.mAnimator.getPhaseY()));
                this.mHoleCirclePath.reset();
                this.mHoleCirclePath.addCircle(center.x, center.y, secondHoleRadius, Path.Direction.CW);
                this.mHoleCirclePath.addCircle(center.x, center.y, holeRadius, Path.Direction.CCW);
                this.mBitmapCanvas.drawPath(this.mHoleCirclePath, this.mTransparentCirclePaint);
                this.mTransparentCirclePaint.setAlpha(alpha);
            }
        }
    }

    protected void drawCenterText(Canvas c) {
        CharSequence centerText = this.mChart.getCenterText();
        if (this.mChart.isDrawCenterTextEnabled() && centerText != null) {
            PointF center = this.mChart.getCenterCircleBox();
            float innerRadius = this.mChart.isDrawHoleEnabled() && !this.mChart.isDrawSlicesUnderHoleEnabled() ? this.mChart.getRadius() * (this.mChart.getHoleRadius() / 100.0f) : this.mChart.getRadius();
            RectF holeRect = this.mRectBuffer[0];
            holeRect.left = center.x - innerRadius;
            holeRect.top = center.y - innerRadius;
            holeRect.right = center.x + innerRadius;
            holeRect.bottom = center.y + innerRadius;
            RectF boundingRect = this.mRectBuffer[1];
            boundingRect.set(holeRect);
            float radiusPercent = this.mChart.getCenterTextRadiusPercent() / 100.0f;
            if ((double)radiusPercent > 0.0) {
                boundingRect.inset((boundingRect.width() - boundingRect.width() * radiusPercent) / 2.0f, (boundingRect.height() - boundingRect.height() * radiusPercent) / 2.0f);
            }
            if (!centerText.equals(this.mCenterTextLastValue) || !boundingRect.equals((Object)this.mCenterTextLastBounds)) {
                this.mCenterTextLastBounds.set(boundingRect);
                this.mCenterTextLastValue = centerText;
                float width = this.mCenterTextLastBounds.width();
                this.mCenterTextLayout = new StaticLayout(centerText, 0, centerText.length(), this.mCenterTextPaint, (int)Math.max(Math.ceil(width), 1.0), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
            }
            float layoutHeight = this.mCenterTextLayout.getHeight();
            c.save();
            if (Build.VERSION.SDK_INT >= 18) {
                Path path = new Path();
                path.addOval(holeRect, Path.Direction.CW);
                c.clipPath(path);
            }
            c.translate(boundingRect.left, boundingRect.top + (boundingRect.height() - layoutHeight) / 2.0f);
            this.mCenterTextLayout.draw(c);
            c.restore();
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        float rotationAngle = this.mChart.getRotationAngle();
        float[] drawAngles = this.mChart.getDrawAngles();
        float[] absoluteAngles = this.mChart.getAbsoluteAngles();
        PointF center = this.mChart.getCenterCircleBox();
        float radius = this.mChart.getRadius();
        boolean drawInnerArc = this.mChart.isDrawHoleEnabled() && !this.mChart.isDrawSlicesUnderHoleEnabled();
        float userInnerRadius = drawInnerArc ? radius * (this.mChart.getHoleRadius() / 100.0f) : 0.0f;
        RectF highlightedCircleBox = new RectF();
        for (int i = 0; i < indices.length; ++i) {
            IPieDataSet set;
            int xIndex = indices[i].getXIndex();
            if (xIndex >= drawAngles.length || (set = ((PieData)this.mChart.getData()).getDataSetByIndex(indices[i].getDataSetIndex())) == null || !set.isHighlightEnabled()) continue;
            int entryCount = set.getEntryCount();
            int visibleAngleCount = 0;
            for (int j = 0; j < entryCount; ++j) {
                if (!((double)Math.abs(((Entry)set.getEntryForIndex(j)).getVal()) > 1.0E-6)) continue;
                ++visibleAngleCount;
            }
            float angle = xIndex == 0 ? 0.0f : absoluteAngles[xIndex - 1] * phaseX;
            float sliceSpace = visibleAngleCount <= 1 ? 0.0f : set.getSliceSpace();
            float sliceAngle = drawAngles[xIndex];
            float innerRadius = userInnerRadius;
            float shift = set.getSelectionShift();
            float highlightedRadius = radius + shift;
            highlightedCircleBox.set(this.mChart.getCircleBox());
            highlightedCircleBox.inset(-shift, -shift);
            boolean accountForSliceSpacing = sliceSpace > 0.0f && sliceAngle <= 180.0f;
            this.mRenderPaint.setColor(set.getColor(xIndex));
            float sliceSpaceAngleOuter = visibleAngleCount == 1 ? 0.0f : sliceSpace / ((float)Math.PI / 180 * radius);
            float sliceSpaceAngleShifted = visibleAngleCount == 1 ? 0.0f : sliceSpace / ((float)Math.PI / 180 * highlightedRadius);
            float startAngleOuter = rotationAngle + (angle + sliceSpaceAngleOuter / 2.0f) * phaseY;
            float sweepAngleOuter = (sliceAngle - sliceSpaceAngleOuter) * phaseY;
            if (sweepAngleOuter < 0.0f) {
                sweepAngleOuter = 0.0f;
            }
            float startAngleShifted = rotationAngle + (angle + sliceSpaceAngleShifted / 2.0f) * phaseY;
            float sweepAngleShifted = (sliceAngle - sliceSpaceAngleShifted) * phaseY;
            if (sweepAngleShifted < 0.0f) {
                sweepAngleShifted = 0.0f;
            }
            this.mPathBuffer.reset();
            if (sweepAngleOuter % 360.0f == 0.0f) {
                this.mPathBuffer.addCircle(center.x, center.y, highlightedRadius, Path.Direction.CW);
            } else {
                this.mPathBuffer.moveTo(center.x + highlightedRadius * (float)Math.cos(startAngleShifted * ((float)Math.PI / 180)), center.y + highlightedRadius * (float)Math.sin(startAngleShifted * ((float)Math.PI / 180)));
                this.mPathBuffer.arcTo(highlightedCircleBox, startAngleShifted, sweepAngleShifted);
            }
            float sliceSpaceRadius = 0.0f;
            if (accountForSliceSpacing) {
                sliceSpaceRadius = this.calculateMinimumRadiusForSpacedSlice(center, radius, sliceAngle * phaseY, center.x + radius * (float)Math.cos(startAngleOuter * ((float)Math.PI / 180)), center.y + radius * (float)Math.sin(startAngleOuter * ((float)Math.PI / 180)), startAngleOuter, sweepAngleOuter);
            }
            this.mInnerRectBuffer.set(center.x - innerRadius, center.y - innerRadius, center.x + innerRadius, center.y + innerRadius);
            if (drawInnerArc && (innerRadius > 0.0f || accountForSliceSpacing)) {
                if (accountForSliceSpacing) {
                    float minSpacedRadius = sliceSpaceRadius;
                    if (minSpacedRadius < 0.0f) {
                        minSpacedRadius = -minSpacedRadius;
                    }
                    innerRadius = Math.max(innerRadius, minSpacedRadius);
                }
                float sliceSpaceAngleInner = visibleAngleCount == 1 || innerRadius == 0.0f ? 0.0f : sliceSpace / ((float)Math.PI / 180 * innerRadius);
                float startAngleInner = rotationAngle + (angle + sliceSpaceAngleInner / 2.0f) * phaseY;
                float sweepAngleInner = (sliceAngle - sliceSpaceAngleInner) * phaseY;
                if (sweepAngleInner < 0.0f) {
                    sweepAngleInner = 0.0f;
                }
                float endAngleInner = startAngleInner + sweepAngleInner;
                if (sweepAngleOuter % 360.0f == 0.0f) {
                    this.mPathBuffer.addCircle(center.x, center.y, innerRadius, Path.Direction.CCW);
                } else {
                    this.mPathBuffer.lineTo(center.x + innerRadius * (float)Math.cos(endAngleInner * ((float)Math.PI / 180)), center.y + innerRadius * (float)Math.sin(endAngleInner * ((float)Math.PI / 180)));
                    this.mPathBuffer.arcTo(this.mInnerRectBuffer, endAngleInner, -sweepAngleInner);
                }
            } else if (sweepAngleOuter % 360.0f != 0.0f) {
                if (accountForSliceSpacing) {
                    float angleMiddle = startAngleOuter + sweepAngleOuter / 2.0f;
                    float arcEndPointX = center.x + sliceSpaceRadius * (float)Math.cos(angleMiddle * ((float)Math.PI / 180));
                    float arcEndPointY = center.y + sliceSpaceRadius * (float)Math.sin(angleMiddle * ((float)Math.PI / 180));
                    this.mPathBuffer.lineTo(arcEndPointX, arcEndPointY);
                } else {
                    this.mPathBuffer.lineTo(center.x, center.y);
                }
            }
            this.mPathBuffer.close();
            this.mBitmapCanvas.drawPath(this.mPathBuffer, this.mRenderPaint);
        }
    }

    protected void drawRoundedSlices(Canvas c) {
        if (!this.mChart.isDrawRoundedSlicesEnabled()) {
            return;
        }
        IPieDataSet dataSet = ((PieData)this.mChart.getData()).getDataSet();
        if (!dataSet.isVisible()) {
            return;
        }
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        PointF center = this.mChart.getCenterCircleBox();
        float r = this.mChart.getRadius();
        float circleRadius = (r - r * this.mChart.getHoleRadius() / 100.0f) / 2.0f;
        float[] drawAngles = this.mChart.getDrawAngles();
        float angle = this.mChart.getRotationAngle();
        for (int j = 0; j < dataSet.getEntryCount(); ++j) {
            float sliceAngle = drawAngles[j];
            Object e = dataSet.getEntryForIndex(j);
            if ((double)Math.abs(((Entry)e).getVal()) > 1.0E-6) {
                float x = (float)((double)(r - circleRadius) * Math.cos(Math.toRadians((angle + sliceAngle) * phaseY)) + (double)center.x);
                float y = (float)((double)(r - circleRadius) * Math.sin(Math.toRadians((angle + sliceAngle) * phaseY)) + (double)center.y);
                this.mRenderPaint.setColor(dataSet.getColor(j));
                this.mBitmapCanvas.drawCircle(x, y, circleRadius, this.mRenderPaint);
            }
            angle += sliceAngle * phaseX;
        }
    }

    public void releaseBitmap() {
        if (this.mDrawBitmap != null) {
            ((Bitmap)this.mDrawBitmap.get()).recycle();
            this.mDrawBitmap.clear();
            this.mDrawBitmap = null;
        }
    }
}

