/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BubbleData;
import com.github.mikephil.charting.data.BubbleEntry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BubbleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBubbleDataSet;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class BubbleChartRenderer
extends DataRenderer {
    protected BubbleDataProvider mChart;
    private float[] sizeBuffer = new float[4];
    private float[] pointBuffer = new float[2];
    private float[] _hsvBuffer = new float[3];

    public BubbleChartRenderer(BubbleDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(Utils.convertDpToPixel(1.5f));
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas c) {
        BubbleData bubbleData = this.mChart.getBubbleData();
        for (IBubbleDataSet set : bubbleData.getDataSets()) {
            if (!set.isVisible() || set.getEntryCount() <= 0) continue;
            this.drawDataSet(c, set);
        }
    }

    protected float getShapeSize(float entrySize, float maxSize, float reference) {
        float factor = maxSize == 0.0f ? 1.0f : (float)Math.sqrt(entrySize / maxSize);
        float shapeSize = reference * factor;
        return shapeSize;
    }

    protected void drawDataSet(Canvas c, IBubbleDataSet dataSet) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        BubbleEntry entryFrom = (BubbleEntry)dataSet.getEntryForXIndex(this.mMinX);
        BubbleEntry entryTo = (BubbleEntry)dataSet.getEntryForXIndex(this.mMaxX);
        int minx = Math.max(dataSet.getEntryIndex(entryFrom), 0);
        int maxx = Math.min(dataSet.getEntryIndex(entryTo) + 1, dataSet.getEntryCount());
        this.sizeBuffer[0] = 0.0f;
        this.sizeBuffer[2] = 1.0f;
        trans.pointValuesToPixel(this.sizeBuffer);
        float maxBubbleWidth = Math.abs(this.sizeBuffer[2] - this.sizeBuffer[0]);
        float maxBubbleHeight = Math.abs(this.mViewPortHandler.contentBottom() - this.mViewPortHandler.contentTop());
        float referenceSize = Math.min(maxBubbleHeight, maxBubbleWidth);
        for (int j = minx; j < maxx; ++j) {
            BubbleEntry entry = (BubbleEntry)dataSet.getEntryForIndex(j);
            this.pointBuffer[0] = (float)(entry.getXIndex() - minx) * phaseX + (float)minx;
            this.pointBuffer[1] = entry.getVal() * phaseY;
            trans.pointValuesToPixel(this.pointBuffer);
            float shapeHalf = this.getShapeSize(entry.getSize(), dataSet.getMaxSize(), referenceSize) / 2.0f;
            if (!this.mViewPortHandler.isInBoundsTop(this.pointBuffer[1] + shapeHalf) || !this.mViewPortHandler.isInBoundsBottom(this.pointBuffer[1] - shapeHalf) || !this.mViewPortHandler.isInBoundsLeft(this.pointBuffer[0] + shapeHalf)) continue;
            if (!this.mViewPortHandler.isInBoundsRight(this.pointBuffer[0] - shapeHalf)) break;
            int color = dataSet.getColor(entry.getXIndex());
            this.mRenderPaint.setColor(color);
            c.drawCircle(this.pointBuffer[0], this.pointBuffer[1], shapeHalf, this.mRenderPaint);
        }
    }

    @Override
    public void drawValues(Canvas c) {
        BubbleData bubbleData = this.mChart.getBubbleData();
        if (bubbleData == null) {
            return;
        }
        if (bubbleData.getYValCount() < (int)Math.ceil((float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX())) {
            List dataSets = bubbleData.getDataSets();
            float lineHeight = Utils.calcTextHeight(this.mValuePaint, "1");
            block0: for (int i = 0; i < dataSets.size(); ++i) {
                IBubbleDataSet dataSet = (IBubbleDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled() || dataSet.getEntryCount() == 0) continue;
                this.applyValueTextStyle(dataSet);
                float phaseX = this.mAnimator.getPhaseX();
                float phaseY = this.mAnimator.getPhaseY();
                BubbleEntry entryFrom = (BubbleEntry)dataSet.getEntryForXIndex(this.mMinX);
                BubbleEntry entryTo = (BubbleEntry)dataSet.getEntryForXIndex(this.mMaxX);
                int minx = dataSet.getEntryIndex(entryFrom);
                int maxx = Math.min(dataSet.getEntryIndex(entryTo) + 1, dataSet.getEntryCount());
                float[] positions = this.mChart.getTransformer(dataSet.getAxisDependency()).generateTransformedValuesBubble(dataSet, phaseX, phaseY, minx, maxx);
                float alpha = phaseX == 1.0f ? phaseY : phaseX;
                for (int j = 0; j < positions.length; j += 2) {
                    int valueTextColor = dataSet.getValueTextColor(j / 2 + minx);
                    valueTextColor = Color.argb((int)Math.round(255.0f * alpha), (int)Color.red((int)valueTextColor), (int)Color.green((int)valueTextColor), (int)Color.blue((int)valueTextColor));
                    float x = positions[j];
                    float y = positions[j + 1];
                    if (!this.mViewPortHandler.isInBoundsRight(x)) continue block0;
                    if (!this.mViewPortHandler.isInBoundsLeft(x) || !this.mViewPortHandler.isInBoundsY(y)) continue;
                    BubbleEntry entry = (BubbleEntry)dataSet.getEntryForIndex(j / 2 + minx);
                    this.drawValue(c, dataSet.getValueFormatter(), entry.getSize(), entry, i, x, y + 0.5f * lineHeight, valueTextColor);
                }
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        BubbleData bubbleData = this.mChart.getBubbleData();
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        for (Highlight indice : indices) {
            IBubbleDataSet dataSet = (IBubbleDataSet)bubbleData.getDataSetByIndex(indice.getDataSetIndex());
            if (dataSet == null || !dataSet.isHighlightEnabled()) continue;
            BubbleEntry entryFrom = (BubbleEntry)dataSet.getEntryForXIndex(this.mMinX);
            BubbleEntry entryTo = (BubbleEntry)dataSet.getEntryForXIndex(this.mMaxX);
            int minx = dataSet.getEntryIndex(entryFrom);
            int maxx = Math.min(dataSet.getEntryIndex(entryTo) + 1, dataSet.getEntryCount());
            BubbleEntry entry = (BubbleEntry)bubbleData.getEntryForHighlight(indice);
            if (entry == null || entry.getXIndex() != indice.getXIndex()) continue;
            Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
            this.sizeBuffer[0] = 0.0f;
            this.sizeBuffer[2] = 1.0f;
            trans.pointValuesToPixel(this.sizeBuffer);
            float maxBubbleWidth = Math.abs(this.sizeBuffer[2] - this.sizeBuffer[0]);
            float maxBubbleHeight = Math.abs(this.mViewPortHandler.contentBottom() - this.mViewPortHandler.contentTop());
            float referenceSize = Math.min(maxBubbleHeight, maxBubbleWidth);
            this.pointBuffer[0] = (float)(entry.getXIndex() - minx) * phaseX + (float)minx;
            this.pointBuffer[1] = entry.getVal() * phaseY;
            trans.pointValuesToPixel(this.pointBuffer);
            float shapeHalf = this.getShapeSize(entry.getSize(), dataSet.getMaxSize(), referenceSize) / 2.0f;
            if (!this.mViewPortHandler.isInBoundsTop(this.pointBuffer[1] + shapeHalf) || !this.mViewPortHandler.isInBoundsBottom(this.pointBuffer[1] - shapeHalf) || !this.mViewPortHandler.isInBoundsLeft(this.pointBuffer[0] + shapeHalf)) continue;
            if (!this.mViewPortHandler.isInBoundsRight(this.pointBuffer[0] - shapeHalf)) break;
            if (indice.getXIndex() < minx || indice.getXIndex() >= maxx) continue;
            int originalColor = dataSet.getColor(entry.getXIndex());
            Color.RGBToHSV((int)Color.red((int)originalColor), (int)Color.green((int)originalColor), (int)Color.blue((int)originalColor), (float[])this._hsvBuffer);
            this._hsvBuffer[2] = this._hsvBuffer[2] * 0.5f;
            int color = Color.HSVToColor((int)Color.alpha((int)originalColor), (float[])this._hsvBuffer);
            this.mHighlightPaint.setColor(color);
            this.mHighlightPaint.setStrokeWidth(dataSet.getHighlightCircleWidth());
            c.drawCircle(this.pointBuffer[0], this.pointBuffer[1], shapeHalf, this.mHighlightPaint);
        }
    }
}

