/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.realm.base;

import com.github.mikephil.charting.data.BaseDataSet;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.Sort;
import java.util.ArrayList;
import java.util.List;

public abstract class RealmBaseDataSet<T extends RealmObject, S extends Entry>
extends BaseDataSet<S> {
    protected RealmResults<T> results;
    protected List<S> mValues;
    protected float mYMax = 0.0f;
    protected float mYMin = 0.0f;
    protected String mValuesField;
    protected String mIndexField;

    public RealmBaseDataSet(RealmResults<T> results, String yValuesField) {
        this.results = results;
        this.mValuesField = yValuesField;
        this.mValues = new ArrayList<S>();
        if (this.mIndexField != null) {
            this.results.sort(this.mIndexField, Sort.ASCENDING);
        }
    }

    public RealmBaseDataSet(RealmResults<T> results, String yValuesField, String xIndexField) {
        this.results = results;
        this.mValuesField = yValuesField;
        this.mIndexField = xIndexField;
        this.mValues = new ArrayList<S>();
        if (this.mIndexField != null) {
            this.results.sort(this.mIndexField, Sort.ASCENDING);
        }
    }

    public abstract void build(RealmResults<T> var1);

    @Override
    public float getYMin() {
        return this.mYMin;
    }

    @Override
    public float getYMax() {
        return this.mYMax;
    }

    @Override
    public int getEntryCount() {
        return this.mValues.size();
    }

    @Override
    public void calcMinMax(int start, int end) {
        if (this.mValues == null) {
            return;
        }
        int yValCount = this.mValues.size();
        if (yValCount == 0) {
            return;
        }
        int endValue = end == 0 || end >= yValCount ? yValCount - 1 : end;
        this.mYMin = Float.MAX_VALUE;
        this.mYMax = -3.4028235E38f;
        for (int i = start; i <= endValue; ++i) {
            Entry e = (Entry)this.mValues.get(i);
            if (e == null || Float.isNaN(e.getVal())) continue;
            if (e.getVal() < this.mYMin) {
                this.mYMin = e.getVal();
            }
            if (!(e.getVal() > this.mYMax)) continue;
            this.mYMax = e.getVal();
        }
        if (this.mYMin == Float.MAX_VALUE) {
            this.mYMin = 0.0f;
            this.mYMax = 0.0f;
        }
    }

    @Override
    public S getEntryForXIndex(int xIndex) {
        return this.getEntryForXIndex(xIndex, DataSet.Rounding.CLOSEST);
    }

    @Override
    public S getEntryForXIndex(int xIndex, DataSet.Rounding rounding) {
        int index = this.getEntryIndex(xIndex, rounding);
        if (index > -1) {
            return (S)((Entry)this.mValues.get(index));
        }
        return null;
    }

    @Override
    public S getEntryForIndex(int index) {
        return (S)((Entry)this.mValues.get(index));
    }

    @Override
    public int getEntryIndex(int x, DataSet.Rounding rounding) {
        int low = 0;
        int high = this.mValues.size() - 1;
        int closest = -1;
        while (low <= high) {
            int m = (high + low) / 2;
            if (x == ((Entry)this.mValues.get(m)).getXIndex()) {
                while (m > 0 && ((Entry)this.mValues.get(m - 1)).getXIndex() == x) {
                    --m;
                }
                return m;
            }
            if (x > ((Entry)this.mValues.get(m)).getXIndex()) {
                low = m + 1;
            } else {
                high = m - 1;
            }
            closest = m;
        }
        if (closest != -1) {
            int closestXIndex = ((Entry)this.mValues.get(closest)).getXIndex();
            if (rounding == DataSet.Rounding.UP) {
                if (closestXIndex < x && closest < this.mValues.size() - 1) {
                    ++closest;
                }
            } else if (rounding == DataSet.Rounding.DOWN && closestXIndex > x && closest > 0) {
                --closest;
            }
        }
        return closest;
    }

    @Override
    public int getEntryIndex(S e) {
        return this.mValues.indexOf(e);
    }

    @Override
    public float getYValForXIndex(int xIndex) {
        S e = this.getEntryForXIndex(xIndex);
        if (e != null && ((Entry)e).getXIndex() == xIndex) {
            return ((Entry)e).getVal();
        }
        return Float.NaN;
    }

    @Override
    public boolean addEntry(S e) {
        if (e == null) {
            return false;
        }
        float val = ((Entry)e).getVal();
        if (this.mValues == null) {
            this.mValues = new ArrayList<S>();
        }
        if (this.mValues.size() == 0) {
            this.mYMax = val;
            this.mYMin = val;
        } else {
            if (this.mYMax < val) {
                this.mYMax = val;
            }
            if (this.mYMin > val) {
                this.mYMin = val;
            }
        }
        this.mValues.add(e);
        return true;
    }

    @Override
    public boolean removeEntry(S e) {
        if (e == null) {
            return false;
        }
        if (this.mValues == null) {
            return false;
        }
        boolean removed = this.mValues.remove(e);
        if (removed) {
            this.calcMinMax(0, this.mValues.size());
        }
        return removed;
    }

    @Override
    public void addEntryOrdered(S e) {
        if (e == null) {
            return;
        }
        float val = ((Entry)e).getVal();
        if (this.mValues == null) {
            this.mValues = new ArrayList<S>();
        }
        if (this.mValues.size() == 0) {
            this.mYMax = val;
            this.mYMin = val;
        } else {
            if (this.mYMax < val) {
                this.mYMax = val;
            }
            if (this.mYMin > val) {
                this.mYMin = val;
            }
        }
        if (this.mValues.size() > 0 && ((Entry)this.mValues.get(this.mValues.size() - 1)).getXIndex() > ((Entry)e).getXIndex()) {
            int closestIndex = this.getEntryIndex(((Entry)e).getXIndex(), DataSet.Rounding.UP);
            this.mValues.add(closestIndex, e);
            return;
        }
        this.mValues.add(e);
    }

    public List<S> getValues() {
        return this.mValues;
    }

    @Override
    public void clear() {
        this.mValues.clear();
        this.notifyDataSetChanged();
    }

    public RealmResults<T> getResults() {
        return this.results;
    }

    public String getValuesField() {
        return this.mValuesField;
    }

    public void setValuesField(String yValuesField) {
        this.mValuesField = yValuesField;
    }

    public String getIndexField() {
        return this.mIndexField;
    }

    public void setIndexField(String xIndexField) {
        this.mIndexField = xIndexField;
    }
}

