/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class PieDataSet
extends DataSet<Entry>
implements IPieDataSet {
    private float mSliceSpace = 0.0f;
    private float mShift = 18.0f;

    public PieDataSet(List<Entry> yVals, String label) {
        super(yVals, label);
    }

    @Override
    public DataSet<Entry> copy() {
        ArrayList<Entry> yVals = new ArrayList<Entry>();
        for (int i = 0; i < this.mYVals.size(); ++i) {
            yVals.add(((Entry)this.mYVals.get(i)).copy());
        }
        PieDataSet copied = new PieDataSet((List<Entry>)yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mSliceSpace = this.mSliceSpace;
        copied.mShift = this.mShift;
        return copied;
    }

    public void setSliceSpace(float spaceDp) {
        if (spaceDp > 20.0f) {
            spaceDp = 20.0f;
        }
        if (spaceDp < 0.0f) {
            spaceDp = 0.0f;
        }
        this.mSliceSpace = Utils.convertDpToPixel(spaceDp);
    }

    @Override
    public float getSliceSpace() {
        return this.mSliceSpace;
    }

    public void setSelectionShift(float shift) {
        this.mShift = Utils.convertDpToPixel(shift);
    }

    @Override
    public float getSelectionShift() {
        return this.mShift;
    }
}

