/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.buffer;

import com.github.mikephil.charting.buffer.AbstractBuffer;
import com.github.mikephil.charting.data.Entry;
import java.util.List;

public class CircleBuffer
extends AbstractBuffer<Entry> {
    public CircleBuffer(int size) {
        super(size);
    }

    protected void addCircle(float x, float y) {
        this.buffer[this.index++] = x;
        this.buffer[this.index++] = y;
    }

    @Override
    public void feed(List<Entry> entries) {
        int size = (int)Math.ceil((float)(this.mTo - this.mFrom) * this.phaseX + (float)this.mFrom);
        for (int i = this.mFrom; i < size; ++i) {
            Entry e = entries.get(i);
            this.addCircle(e.getXIndex(), e.getVal() * this.phaseY);
        }
        this.reset();
    }
}

