/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.animation.Easing;
import com.github.mikephil.charting.animation.EasingFunction;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.MarkerView;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.interfaces.ChartInterface;
import com.github.mikephil.charting.listener.ChartTouchListener;
import com.github.mikephil.charting.listener.OnChartGestureListener;
import com.github.mikephil.charting.listener.OnChartValueSelectedListener;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.LegendRenderer;
import com.github.mikephil.charting.utils.DefaultValueFormatter;
import com.github.mikephil.charting.utils.Highlight;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ValueFormatter;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"NewApi"})
public abstract class Chart<T extends ChartData<? extends DataSet<? extends Entry>>>
extends ViewGroup
implements ChartInterface {
    public static final String LOG_TAG = "MPAndroidChart";
    protected boolean mLogEnabled = false;
    protected T mData = null;
    private boolean mDragDecelerationEnabled = true;
    private float mDragDecelerationFrictionCoef = 0.9f;
    protected ValueFormatter mDefaultFormatter;
    protected Paint mDescPaint;
    protected Paint mInfoPaint;
    protected String mDescription = "Description";
    protected boolean mDataNotSet = true;
    protected boolean mDrawUnitInChart = false;
    protected float mDeltaX = 1.0f;
    protected float mXChartMin = 0.0f;
    protected float mXChartMax = 0.0f;
    protected boolean mTouchEnabled = true;
    protected Legend mLegend;
    protected OnChartValueSelectedListener mSelectionListener;
    protected ChartTouchListener mChartTouchListener;
    private String mNoDataText = "No chart data available.";
    private OnChartGestureListener mGestureListener;
    private String mNoDataTextDescription;
    protected LegendRenderer mLegendRenderer;
    protected DataRenderer mRenderer;
    protected ViewPortHandler mViewPortHandler;
    protected ChartAnimator mAnimator;
    private float mExtraTopOffset = 0.0f;
    private float mExtraRightOffset = 0.0f;
    private float mExtraBottomOffset = 0.0f;
    private float mExtraLeftOffset = 0.0f;
    private boolean mOffsetsCalculated = false;
    protected Bitmap mDrawBitmap;
    protected Paint mDrawPaint;
    private PointF mDescriptionPosition;
    protected Highlight[] mIndicesToHightlight = new Highlight[0];
    protected boolean mDrawMarkerViews = true;
    protected MarkerView mMarkerView;
    public static final int PAINT_GRID_BACKGROUND = 4;
    public static final int PAINT_INFO = 7;
    public static final int PAINT_DESCRIPTION = 11;
    public static final int PAINT_HOLE = 13;
    public static final int PAINT_CENTER_TEXT = 14;
    public static final int PAINT_LEGEND_LABEL = 18;
    protected ArrayList<Runnable> mJobs = new ArrayList();

    public Chart(Context context) {
        super(context);
        this.init();
    }

    public Chart(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public Chart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void init() {
        this.setWillNotDraw(false);
        this.mAnimator = Build.VERSION.SDK_INT < 11 ? new ChartAnimator() : new ChartAnimator(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Chart.this.postInvalidate();
            }
        });
        Utils.init(this.getContext());
        this.mDefaultFormatter = new DefaultValueFormatter(1);
        this.mViewPortHandler = new ViewPortHandler();
        this.mLegend = new Legend();
        this.mLegendRenderer = new LegendRenderer(this.mViewPortHandler, this.mLegend);
        this.mDescPaint = new Paint(1);
        this.mDescPaint.setColor(-16777216);
        this.mDescPaint.setTextAlign(Paint.Align.RIGHT);
        this.mDescPaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mInfoPaint = new Paint(1);
        this.mInfoPaint.setColor(Color.rgb((int)247, (int)189, (int)51));
        this.mInfoPaint.setTextAlign(Paint.Align.CENTER);
        this.mInfoPaint.setTextSize(Utils.convertDpToPixel(12.0f));
        this.mDrawPaint = new Paint(4);
        if (this.mLogEnabled) {
            Log.i((String)"", (String)"Chart.init()");
        }
    }

    public void setData(T data) {
        if (data == null) {
            Log.e((String)LOG_TAG, (String)"Cannot set data for chart. Provided data object is null.");
            return;
        }
        this.mDataNotSet = false;
        this.mOffsetsCalculated = false;
        this.mData = data;
        this.calculateFormatter(((ChartData)data).getYMin(), ((ChartData)data).getYMax());
        for (DataSet set : ((ChartData)this.mData).getDataSets()) {
            if (!set.needsDefaultFormatter()) continue;
            set.setValueFormatter(this.mDefaultFormatter);
        }
        this.notifyDataSetChanged();
        if (this.mLogEnabled) {
            Log.i((String)LOG_TAG, (String)"Data is set.");
        }
    }

    public void clear() {
        this.mData = null;
        this.mDataNotSet = true;
        this.invalidate();
    }

    public void clearValues() {
        ((ChartData)this.mData).clearValues();
        this.invalidate();
    }

    public boolean isEmpty() {
        if (this.mData == null) {
            return true;
        }
        return ((ChartData)this.mData).getYValCount() <= 0;
    }

    public abstract void notifyDataSetChanged();

    protected abstract void calculateOffsets();

    protected abstract void calcMinMax();

    protected void calculateFormatter(float min, float max) {
        float reference = 0.0f;
        reference = this.mData == null || ((ChartData)this.mData).getXValCount() < 2 ? Math.max(Math.abs(min), Math.abs(max)) : Math.abs(max - min);
        int digits = Utils.getDecimals(reference);
        this.mDefaultFormatter = new DefaultValueFormatter(digits);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDataNotSet || this.mData == null || ((ChartData)this.mData).getYValCount() <= 0) {
            canvas.drawText(this.mNoDataText, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2), this.mInfoPaint);
            if (!TextUtils.isEmpty((CharSequence)this.mNoDataTextDescription)) {
                float textOffset = -this.mInfoPaint.ascent() + this.mInfoPaint.descent();
                canvas.drawText(this.mNoDataTextDescription, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2) + textOffset, this.mInfoPaint);
            }
            return;
        }
        if (!this.mOffsetsCalculated) {
            this.calculateOffsets();
            this.mOffsetsCalculated = true;
        }
    }

    protected void drawDescription(Canvas c) {
        if (!this.mDescription.equals("")) {
            if (this.mDescriptionPosition == null) {
                c.drawText(this.mDescription, (float)this.getWidth() - this.mViewPortHandler.offsetRight() - 10.0f, (float)this.getHeight() - this.mViewPortHandler.offsetBottom() - 10.0f, this.mDescPaint);
            } else {
                c.drawText(this.mDescription, this.mDescriptionPosition.x, this.mDescriptionPosition.y, this.mDescPaint);
            }
        }
    }

    public Highlight[] getHighlighted() {
        return this.mIndicesToHightlight;
    }

    public boolean valuesToHighlight() {
        return this.mIndicesToHightlight != null && this.mIndicesToHightlight.length > 0 && this.mIndicesToHightlight[0] != null;
    }

    public void highlightValues(Highlight[] highs) {
        this.mIndicesToHightlight = highs;
        if (highs == null || highs.length == 0) {
            this.mChartTouchListener.setLastHighlighted(null);
        }
        this.invalidate();
    }

    public void highlightValue(int xIndex, int dataSetIndex) {
        if (xIndex < 0 || dataSetIndex < 0 || xIndex >= ((ChartData)this.mData).getXValCount() || dataSetIndex >= ((ChartData)this.mData).getDataSetCount()) {
            this.highlightValues(null);
        } else {
            this.highlightValues(new Highlight[]{new Highlight(xIndex, dataSetIndex)});
        }
    }

    public void highlightTouch(Highlight high) {
        Entry e = null;
        if (high == null) {
            this.mIndicesToHightlight = null;
        } else {
            if (this.mLogEnabled) {
                Log.i((String)LOG_TAG, (String)("Highlighted: " + high.toString()));
            }
            if ((e = ((ChartData)this.mData).getEntryForHighlight(high)) == null || e.getXIndex() != high.getXIndex()) {
                this.mIndicesToHightlight = null;
                high = null;
            } else {
                this.mIndicesToHightlight = new Highlight[]{high};
            }
        }
        this.invalidate();
        if (this.mSelectionListener != null) {
            if (!this.valuesToHighlight()) {
                this.mSelectionListener.onNothingSelected();
            } else {
                this.mSelectionListener.onValueSelected(e, high.getDataSetIndex(), high);
            }
        }
    }

    public void setOnTouchListener(ChartTouchListener l) {
        this.mChartTouchListener = l;
    }

    protected void drawMarkers(Canvas canvas) {
        if (this.mMarkerView == null || !this.mDrawMarkerViews || !this.valuesToHighlight()) {
            return;
        }
        for (int i = 0; i < this.mIndicesToHightlight.length; ++i) {
            float[] pos;
            Entry e;
            int xIndex = this.mIndicesToHightlight[i].getXIndex();
            int dataSetIndex = this.mIndicesToHightlight[i].getDataSetIndex();
            if (!((float)xIndex <= this.mDeltaX) || !((float)xIndex <= this.mDeltaX * this.mAnimator.getPhaseX()) || (e = ((ChartData)this.mData).getEntryForHighlight(this.mIndicesToHightlight[i])) == null || e.getXIndex() != this.mIndicesToHightlight[i].getXIndex() || !this.mViewPortHandler.isInBounds((pos = this.getMarkerPosition(e, dataSetIndex))[0], pos[1])) continue;
            this.mMarkerView.refreshContent(e, dataSetIndex);
            this.mMarkerView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            this.mMarkerView.layout(0, 0, this.mMarkerView.getMeasuredWidth(), this.mMarkerView.getMeasuredHeight());
            if (pos[1] - (float)this.mMarkerView.getHeight() <= 0.0f) {
                float y = (float)this.mMarkerView.getHeight() - pos[1];
                this.mMarkerView.draw(canvas, pos[0], pos[1] + y);
                continue;
            }
            this.mMarkerView.draw(canvas, pos[0], pos[1]);
        }
    }

    protected abstract float[] getMarkerPosition(Entry var1, int var2);

    public ChartAnimator getAnimator() {
        return this.mAnimator;
    }

    public boolean isDragDecelerationEnabled() {
        return this.mDragDecelerationEnabled;
    }

    public void setDragDecelerationEnabled(boolean enabled) {
        this.mDragDecelerationEnabled = enabled;
    }

    public float getDragDecelerationFrictionCoef() {
        return this.mDragDecelerationFrictionCoef;
    }

    public void setDragDecelerationFrictionCoef(float newValue) {
        if (newValue < 0.0f) {
            newValue = 0.0f;
        }
        if (newValue >= 1.0f) {
            newValue = 0.999f;
        }
        this.mDragDecelerationFrictionCoef = newValue;
    }

    public void animateXY(int durationMillisX, int durationMillisY, EasingFunction easingX, EasingFunction easingY) {
        this.mAnimator.animateXY(durationMillisX, durationMillisY, easingX, easingY);
    }

    public void animateX(int durationMillis, EasingFunction easing) {
        this.mAnimator.animateX(durationMillis, easing);
    }

    public void animateY(int durationMillis, EasingFunction easing) {
        this.mAnimator.animateY(durationMillis, easing);
    }

    public void animateXY(int durationMillisX, int durationMillisY, Easing.EasingOption easingX, Easing.EasingOption easingY) {
        this.mAnimator.animateXY(durationMillisX, durationMillisY, easingX, easingY);
    }

    public void animateX(int durationMillis, Easing.EasingOption easing) {
        this.mAnimator.animateX(durationMillis, easing);
    }

    public void animateY(int durationMillis, Easing.EasingOption easing) {
        this.mAnimator.animateY(durationMillis, easing);
    }

    public void animateX(int durationMillis) {
        this.mAnimator.animateX(durationMillis);
    }

    public void animateY(int durationMillis) {
        this.mAnimator.animateY(durationMillis);
    }

    public void animateXY(int durationMillisX, int durationMillisY) {
        this.mAnimator.animateXY(durationMillisX, durationMillisY);
    }

    @Override
    public ValueFormatter getDefaultValueFormatter() {
        return this.mDefaultFormatter;
    }

    public void setOnChartValueSelectedListener(OnChartValueSelectedListener l) {
        this.mSelectionListener = l;
    }

    public void setOnChartGestureListener(OnChartGestureListener l) {
        this.mGestureListener = l;
    }

    public OnChartGestureListener getOnChartGestureListener() {
        return this.mGestureListener;
    }

    public void setHighlightEnabled(boolean enabled) {
        if (this.mData != null) {
            ((ChartData)this.mData).setHighlightEnabled(enabled);
        }
    }

    public boolean isHighlightEnabled() {
        return this.mData == null ? true : ((ChartData)this.mData).isHighlightEnabled();
    }

    public float getYValueSum() {
        return ((ChartData)this.mData).getYValueSum();
    }

    public float getYMax() {
        return ((ChartData)this.mData).getYMax();
    }

    public float getYMin() {
        return ((ChartData)this.mData).getYMin();
    }

    @Override
    public float getXChartMax() {
        return this.mXChartMax;
    }

    @Override
    public float getXChartMin() {
        return this.mXChartMin;
    }

    @Override
    public int getXValCount() {
        return ((ChartData)this.mData).getXValCount();
    }

    public float getAverage() {
        return this.getYValueSum() / (float)((ChartData)this.mData).getYValCount();
    }

    public float getAverage(String dataSetLabel) {
        Object ds = ((ChartData)this.mData).getDataSetByLabel(dataSetLabel, true);
        return ((DataSet)ds).getYValueSum() / (float)((DataSet)ds).getEntryCount();
    }

    public int getValueCount() {
        return ((ChartData)this.mData).getYValCount();
    }

    public PointF getCenter() {
        return new PointF((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
    }

    @Override
    public PointF getCenterOffsets() {
        return this.mViewPortHandler.getContentCenter();
    }

    public void setDescription(String desc) {
        if (desc == null) {
            desc = "";
        }
        this.mDescription = desc;
    }

    public void setDescriptionPosition(float x, float y) {
        this.mDescriptionPosition = new PointF(x, y);
    }

    public void setDescriptionTypeface(Typeface t) {
        this.mDescPaint.setTypeface(t);
    }

    public void setDescriptionTextSize(float size) {
        if (size > 16.0f) {
            size = 16.0f;
        }
        if (size < 6.0f) {
            size = 6.0f;
        }
        this.mDescPaint.setTextSize(Utils.convertDpToPixel(size));
    }

    public void setDescriptionColor(int color) {
        this.mDescPaint.setColor(color);
    }

    public void setExtraOffsets(float left, float top, float right, float bottom) {
        this.setExtraLeftOffset(left);
        this.setExtraTopOffset(top);
        this.setExtraRightOffset(right);
        this.setExtraBottomOffset(bottom);
    }

    public void setExtraTopOffset(float offset) {
        this.mExtraTopOffset = Utils.convertDpToPixel(offset);
    }

    public float getExtraTopOffset() {
        return this.mExtraTopOffset;
    }

    public void setExtraRightOffset(float offset) {
        this.mExtraRightOffset = Utils.convertDpToPixel(offset);
    }

    public float getExtraRightOffset() {
        return this.mExtraRightOffset;
    }

    public void setExtraBottomOffset(float offset) {
        this.mExtraBottomOffset = Utils.convertDpToPixel(offset);
    }

    public float getExtraBottomOffset() {
        return this.mExtraBottomOffset;
    }

    public void setExtraLeftOffset(float offset) {
        this.mExtraLeftOffset = Utils.convertDpToPixel(offset);
    }

    public float getExtraLeftOffset() {
        return this.mExtraLeftOffset;
    }

    public void setLogEnabled(boolean enabled) {
        this.mLogEnabled = enabled;
    }

    public boolean isLogEnabled() {
        return this.mLogEnabled;
    }

    public void setNoDataText(String text) {
        this.mNoDataText = text;
    }

    public void setNoDataTextDescription(String text) {
        this.mNoDataTextDescription = text;
    }

    public void setTouchEnabled(boolean enabled) {
        this.mTouchEnabled = enabled;
    }

    public void setMarkerView(MarkerView v) {
        this.mMarkerView = v;
    }

    public MarkerView getMarkerView() {
        return this.mMarkerView;
    }

    public Legend getLegend() {
        return this.mLegend;
    }

    public LegendRenderer getLegendRenderer() {
        return this.mLegendRenderer;
    }

    @Override
    public RectF getContentRect() {
        return this.mViewPortHandler.getContentRect();
    }

    public void disableScroll() {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
    }

    public void enableScroll() {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(false);
        }
    }

    public void setPaint(Paint p, int which) {
        switch (which) {
            case 7: {
                this.mInfoPaint = p;
                break;
            }
            case 11: {
                this.mDescPaint = p;
            }
        }
    }

    public Paint getPaint(int which) {
        switch (which) {
            case 7: {
                return this.mInfoPaint;
            }
            case 11: {
                return this.mDescPaint;
            }
        }
        return null;
    }

    public boolean isDrawMarkerViewEnabled() {
        return this.mDrawMarkerViews;
    }

    public void setDrawMarkerViews(boolean enabled) {
        this.mDrawMarkerViews = enabled;
    }

    public String getXValue(int index) {
        if (this.mData == null || ((ChartData)this.mData).getXValCount() <= index) {
            return null;
        }
        return ((ChartData)this.mData).getXVals().get(index);
    }

    public List<Entry> getEntriesAtIndex(int xIndex) {
        ArrayList<Entry> vals = new ArrayList<Entry>();
        for (int i = 0; i < ((ChartData)this.mData).getDataSetCount(); ++i) {
            Object set = ((ChartData)this.mData).getDataSetByIndex(i);
            Object e = ((DataSet)set).getEntryForXIndex(xIndex);
            if (e == null) continue;
            vals.add((Entry)e);
        }
        return vals;
    }

    public T getData() {
        return this.mData;
    }

    public float getPercentOfTotal(float val) {
        return val / ((ChartData)this.mData).getYValueSum() * 100.0f;
    }

    public ViewPortHandler getViewPortHandler() {
        return this.mViewPortHandler;
    }

    public DataRenderer getRenderer() {
        return this.mRenderer;
    }

    public void setRenderer(DataRenderer renderer) {
        if (renderer != null) {
            this.mRenderer = renderer;
        }
    }

    @Override
    public PointF getCenterOfView() {
        return this.getCenter();
    }

    public Bitmap getChartBitmap() {
        Bitmap returnedBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(returnedBitmap);
        Drawable bgDrawable = this.getBackground();
        if (bgDrawable != null) {
            bgDrawable.draw(canvas);
        } else {
            canvas.drawColor(-1);
        }
        this.draw(canvas);
        return returnedBitmap;
    }

    public boolean saveToPath(String title, String pathOnSD) {
        Bitmap b = this.getChartBitmap();
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(Environment.getExternalStorageDirectory().getPath() + pathOnSD + "/" + title + ".png");
            b.compress(Bitmap.CompressFormat.PNG, 40, (OutputStream)stream);
            ((OutputStream)stream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean saveToGallery(String fileName, int quality) {
        if (quality < 0 || quality > 100) {
            quality = 50;
        }
        long currentTime = System.currentTimeMillis();
        File extBaseDir = Environment.getExternalStorageDirectory();
        File file = new File(extBaseDir.getAbsolutePath() + "/DCIM");
        if (!file.exists() && !file.mkdirs()) {
            return false;
        }
        String filePath = file.getAbsolutePath() + "/" + fileName;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            Bitmap b = this.getChartBitmap();
            b.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        long size = new File(filePath).length();
        ContentValues values = new ContentValues(8);
        values.put("title", fileName);
        values.put("_display_name", fileName);
        values.put("date_added", Long.valueOf(currentTime));
        values.put("mime_type", "image/jpeg");
        values.put("description", "MPAndroidChart-Library Save");
        values.put("orientation", Integer.valueOf(0));
        values.put("_data", filePath);
        values.put("_size", Long.valueOf(size));
        return this.getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values) != null;
    }

    public void addJob(Runnable job) {
        this.mJobs.add(job);
    }

    public void removeJob(Runnable job) {
        this.mJobs.remove(job);
    }

    public void clearAllJobs() {
        this.mJobs.clear();
    }

    public ArrayList<Runnable> getJobs() {
        return this.mJobs;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).layout(left, top, right, bottom);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int size = (int)Utils.convertDpToPixel(50.0f);
        this.setMeasuredDimension(Math.max(this.getSuggestedMinimumWidth(), Chart.resolveSize((int)size, (int)widthMeasureSpec)), Math.max(this.getSuggestedMinimumHeight(), Chart.resolveSize((int)size, (int)heightMeasureSpec)));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mLogEnabled) {
            Log.i((String)LOG_TAG, (String)"OnSizeChanged()");
        }
        if (w > 0 && h > 0 && w < 10000 && h < 10000) {
            if (this.mDrawBitmap != null) {
                this.mDrawBitmap.recycle();
            }
            this.mDrawBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_4444);
            this.mViewPortHandler.setChartDimens(w, h);
            if (this.mLogEnabled) {
                Log.i((String)LOG_TAG, (String)("Setting chart dimens, width: " + w + ", height: " + h));
            }
            for (Runnable r : this.mJobs) {
                this.post(r);
            }
            this.mJobs.clear();
        }
        this.notifyDataSetChanged();
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public void setHardwareAccelerationEnabled(boolean enabled) {
        if (Build.VERSION.SDK_INT >= 11) {
            if (enabled) {
                this.setLayerType(2, null);
            } else {
                this.setLayerType(1, null);
            }
        } else {
            Log.e((String)LOG_TAG, (String)"Cannot enable/disable hardware acceleration for devices below API level 11.");
        }
    }
}

