/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.PieDataSet;
import com.github.mikephil.charting.renderer.Renderer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.List;

public class LegendRenderer
extends Renderer {
    protected Paint mLegendLabelPaint;
    protected Paint mLegendFormPaint;
    protected Legend mLegend;

    public LegendRenderer(ViewPortHandler viewPortHandler, Legend legend) {
        super(viewPortHandler);
        this.mLegend = legend;
        this.mLegendLabelPaint = new Paint(1);
        this.mLegendLabelPaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mLegendLabelPaint.setTextAlign(Paint.Align.LEFT);
        this.mLegendFormPaint = new Paint(1);
        this.mLegendFormPaint.setStyle(Paint.Style.FILL);
        this.mLegendFormPaint.setStrokeWidth(3.0f);
    }

    public Paint getLabelPaint() {
        return this.mLegendLabelPaint;
    }

    public Paint getFormPaint() {
        return this.mLegendFormPaint;
    }

    public void computeLegend(ChartData<?> data) {
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (int i = 0; i < data.getDataSetCount(); ++i) {
            int j;
            Object dataSet = data.getDataSetByIndex(i);
            List<Integer> clrs = ((DataSet)dataSet).getColors();
            int entryCount = ((DataSet)dataSet).getEntryCount();
            if (dataSet instanceof BarDataSet && ((BarDataSet)dataSet).isStacked()) {
                BarDataSet bds = (BarDataSet)dataSet;
                String[] sLabels = bds.getStackLabels();
                for (j = 0; j < clrs.size() && j < bds.getStackSize(); ++j) {
                    labels.add(sLabels[j % sLabels.length]);
                    colors.add(clrs.get(j));
                }
                colors.add(-2);
                labels.add(bds.getLabel());
                continue;
            }
            if (dataSet instanceof PieDataSet) {
                List<String> xVals = data.getXVals();
                PieDataSet pds = (PieDataSet)dataSet;
                for (j = 0; j < clrs.size() && j < entryCount && j < xVals.size(); ++j) {
                    labels.add(xVals.get(j));
                    colors.add(clrs.get(j));
                }
                colors.add(-2);
                labels.add(pds.getLabel());
                continue;
            }
            for (int j2 = 0; j2 < clrs.size() && j2 < entryCount; ++j2) {
                if (j2 < clrs.size() - 1 && j2 < entryCount - 1) {
                    labels.add(null);
                } else {
                    String label = ((DataSet)data.getDataSetByIndex(i)).getLabel();
                    labels.add(label);
                }
                colors.add(clrs.get(j2));
            }
        }
        this.mLegend.setColors(colors);
        this.mLegend.setLabels(labels);
        Typeface tf = this.mLegend.getTypeface();
        if (tf != null) {
            this.mLegendLabelPaint.setTypeface(tf);
        }
        this.mLegendLabelPaint.setTextSize(this.mLegend.getTextSize());
        this.mLegendLabelPaint.setColor(this.mLegend.getTextColor());
        this.mLegend.calculateDimensions(this.mLegendLabelPaint);
    }

    public void renderLegend(Canvas c) {
        if (!this.mLegend.isEnabled()) {
            return;
        }
        Typeface tf = this.mLegend.getTypeface();
        if (tf != null) {
            this.mLegendLabelPaint.setTypeface(tf);
        }
        this.mLegendLabelPaint.setTextSize(this.mLegend.getTextSize());
        this.mLegendLabelPaint.setColor(this.mLegend.getTextColor());
        String[] labels = this.mLegend.getLegendLabels();
        int[] colors = this.mLegend.getColors();
        float formToTextSpace = this.mLegend.getFormToTextSpace();
        float xEntrySpace = this.mLegend.getXEntrySpace();
        Legend.LegendDirection direction = this.mLegend.getDirection();
        float formSize = this.mLegend.getFormSize();
        float stackSpace = this.mLegend.getStackSpace();
        float textDrop = ((float)Utils.calcTextHeight(this.mLegendLabelPaint, "AQJ") + formSize) / 2.0f;
        float stack = 0.0f;
        boolean wasStacked = false;
        float yoffset = this.mLegend.getYOffset();
        float xoffset = this.mLegend.getXOffset();
        switch (this.mLegend.getPosition()) {
            case BELOW_CHART_LEFT: {
                float posX = this.mViewPortHandler.contentLeft() + xoffset;
                float posY = this.mViewPortHandler.getChartHeight() - yoffset;
                if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                    posX += this.mLegend.mNeededWidth;
                }
                int count = labels.length;
                for (int i = 0; i < count; ++i) {
                    boolean drawingForm;
                    boolean bl = drawingForm = colors[i] != -2;
                    if (drawingForm) {
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= formSize;
                        }
                        this.drawForm(c, posX, posY - this.mLegend.mTextHeightMax / 2.0f, i, this.mLegend);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += formSize;
                        }
                    }
                    if (labels[i] != null) {
                        if (drawingForm) {
                            posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -formToTextSpace : formToTextSpace;
                        }
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]);
                        }
                        this.drawLabel(c, posX, posY, labels[i]);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]);
                        }
                        posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -xEntrySpace : xEntrySpace;
                        continue;
                    }
                    posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -stackSpace : stackSpace;
                }
                break;
            }
            case BELOW_CHART_RIGHT: {
                float posX = this.mViewPortHandler.contentRight() - xoffset;
                float posY = this.mViewPortHandler.getChartHeight() - yoffset;
                int count = labels.length;
                for (int i = 0; i < count; ++i) {
                    boolean drawingForm;
                    boolean bl = drawingForm = colors[i] != -2;
                    if (direction == Legend.LegendDirection.RIGHT_TO_LEFT && drawingForm) {
                        this.drawForm(c, posX -= formSize, posY - this.mLegend.mTextHeightMax / 2.0f, i, this.mLegend);
                        posX -= formToTextSpace;
                    }
                    if (labels[i] != null) {
                        this.drawLabel(c, posX -= (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]), posY, labels[i]);
                    }
                    if (direction == Legend.LegendDirection.LEFT_TO_RIGHT && drawingForm) {
                        this.drawForm(c, posX -= formToTextSpace + formSize, posY - this.mLegend.mTextHeightMax / 2.0f, i, this.mLegend);
                    }
                    posX -= labels[i] != null ? xEntrySpace : stackSpace;
                }
                break;
            }
            case BELOW_CHART_CENTER: {
                float posX = this.mViewPortHandler.getChartWidth() / 2.0f + (direction == Legend.LegendDirection.LEFT_TO_RIGHT ? -this.mLegend.mNeededWidth / 2.0f : this.mLegend.mNeededWidth / 2.0f);
                float posY = this.mViewPortHandler.getChartHeight() - yoffset;
                for (int i = 0; i < labels.length; ++i) {
                    boolean drawingForm;
                    boolean bl = drawingForm = colors[i] != -2;
                    if (drawingForm) {
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= formSize;
                        }
                        this.drawForm(c, posX, posY - this.mLegend.mTextHeightMax / 2.0f, i, this.mLegend);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += formSize;
                        }
                    }
                    if (labels[i] != null) {
                        if (drawingForm) {
                            posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -formToTextSpace : formToTextSpace;
                        }
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]);
                        }
                        this.drawLabel(c, posX, posY, labels[i]);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]);
                        }
                        posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -xEntrySpace : xEntrySpace;
                        continue;
                    }
                    posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -stackSpace : stackSpace;
                }
                break;
            }
            case PIECHART_CENTER: {
                float posX = this.mViewPortHandler.getChartWidth() / 2.0f + (direction == Legend.LegendDirection.LEFT_TO_RIGHT ? -this.mLegend.mTextWidthMax / 2.0f : this.mLegend.mTextWidthMax / 2.0f);
                float posY = this.mViewPortHandler.getChartHeight() / 2.0f - this.mLegend.mNeededHeight / 2.0f;
                for (int i = 0; i < labels.length; ++i) {
                    boolean drawingForm = colors[i] != -2;
                    float x = posX;
                    if (drawingForm) {
                        x = direction == Legend.LegendDirection.LEFT_TO_RIGHT ? (x += stack) : (x -= formSize - stack);
                        this.drawForm(c, x, posY, i, this.mLegend);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            x += formSize;
                        }
                    }
                    if (labels[i] != null) {
                        if (drawingForm && !wasStacked) {
                            x += direction == Legend.LegendDirection.LEFT_TO_RIGHT ? formToTextSpace : -formToTextSpace;
                        } else if (wasStacked) {
                            x = posX;
                        }
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            x -= (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]);
                        }
                        if (!wasStacked) {
                            this.drawLabel(c, x, posY + this.mLegend.mTextHeightMax / 2.0f, this.mLegend.getLabel(i));
                            posY += textDrop;
                        } else {
                            this.drawLabel(c, x, (posY += this.mLegend.mTextHeightMax * 3.0f) - this.mLegend.mTextHeightMax, this.mLegend.getLabel(i));
                        }
                        posY += this.mLegend.getYEntrySpace();
                        stack = 0.0f;
                        continue;
                    }
                    stack += formSize + stackSpace;
                    wasStacked = true;
                }
                break;
            }
            case RIGHT_OF_CHART: 
            case RIGHT_OF_CHART_CENTER: 
            case RIGHT_OF_CHART_INSIDE: 
            case LEFT_OF_CHART: 
            case LEFT_OF_CHART_CENTER: 
            case LEFT_OF_CHART_INSIDE: {
                float posX;
                boolean isRightAligned;
                boolean bl = isRightAligned = this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART || this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART_CENTER || this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART_INSIDE;
                if (isRightAligned) {
                    posX = this.mViewPortHandler.getChartWidth() - xoffset;
                    if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                        posX -= this.mLegend.mTextWidthMax;
                    }
                } else {
                    posX = xoffset;
                    if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                        posX += this.mLegend.mTextWidthMax;
                    }
                }
                float posY = this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART || this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART ? this.mViewPortHandler.contentTop() + yoffset : (this.mLegend.getPosition() == Legend.LegendPosition.RIGHT_OF_CHART_CENTER || this.mLegend.getPosition() == Legend.LegendPosition.LEFT_OF_CHART_CENTER ? this.mViewPortHandler.getChartHeight() / 2.0f - this.mLegend.mNeededHeight / 2.0f : this.mViewPortHandler.contentTop() + yoffset);
                for (int i = 0; i < labels.length; ++i) {
                    Boolean drawingForm = colors[i] != -2;
                    float x = posX;
                    if (drawingForm.booleanValue()) {
                        x = direction == Legend.LegendDirection.LEFT_TO_RIGHT ? (x += stack) : (x -= formSize - stack);
                        this.drawForm(c, x, posY, i, this.mLegend);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            x += formSize;
                        }
                    }
                    if (labels[i] != null) {
                        if (drawingForm.booleanValue() && !wasStacked) {
                            x += direction == Legend.LegendDirection.LEFT_TO_RIGHT ? formToTextSpace : -formToTextSpace;
                        } else if (wasStacked) {
                            x = posX;
                        }
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            x -= (float)Utils.calcTextWidth(this.mLegendLabelPaint, labels[i]);
                        }
                        if (!wasStacked) {
                            this.drawLabel(c, x, posY + this.mLegend.mTextHeightMax / 2.0f, this.mLegend.getLabel(i));
                            posY += textDrop;
                        } else {
                            this.drawLabel(c, x, (posY += this.mLegend.mTextHeightMax * 3.0f) - this.mLegend.mTextHeightMax, this.mLegend.getLabel(i));
                        }
                        posY += this.mLegend.getYEntrySpace();
                        stack = 0.0f;
                        continue;
                    }
                    stack += formSize + stackSpace;
                    wasStacked = true;
                }
                break;
            }
        }
    }

    protected void drawForm(Canvas c, float x, float y, int index, Legend legend) {
        if (legend.getColors()[index] == -2) {
            return;
        }
        this.mLegendFormPaint.setColor(legend.getColors()[index]);
        float formsize = legend.getFormSize();
        float half = formsize / 2.0f;
        switch (legend.getForm()) {
            case CIRCLE: {
                c.drawCircle(x + half, y, half, this.mLegendFormPaint);
                break;
            }
            case SQUARE: {
                c.drawRect(x, y - half, x + formsize, y + half, this.mLegendFormPaint);
                break;
            }
            case LINE: {
                c.drawLine(x, y, x + formsize, y, this.mLegendFormPaint);
            }
        }
    }

    protected void drawLabel(Canvas c, float x, float y, String label) {
        c.drawText(label, x, y, this.mLegendLabelPaint);
    }
}

