/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.components;

import android.graphics.Paint;
import com.github.mikephil.charting.components.ComponentBase;
import com.github.mikephil.charting.utils.Utils;
import java.util.List;

public class Legend
extends ComponentBase {
    private int[] mColors;
    private String[] mLabels;
    private LegendPosition mPosition = LegendPosition.BELOW_CHART_LEFT;
    private LegendDirection mDirection = LegendDirection.LEFT_TO_RIGHT;
    private LegendForm mShape = LegendForm.SQUARE;
    private float mFormSize = Utils.convertDpToPixel(8.0f);
    private float mXEntrySpace = Utils.convertDpToPixel(6.0f);
    private float mYEntrySpace = Utils.convertDpToPixel(5.0f);
    private float mFormToTextSpace = Utils.convertDpToPixel(5.0f);
    private float mStackSpace = 3.0f;
    public float mNeededWidth = 0.0f;
    public float mNeededHeight = 0.0f;
    public float mTextHeightMax = 0.0f;
    public float mTextWidthMax = 0.0f;

    public Legend() {
        this.mTextSize = Utils.convertDpToPixel(10.0f);
        this.mStackSpace = Utils.convertDpToPixel(3.0f);
        this.mXOffset = Utils.convertDpToPixel(5.0f);
        this.mYOffset = Utils.convertDpToPixel(6.0f);
    }

    public Legend(int[] colors, String[] labels) {
        this();
        if (colors == null || labels == null) {
            throw new IllegalArgumentException("colors array or labels array is NULL");
        }
        if (colors.length != labels.length) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.mColors = colors;
        this.mLabels = labels;
    }

    public Legend(List<Integer> colors, List<String> labels) {
        this();
        if (colors == null || labels == null) {
            throw new IllegalArgumentException("colors array or labels array is NULL");
        }
        if (colors.size() != labels.size()) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.mColors = Utils.convertIntegers(colors);
        this.mLabels = Utils.convertStrings(labels);
    }

    public void setColors(List<Integer> colors) {
        this.mColors = Utils.convertIntegers(colors);
    }

    public void setLabels(List<String> labels) {
        this.mLabels = Utils.convertStrings(labels);
    }

    public float getMaximumEntryWidth(Paint p) {
        float max = 0.0f;
        for (int i = 0; i < this.mLabels.length; ++i) {
            float length;
            if (this.mLabels[i] == null || !((length = (float)Utils.calcTextWidth(p, this.mLabels[i])) > max)) continue;
            max = length;
        }
        return max + this.mFormSize + this.mFormToTextSpace;
    }

    public float getMaximumEntryHeight(Paint p) {
        float max = 0.0f;
        for (int i = 0; i < this.mLabels.length; ++i) {
            float length;
            if (this.mLabels[i] == null || !((length = (float)Utils.calcTextHeight(p, this.mLabels[i])) > max)) continue;
            max = length;
        }
        return max;
    }

    public int[] getColors() {
        return this.mColors;
    }

    public String[] getLegendLabels() {
        return this.mLabels;
    }

    public void setLabels(String[] labels) {
        this.mLabels = labels;
    }

    public String getLabel(int index) {
        return this.mLabels[index];
    }

    public LegendPosition getPosition() {
        return this.mPosition;
    }

    public void setPosition(LegendPosition pos) {
        this.mPosition = pos;
    }

    public LegendDirection getDirection() {
        return this.mDirection;
    }

    public void setDirection(LegendDirection pos) {
        this.mDirection = pos;
    }

    public LegendForm getForm() {
        return this.mShape;
    }

    public void setForm(LegendForm shape) {
        this.mShape = shape;
    }

    public void setFormSize(float size) {
        this.mFormSize = Utils.convertDpToPixel(size);
    }

    public float getFormSize() {
        return this.mFormSize;
    }

    public float getXEntrySpace() {
        return this.mXEntrySpace;
    }

    public void setXEntrySpace(float space) {
        this.mXEntrySpace = Utils.convertDpToPixel(space);
    }

    public float getYEntrySpace() {
        return this.mYEntrySpace;
    }

    public void setYEntrySpace(float space) {
        this.mYEntrySpace = Utils.convertDpToPixel(space);
    }

    public float getFormToTextSpace() {
        return this.mFormToTextSpace;
    }

    public void setFormToTextSpace(float space) {
        this.mFormToTextSpace = Utils.convertDpToPixel(space);
    }

    public float getStackSpace() {
        return this.mStackSpace;
    }

    public void setStackSpace(float space) {
        this.mStackSpace = space;
    }

    public float getFullWidth(Paint labelpaint) {
        float width = 0.0f;
        for (int i = 0; i < this.mLabels.length; ++i) {
            if (this.mLabels[i] != null) {
                if (this.mColors[i] != -2) {
                    width += this.mFormSize + this.mFormToTextSpace;
                }
                width += (float)Utils.calcTextWidth(labelpaint, this.mLabels[i]);
                if (i >= this.mLabels.length - 1) continue;
                width += this.mXEntrySpace;
                continue;
            }
            width += this.mFormSize;
            if (i >= this.mLabels.length - 1) continue;
            width += this.mStackSpace;
        }
        return width;
    }

    public float getFullHeight(Paint labelpaint) {
        float height = 0.0f;
        for (int i = 0; i < this.mLabels.length; ++i) {
            if (this.mLabels[i] == null) continue;
            height += (float)Utils.calcTextHeight(labelpaint, this.mLabels[i]);
            if (i >= this.mLabels.length - 1) continue;
            height += this.mYEntrySpace;
        }
        return height;
    }

    public void calculateDimensions(Paint labelpaint) {
        if (this.mPosition == LegendPosition.RIGHT_OF_CHART || this.mPosition == LegendPosition.RIGHT_OF_CHART_CENTER || this.mPosition == LegendPosition.LEFT_OF_CHART || this.mPosition == LegendPosition.LEFT_OF_CHART_CENTER || this.mPosition == LegendPosition.PIECHART_CENTER) {
            this.mNeededWidth = this.getMaximumEntryWidth(labelpaint);
            this.mNeededHeight = this.getFullHeight(labelpaint);
            this.mTextWidthMax = this.mNeededWidth;
            this.mTextHeightMax = this.getMaximumEntryHeight(labelpaint);
        } else {
            this.mNeededWidth = this.getFullWidth(labelpaint);
            this.mNeededHeight = this.getMaximumEntryHeight(labelpaint);
            this.mTextWidthMax = this.getMaximumEntryWidth(labelpaint);
            this.mTextHeightMax = this.mNeededHeight;
        }
    }

    public static enum LegendDirection {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }

    public static enum LegendForm {
        SQUARE,
        CIRCLE,
        LINE;

    }

    public static enum LegendPosition {
        RIGHT_OF_CHART,
        RIGHT_OF_CHART_CENTER,
        RIGHT_OF_CHART_INSIDE,
        LEFT_OF_CHART,
        LEFT_OF_CHART_CENTER,
        LEFT_OF_CHART_INSIDE,
        BELOW_CHART_LEFT,
        BELOW_CHART_RIGHT,
        BELOW_CHART_CENTER,
        PIECHART_CENTER;

    }
}

