/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.animation;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.SystemClock;
import com.github.mikephil.charting.animation.AnimationEasing;

@SuppressLint(value={"NewApi"})
public class ChartAnimator {
    private UpdateListener mListener;
    protected float mPhaseY = 1.0f;
    protected float mPhaseX = 1.0f;
    private long mStartTime;
    private FrameHandler mHandler;
    private final Object mLock = new Object();
    private long mXDuration = 0L;
    private long mYDuration = 0L;
    private long mEndTimeX = 0L;
    private long mEndTimeY = 0L;
    private long mEndTime = 0L;
    private boolean mEnabledX = false;
    private boolean mEnabledY = false;
    private AnimationEasing.EasingFunction mEasing;
    private static final long FRAME_DELAY = 15L;

    public ChartAnimator() {
    }

    public ChartAnimator(UpdateListener listener) {
        this.mListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startAnimationLoop() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHandler != null) {
                this.mHandler.removeMessages(0);
                this.mHandler = null;
            }
            this.mHandler = new FrameHandler();
            this.mHandler.queueNowFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.mEnabledX = false;
        this.mEnabledY = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHandler != null) {
                this.mHandler.removeMessages(0);
                this.mHandler = null;
            }
        }
    }

    public void animateXY(int durationMillisX, int durationMillisY, AnimationEasing.EasingFunction easing) {
        this.stop();
        this.mStartTime = SystemClock.uptimeMillis();
        this.mXDuration = durationMillisX;
        this.mYDuration = durationMillisY;
        this.mEndTimeX = this.mStartTime + (long)durationMillisX;
        this.mEndTimeY = this.mStartTime + (long)durationMillisY;
        this.mEndTime = this.mEndTimeX > this.mEndTimeY ? this.mEndTimeX : this.mEndTimeY;
        this.mEnabledX = durationMillisX > 0;
        this.mEnabledY = durationMillisY > 0;
        this.mEasing = easing;
        if (this.mEnabledX || this.mEnabledY) {
            this.startAnimationLoop();
        }
    }

    public void animateXY(int durationMillisX, int durationMillisY, AnimationEasing.EasingOption easing) {
        this.animateXY(durationMillisX, durationMillisY, AnimationEasing.getEasingFunctionFromOption(easing));
    }

    public void animateXY(int durationMillisX, int durationMillisY) {
        this.animateXY(durationMillisX, durationMillisY, AnimationEasing.EasingOption.EaseInOutSine);
    }

    public void animateY(int durationMillis, AnimationEasing.EasingFunction easing) {
        this.animateXY(0, durationMillis, easing);
    }

    public void animateY(int durationMillis, AnimationEasing.EasingOption easing) {
        this.animateXY(0, durationMillis, AnimationEasing.getEasingFunctionFromOption(easing));
    }

    public void animateY(int durationMillis) {
        this.animateXY(0, durationMillis, AnimationEasing.EasingOption.EaseInOutSine);
    }

    public void animateX(int durationMillis, AnimationEasing.EasingFunction easing) {
        this.animateXY(durationMillis, 0, easing);
    }

    public void animateX(int durationMillis, AnimationEasing.EasingOption easing) {
        this.animateXY(durationMillis, 0, AnimationEasing.getEasingFunctionFromOption(easing));
    }

    public void animateX(int durationMillis) {
        this.animateXY(durationMillis, 0, AnimationEasing.EasingOption.EaseInOutSine);
    }

    public float getPhaseY() {
        return this.mPhaseY;
    }

    public void setPhaseY(float phase) {
        this.mPhaseY = phase;
    }

    public float getPhaseX() {
        return this.mPhaseX;
    }

    public void setPhaseX(float phase) {
        this.mPhaseX = phase;
    }

    @SuppressLint(value={"HandlerLeak"})
    public class FrameHandler
    extends Handler {
        private Runnable frameHandler = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ChartAnimator.this.mLock;
                synchronized (object) {
                    long duration;
                    long elapsed;
                    long currentTime = SystemClock.uptimeMillis();
                    long elapsedTime = currentTime - ChartAnimator.this.mStartTime;
                    if (ChartAnimator.this.mEnabledX) {
                        elapsed = elapsedTime;
                        duration = ChartAnimator.this.mXDuration;
                        if (elapsed > duration) {
                            elapsed = duration;
                        }
                        ChartAnimator.this.mPhaseX = ChartAnimator.this.mEasing != null ? ChartAnimator.this.mEasing.ease(elapsed, duration) : (float)elapsed / (float)duration;
                    }
                    if (ChartAnimator.this.mEnabledY) {
                        elapsed = elapsedTime;
                        duration = ChartAnimator.this.mYDuration;
                        if (elapsed > duration) {
                            elapsed = duration;
                        }
                        ChartAnimator.this.mPhaseY = ChartAnimator.this.mEasing != null ? ChartAnimator.this.mEasing.ease(elapsed, duration) : (float)elapsed / (float)duration;
                    }
                    if (currentTime >= ChartAnimator.this.mEndTime) {
                        ChartAnimator.this.stop();
                    }
                    if (ChartAnimator.this.mEnabledX || ChartAnimator.this.mEnabledY) {
                        FrameHandler.this.queueNextFrame();
                    }
                    if (ChartAnimator.this.mListener != null) {
                        ChartAnimator.this.mListener.onAnimationUpdate();
                    }
                }
            }
        };

        public void queueNextFrame() {
            this.postAtTime(this.frameHandler, SystemClock.uptimeMillis() + 15L);
        }

        public void queueNowFrame() {
            this.post(this.frameHandler);
        }
    }

    public static interface UpdateListener {
        public void onAnimationUpdate();
    }
}

