/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventhubs.models.CaptureDescription;
import com.azure.resourcemanager.eventhubs.models.EntityStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

@JsonFlatten
public class EventhubInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EventhubInner.class);
    @JsonProperty(value="properties.partitionIds", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> partitionIds;
    @JsonProperty(value="properties.createdAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdAt;
    @JsonProperty(value="properties.updatedAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime updatedAt;
    @JsonProperty(value="properties.messageRetentionInDays")
    private Long messageRetentionInDays;
    @JsonProperty(value="properties.partitionCount")
    private Long partitionCount;
    @JsonProperty(value="properties.status")
    private EntityStatus status;
    @JsonProperty(value="properties.captureDescription")
    private CaptureDescription captureDescription;

    public List<String> partitionIds() {
        return this.partitionIds;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public Long messageRetentionInDays() {
        return this.messageRetentionInDays;
    }

    public EventhubInner withMessageRetentionInDays(Long messageRetentionInDays) {
        this.messageRetentionInDays = messageRetentionInDays;
        return this;
    }

    public Long partitionCount() {
        return this.partitionCount;
    }

    public EventhubInner withPartitionCount(Long partitionCount) {
        this.partitionCount = partitionCount;
        return this;
    }

    public EntityStatus status() {
        return this.status;
    }

    public EventhubInner withStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public CaptureDescription captureDescription() {
        return this.captureDescription;
    }

    public EventhubInner withCaptureDescription(CaptureDescription captureDescription) {
        this.captureDescription = captureDescription;
        return this;
    }

    public void validate() {
        if (this.captureDescription() != null) {
            this.captureDescription().validate();
        }
    }
}

