/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.WebTestLocationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentWebTestLocationInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsComponentWebTestLocationImpl;
import com.azure.resourcemanager.applicationinsights.implementation.Utils;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentWebTestLocation;
import com.azure.resourcemanager.applicationinsights.models.WebTestLocations;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class WebTestLocationsImpl
implements WebTestLocations {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WebTestLocationsImpl.class);
    private final WebTestLocationsClient innerClient;
    private final ApplicationInsightsManager serviceManager;

    public WebTestLocationsImpl(WebTestLocationsClient innerClient, ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ApplicationInsightsComponentWebTestLocation> list(String resourceGroupName, String resourceName) {
        PagedIterable<ApplicationInsightsComponentWebTestLocationInner> inner = this.serviceClient().list(resourceGroupName, resourceName);
        return Utils.mapPage(inner, inner1 -> new ApplicationInsightsComponentWebTestLocationImpl((ApplicationInsightsComponentWebTestLocationInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ApplicationInsightsComponentWebTestLocation> list(String resourceGroupName, String resourceName, Context context) {
        PagedIterable<ApplicationInsightsComponentWebTestLocationInner> inner = this.serviceClient().list(resourceGroupName, resourceName, context);
        return Utils.mapPage(inner, inner1 -> new ApplicationInsightsComponentWebTestLocationImpl((ApplicationInsightsComponentWebTestLocationInner)inner1, this.manager()));
    }

    private WebTestLocationsClient serviceClient() {
        return this.innerClient;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }
}

