/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.applicationinsights.fluent.MyWorkbooksClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.MyWorkbookInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsManagementClientImpl;
import com.azure.resourcemanager.applicationinsights.models.CategoryType;
import com.azure.resourcemanager.applicationinsights.models.ErrorDefinitionException;
import com.azure.resourcemanager.applicationinsights.models.MyWorkbooksListResult;
import java.util.List;
import reactor.core.publisher.Mono;

public final class MyWorkbooksClientImpl
implements MyWorkbooksClient {
    private final ClientLogger logger = new ClientLogger(MyWorkbooksClientImpl.class);
    private final MyWorkbooksService service;
    private final ApplicationInsightsManagementClientImpl client;

    MyWorkbooksClientImpl(ApplicationInsightsManagementClientImpl client) {
        this.service = (MyWorkbooksService)RestProxy.create(MyWorkbooksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MyWorkbookInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, CategoryType category, List<String> tags, String sourceId, Boolean canFetchContent) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (category == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter category is required and cannot be null."));
        }
        String apiVersion = "2020-10-20";
        String accept = "application/json";
        String tagsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(tags, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, category, tagsConverted, sourceId, canFetchContent, "2020-10-20", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MyWorkbooksListResult)res.getValue()).value(), ((MyWorkbooksListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<MyWorkbookInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, CategoryType category, List<String> tags, String sourceId, Boolean canFetchContent, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (category == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter category is required and cannot be null."));
        }
        String apiVersion = "2020-10-20";
        String accept = "application/json";
        String tagsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(tags, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, category, tagsConverted, sourceId, canFetchContent, "2020-10-20", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MyWorkbooksListResult)res.getValue()).value(), ((MyWorkbooksListResult)res.getValue()).nextLink(), null));
    }

    private PagedFlux<MyWorkbookInner> listByResourceGroupAsync(String resourceGroupName, CategoryType category, List<String> tags, String sourceId, Boolean canFetchContent) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, category, tags, sourceId, canFetchContent), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MyWorkbookInner> listByResourceGroupAsync(String resourceGroupName, CategoryType category) {
        List tags = null;
        String sourceId = null;
        Boolean canFetchContent = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, category, tags, sourceId, canFetchContent), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MyWorkbookInner> listByResourceGroupAsync(String resourceGroupName, CategoryType category, List<String> tags, String sourceId, Boolean canFetchContent, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, category, tags, sourceId, canFetchContent, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MyWorkbookInner> listByResourceGroup(String resourceGroupName, CategoryType category) {
        List<String> tags = null;
        String sourceId = null;
        Boolean canFetchContent = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, category, tags, sourceId, canFetchContent));
    }

    @Override
    public PagedIterable<MyWorkbookInner> listByResourceGroup(String resourceGroupName, CategoryType category, List<String> tags, String sourceId, Boolean canFetchContent, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, category, tags, sourceId, canFetchContent, context));
    }

    private Mono<PagedResponse<MyWorkbookInner>> listSinglePageAsync(CategoryType category, List<String> tags, Boolean canFetchContent) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (category == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter category is required and cannot be null."));
        }
        String apiVersion = "2020-10-20";
        String accept = "application/json";
        String tagsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(tags, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), category, tagsConverted, canFetchContent, "2020-10-20", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MyWorkbooksListResult)res.getValue()).value(), ((MyWorkbooksListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<MyWorkbookInner>> listSinglePageAsync(CategoryType category, List<String> tags, Boolean canFetchContent, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (category == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter category is required and cannot be null."));
        }
        String apiVersion = "2020-10-20";
        String accept = "application/json";
        String tagsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(tags, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), category, tagsConverted, canFetchContent, "2020-10-20", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MyWorkbooksListResult)res.getValue()).value(), ((MyWorkbooksListResult)res.getValue()).nextLink(), null));
    }

    private PagedFlux<MyWorkbookInner> listAsync(CategoryType category, List<String> tags, Boolean canFetchContent) {
        return new PagedFlux(() -> this.listSinglePageAsync(category, tags, canFetchContent), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MyWorkbookInner> listAsync(CategoryType category) {
        List tags = null;
        Boolean canFetchContent = null;
        return new PagedFlux(() -> this.listSinglePageAsync(category, tags, canFetchContent), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MyWorkbookInner> listAsync(CategoryType category, List<String> tags, Boolean canFetchContent, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(category, tags, canFetchContent, context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MyWorkbookInner> list(CategoryType category) {
        List<String> tags = null;
        Boolean canFetchContent = null;
        return new PagedIterable(this.listAsync(category, tags, canFetchContent));
    }

    @Override
    public PagedIterable<MyWorkbookInner> list(CategoryType category, List<String> tags, Boolean canFetchContent, Context context) {
        return new PagedIterable(this.listAsync(category, tags, canFetchContent, context));
    }

    private Mono<Response<MyWorkbookInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2020-10-20";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "2020-10-20", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<MyWorkbookInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2020-10-20";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "2020-10-20", "application/json", context);
    }

    private Mono<MyWorkbookInner> getByResourceGroupAsync(String resourceGroupName, String resourceName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, resourceName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MyWorkbookInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public MyWorkbookInner getByResourceGroup(String resourceGroupName, String resourceName) {
        return (MyWorkbookInner)((Object)this.getByResourceGroupAsync(resourceGroupName, resourceName).block());
    }

    @Override
    public Response<MyWorkbookInner> getByResourceGroupWithResponse(String resourceGroupName, String resourceName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, resourceName, context).block();
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2020-10-20";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "2020-10-20", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2020-10-20";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "2020-10-20", "application/json", context);
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName) {
        return this.deleteWithResponseAsync(resourceGroupName, resourceName).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String resourceName) {
        this.deleteAsync(resourceGroupName, resourceName).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, resourceName, context).block();
    }

    private Mono<Response<MyWorkbookInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName, MyWorkbookInner workbookProperties, String sourceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (workbookProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workbookProperties is required and cannot be null."));
        }
        workbookProperties.validate();
        String apiVersion = "2020-10-20";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, sourceId, "2020-10-20", workbookProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<MyWorkbookInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName, MyWorkbookInner workbookProperties, String sourceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (workbookProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workbookProperties is required and cannot be null."));
        }
        workbookProperties.validate();
        String apiVersion = "2020-10-20";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, sourceId, "2020-10-20", workbookProperties, "application/json", context);
    }

    private Mono<MyWorkbookInner> createOrUpdateAsync(String resourceGroupName, String resourceName, MyWorkbookInner workbookProperties, String sourceId) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, workbookProperties, sourceId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MyWorkbookInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    private Mono<MyWorkbookInner> createOrUpdateAsync(String resourceGroupName, String resourceName, MyWorkbookInner workbookProperties) {
        String sourceId = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, workbookProperties, sourceId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MyWorkbookInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public MyWorkbookInner createOrUpdate(String resourceGroupName, String resourceName, MyWorkbookInner workbookProperties) {
        String sourceId = null;
        return (MyWorkbookInner)((Object)this.createOrUpdateAsync(resourceGroupName, resourceName, workbookProperties, sourceId).block());
    }

    @Override
    public Response<MyWorkbookInner> createOrUpdateWithResponse(String resourceGroupName, String resourceName, MyWorkbookInner workbookProperties, String sourceId, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, workbookProperties, sourceId, context).block();
    }

    private Mono<Response<MyWorkbookInner>> updateWithResponseAsync(String resourceGroupName, String resourceName, MyWorkbookInner workbookProperties, String sourceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (workbookProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workbookProperties is required and cannot be null."));
        }
        workbookProperties.validate();
        String apiVersion = "2020-10-20";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, sourceId, "2020-10-20", workbookProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<MyWorkbookInner>> updateWithResponseAsync(String resourceGroupName, String resourceName, MyWorkbookInner workbookProperties, String sourceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (workbookProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workbookProperties is required and cannot be null."));
        }
        workbookProperties.validate();
        String apiVersion = "2020-10-20";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, sourceId, "2020-10-20", workbookProperties, "application/json", context);
    }

    private Mono<MyWorkbookInner> updateAsync(String resourceGroupName, String resourceName, MyWorkbookInner workbookProperties, String sourceId) {
        return this.updateWithResponseAsync(resourceGroupName, resourceName, workbookProperties, sourceId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MyWorkbookInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    private Mono<MyWorkbookInner> updateAsync(String resourceGroupName, String resourceName, MyWorkbookInner workbookProperties) {
        String sourceId = null;
        return this.updateWithResponseAsync(resourceGroupName, resourceName, workbookProperties, sourceId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MyWorkbookInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public MyWorkbookInner update(String resourceGroupName, String resourceName, MyWorkbookInner workbookProperties) {
        String sourceId = null;
        return (MyWorkbookInner)((Object)this.updateAsync(resourceGroupName, resourceName, workbookProperties, sourceId).block());
    }

    @Override
    public Response<MyWorkbookInner> updateWithResponse(String resourceGroupName, String resourceName, MyWorkbookInner workbookProperties, String sourceId, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, resourceName, workbookProperties, sourceId, context).block();
    }

    private Mono<PagedResponse<MyWorkbookInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MyWorkbooksListResult)res.getValue()).value(), ((MyWorkbooksListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<MyWorkbookInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MyWorkbooksListResult)res.getValue()).value(), ((MyWorkbooksListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<MyWorkbookInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MyWorkbooksListResult)res.getValue()).value(), ((MyWorkbooksListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<MyWorkbookInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MyWorkbooksListResult)res.getValue()).value(), ((MyWorkbooksListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApplicationInsightsM")
    private static interface MyWorkbooksService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/myWorkbooks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDefinitionException.class)
        public Mono<Response<MyWorkbooksListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="category") CategoryType var4, @QueryParam(value="tags") String var5, @QueryParam(value="sourceId") String var6, @QueryParam(value="canFetchContent") Boolean var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/myWorkbooks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDefinitionException.class)
        public Mono<Response<MyWorkbooksListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="category") CategoryType var3, @QueryParam(value="tags") String var4, @QueryParam(value="canFetchContent") Boolean var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/myWorkbooks/{resourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDefinitionException.class)
        public Mono<Response<MyWorkbookInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/myWorkbooks/{resourceName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ErrorDefinitionException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/myWorkbooks/{resourceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorDefinitionException.class)
        public Mono<Response<MyWorkbookInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceName") String var4, @QueryParam(value="sourceId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") MyWorkbookInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/myWorkbooks/{resourceName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorDefinitionException.class)
        public Mono<Response<MyWorkbookInner>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceName") String var4, @QueryParam(value="sourceId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") MyWorkbookInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDefinitionException.class)
        public Mono<Response<MyWorkbooksListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDefinitionException.class)
        public Mono<Response<MyWorkbooksListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

