/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.applicationinsights.fluent.ApiKeysClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentApiKeyInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsManagementClientImpl;
import com.azure.resourcemanager.applicationinsights.models.ApiKeyRequest;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentApiKeyListResult;
import reactor.core.publisher.Mono;

public final class ApiKeysClientImpl
implements ApiKeysClient {
    private final ClientLogger logger = new ClientLogger(ApiKeysClientImpl.class);
    private final ApiKeysService service;
    private final ApplicationInsightsManagementClientImpl client;

    ApiKeysClientImpl(ApplicationInsightsManagementClientImpl client) {
        this.service = (ApiKeysService)RestProxy.create(ApiKeysService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<ApplicationInsightsComponentApiKeyInner>> listSinglePageAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationInsightsComponentApiKeyListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<PagedResponse<ApplicationInsightsComponentApiKeyInner>> listSinglePageAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationInsightsComponentApiKeyListResult)res.getValue()).value(), null, null));
    }

    private PagedFlux<ApplicationInsightsComponentApiKeyInner> listAsync(String resourceGroupName, String resourceName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, resourceName));
    }

    private PagedFlux<ApplicationInsightsComponentApiKeyInner> listAsync(String resourceGroupName, String resourceName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, resourceName, context));
    }

    @Override
    public PagedIterable<ApplicationInsightsComponentApiKeyInner> list(String resourceGroupName, String resourceName) {
        return new PagedIterable(this.listAsync(resourceGroupName, resourceName));
    }

    @Override
    public PagedIterable<ApplicationInsightsComponentApiKeyInner> list(String resourceGroupName, String resourceName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, resourceName, context));
    }

    private Mono<Response<ApplicationInsightsComponentApiKeyInner>> createWithResponseAsync(String resourceGroupName, String resourceName, ApiKeyRequest apiKeyProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiKeyProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiKeyProperties is required and cannot be null."));
        }
        apiKeyProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, apiKeyProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<ApplicationInsightsComponentApiKeyInner>> createWithResponseAsync(String resourceGroupName, String resourceName, ApiKeyRequest apiKeyProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (apiKeyProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter apiKeyProperties is required and cannot be null."));
        }
        apiKeyProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, apiKeyProperties, "application/json", context);
    }

    private Mono<ApplicationInsightsComponentApiKeyInner> createAsync(String resourceGroupName, String resourceName, ApiKeyRequest apiKeyProperties) {
        return this.createWithResponseAsync(resourceGroupName, resourceName, apiKeyProperties).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ApplicationInsightsComponentApiKeyInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ApplicationInsightsComponentApiKeyInner create(String resourceGroupName, String resourceName, ApiKeyRequest apiKeyProperties) {
        return (ApplicationInsightsComponentApiKeyInner)this.createAsync(resourceGroupName, resourceName, apiKeyProperties).block();
    }

    @Override
    public Response<ApplicationInsightsComponentApiKeyInner> createWithResponse(String resourceGroupName, String resourceName, ApiKeyRequest apiKeyProperties, Context context) {
        return (Response)this.createWithResponseAsync(resourceGroupName, resourceName, apiKeyProperties, context).block();
    }

    private Mono<Response<ApplicationInsightsComponentApiKeyInner>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String keyId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (keyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, keyId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<ApplicationInsightsComponentApiKeyInner>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String keyId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (keyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, keyId, "application/json", context);
    }

    private Mono<ApplicationInsightsComponentApiKeyInner> deleteAsync(String resourceGroupName, String resourceName, String keyId) {
        return this.deleteWithResponseAsync(resourceGroupName, resourceName, keyId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ApplicationInsightsComponentApiKeyInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ApplicationInsightsComponentApiKeyInner delete(String resourceGroupName, String resourceName, String keyId) {
        return (ApplicationInsightsComponentApiKeyInner)this.deleteAsync(resourceGroupName, resourceName, keyId).block();
    }

    @Override
    public Response<ApplicationInsightsComponentApiKeyInner> deleteWithResponse(String resourceGroupName, String resourceName, String keyId, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, resourceName, keyId, context).block();
    }

    private Mono<Response<ApplicationInsightsComponentApiKeyInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String keyId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (keyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, keyId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<ApplicationInsightsComponentApiKeyInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String keyId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (keyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, keyId, "application/json", context);
    }

    private Mono<ApplicationInsightsComponentApiKeyInner> getAsync(String resourceGroupName, String resourceName, String keyId) {
        return this.getWithResponseAsync(resourceGroupName, resourceName, keyId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ApplicationInsightsComponentApiKeyInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ApplicationInsightsComponentApiKeyInner get(String resourceGroupName, String resourceName, String keyId) {
        return (ApplicationInsightsComponentApiKeyInner)this.getAsync(resourceGroupName, resourceName, keyId).block();
    }

    @Override
    public Response<ApplicationInsightsComponentApiKeyInner> getWithResponse(String resourceGroupName, String resourceName, String keyId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceName, keyId, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApplicationInsightsM")
    private static interface ApiKeysService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ApiKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationInsightsComponentApiKeyListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ApiKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationInsightsComponentApiKeyInner>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @BodyParam(value="application/json") ApiKeyRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/APIKeys/{keyId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationInsightsComponentApiKeyInner>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="keyId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/APIKeys/{keyId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationInsightsComponentApiKeyInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="keyId") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

