/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.AnnotationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.AnnotationInner;
import com.azure.resourcemanager.applicationinsights.implementation.AnnotationImpl;
import com.azure.resourcemanager.applicationinsights.implementation.Utils;
import com.azure.resourcemanager.applicationinsights.models.Annotation;
import com.azure.resourcemanager.applicationinsights.models.Annotations;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class AnnotationsImpl
implements Annotations {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AnnotationsImpl.class);
    private final AnnotationsClient innerClient;
    private final ApplicationInsightsManager serviceManager;

    public AnnotationsImpl(AnnotationsClient innerClient, ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Annotation> list(String resourceGroupName, String resourceName, String start, String end) {
        PagedIterable<AnnotationInner> inner = this.serviceClient().list(resourceGroupName, resourceName, start, end);
        return Utils.mapPage(inner, inner1 -> new AnnotationImpl((AnnotationInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Annotation> list(String resourceGroupName, String resourceName, String start, String end, Context context) {
        PagedIterable<AnnotationInner> inner = this.serviceClient().list(resourceGroupName, resourceName, start, end, context);
        return Utils.mapPage(inner, inner1 -> new AnnotationImpl((AnnotationInner)inner1, this.manager()));
    }

    @Override
    public List<Annotation> create(String resourceGroupName, String resourceName, AnnotationInner annotationProperties) {
        List<AnnotationInner> inner = this.serviceClient().create(resourceGroupName, resourceName, annotationProperties);
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new AnnotationImpl((AnnotationInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public Response<List<Annotation>> createWithResponse(String resourceGroupName, String resourceName, AnnotationInner annotationProperties, Context context) {
        Response<List<AnnotationInner>> inner = this.serviceClient().createWithResponse(resourceGroupName, resourceName, annotationProperties, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), ((List)inner.getValue()).stream().map(inner1 -> new AnnotationImpl((AnnotationInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String resourceName, String annotationId) {
        this.serviceClient().delete(resourceGroupName, resourceName, annotationId);
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, String annotationId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, resourceName, annotationId, context);
    }

    @Override
    public List<Annotation> get(String resourceGroupName, String resourceName, String annotationId) {
        List<AnnotationInner> inner = this.serviceClient().get(resourceGroupName, resourceName, annotationId);
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new AnnotationImpl((AnnotationInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public Response<List<Annotation>> getWithResponse(String resourceGroupName, String resourceName, String annotationId, Context context) {
        Response<List<AnnotationInner>> inner = this.serviceClient().getWithResponse(resourceGroupName, resourceName, annotationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), ((List)inner.getValue()).stream().map(inner1 -> new AnnotationImpl((AnnotationInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return null;
    }

    private AnnotationsClient serviceClient() {
        return this.innerClient;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }
}

