/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.broker.webapi;

import cn.wizzer.iot.mqtt.server.broker.cluster.RedisCluster;
import cn.wizzer.iot.mqtt.server.broker.config.BrokerProperties;
import cn.wizzer.iot.mqtt.server.broker.internal.InternalMessage;
import cn.wizzer.iot.mqtt.server.broker.internal.InternalSendServer;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.util.ArrayList;
import java.util.List;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.adaptor.JsonAdaptor;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

@IocBean
@At(value={"/open/api/mqttwk"})
public class WebApiController {
    private static final Log log = Logs.get();
    private static final String CACHE_SESSION_PRE = "mqttwk:session:";
    private static final String CACHE_CLIENT_PRE = "mqttwk:client:";
    @Inject
    private RedisService redisService;
    @Inject
    private InternalSendServer internalSendServer;
    @Inject
    private BrokerProperties brokerProperties;
    @Inject
    private RedisCluster redisCluster;

    @At(value={"/send"})
    @Ok(value="json")
    @AdaptBy(type=JsonAdaptor.class)
    public Object send(NutMap data) {
        NutMap nutMap = NutMap.NEW();
        try {
            String processId = Lang.JdkTool.getProcessId((String)"0");
            InternalMessage message = new InternalMessage();
            message.setBrokerId(this.brokerProperties.getId());
            message.setProcessId(processId);
            message.setClientId(R.UU32());
            message.setTopic(data.getString("topic", ""));
            message.setRetain(data.getBoolean("retain"));
            message.setDup(data.getBoolean("dup"));
            message.setMqttQoS(data.getInt("qos"));
            message.setMessageBytes(data.getString("message", "").getBytes());
            log.debug((Object)("send:::" + Json.toJson((Object)message)));
            if (this.brokerProperties.getClusterEnabled()) {
                this.redisCluster.sendMessage(message);
            } else {
                this.internalSendServer.sendPublishMessage(message.getClientId(), message.getTopic(), MqttQoS.valueOf((int)message.getMqttQoS()), message.getMessageBytes(), message.isRetain(), message.isDup());
            }
            nutMap.put((Object)"code", (Object)0);
            nutMap.put((Object)"msg", (Object)"success");
        }
        catch (Exception e) {
            log.error((Object)e);
            nutMap.put((Object)"code", (Object)-1);
            nutMap.put((Object)"msg", (Object)e.getMessage());
        }
        return nutMap;
    }

    @At(value={"/test_send"})
    @Ok(value="json")
    public Object test_send() {
        NutMap nutMap = NutMap.NEW();
        try {
            Request req = Request.create((String)"http://127.0.0.1:8922/open/api/mqttwk/send", (Request.METHOD)Request.METHOD.POST);
            NutMap message = NutMap.NEW();
            message.addv("topic", (Object)"/topic/mqttwk");
            message.addv("retain", (Object)true);
            message.addv("dup", (Object)true);
            message.addv("qos", (Object)1);
            message.addv("message", (Object)"wizzer");
            req.setData(Json.toJson((Object)message));
            Response resp = Sender.create((Request)req).send();
            if (resp.isOK()) {
                nutMap.put((Object)"code", (Object)0);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            nutMap.put((Object)"code", (Object)-1);
        }
        return nutMap;
    }

    @At(value={"/info"})
    @Ok(value="json")
    public Object info() {
        NutMap nutMap = NutMap.NEW();
        try {
            ScanResult scanResult;
            String cursor;
            NutMap data = NutMap.NEW();
            ScanParams scanParams = new ScanParams();
            scanParams.match("mqttwk:session:*");
            scanParams.count(Integer.valueOf(Integer.MAX_VALUE));
            ArrayList list = new ArrayList();
            int total = 0;
            do {
                List elements;
                if ((elements = (scanResult = this.redisService.scan("0", scanParams)).getResult()) == null || elements.size() <= 0) continue;
                list.addAll(elements);
                total += elements.size();
            } while (!"0".equals(cursor = scanResult.getStringCursor()));
            ArrayList<NutMap> dataList = new ArrayList<NutMap>();
            for (String k : list) {
                dataList.add(NutMap.NEW().addv("clientId", (Object)k.substring(k.lastIndexOf(":") + 1)).addv("topics", (Object)this.redisService.smembers(CACHE_CLIENT_PRE + k.substring(k.lastIndexOf(":") + 1))));
            }
            data.addv("total", (Object)total);
            data.addv("list", dataList);
            nutMap.put((Object)"code", (Object)0);
            nutMap.put((Object)"msg", (Object)"");
            nutMap.put((Object)"data", (Object)data);
        }
        catch (Exception e) {
            log.error((Object)e);
            nutMap.put((Object)"code", (Object)-1);
            nutMap.put((Object)"msg", (Object)e.getMessage());
        }
        return nutMap;
    }
}

