/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.broker.protocol;

import cn.wizzer.iot.mqtt.server.common.subscribe.ISubscribeStoreService;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.util.AttributeKey;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnSubscribe {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnSubscribe.class);
    private ISubscribeStoreService subscribeStoreService;

    public UnSubscribe(ISubscribeStoreService subscribeStoreService) {
        this.subscribeStoreService = subscribeStoreService;
    }

    public void processUnSubscribe(Channel channel, MqttUnsubscribeMessage msg) {
        List topicFilters = msg.payload().topics();
        String clinetId = (String)channel.attr(AttributeKey.valueOf((String)"clientId")).get();
        topicFilters.forEach(topicFilter -> {
            this.subscribeStoreService.remove(topicFilter, clinetId);
            LOGGER.debug("UNSUBSCRIBE - clientId: {}, topicFilter: {}", (Object)clinetId, topicFilter);
        });
        MqttUnsubAckMessage unsubAckMessage = (MqttUnsubAckMessage)MqttMessageFactory.newMessage((MqttFixedHeader)new MqttFixedHeader(MqttMessageType.UNSUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0), (Object)MqttMessageIdVariableHeader.from((int)msg.variableHeader().messageId()), null);
        channel.writeAndFlush((Object)unsubAckMessage);
    }
}

