/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.broker.protocol;

import cn.wizzer.iot.mqtt.server.broker.protocol.PubRel;
import cn.wizzer.iot.mqtt.server.common.message.DupPubRelMessageStore;
import cn.wizzer.iot.mqtt.server.common.message.IDupPubRelMessageStoreService;
import cn.wizzer.iot.mqtt.server.common.message.IDupPublishMessageStoreService;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.util.AttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubRec {
    private static final Logger LOGGER = LoggerFactory.getLogger(PubRel.class);
    private IDupPublishMessageStoreService dupPublishMessageStoreService;
    private IDupPubRelMessageStoreService dupPubRelMessageStoreService;

    public PubRec(IDupPublishMessageStoreService dupPublishMessageStoreService, IDupPubRelMessageStoreService dupPubRelMessageStoreService) {
        this.dupPublishMessageStoreService = dupPublishMessageStoreService;
        this.dupPubRelMessageStoreService = dupPubRelMessageStoreService;
    }

    public void processPubRec(Channel channel, MqttMessageIdVariableHeader variableHeader) {
        MqttMessage pubRelMessage = MqttMessageFactory.newMessage((MqttFixedHeader)new MqttFixedHeader(MqttMessageType.PUBREL, false, MqttQoS.AT_MOST_ONCE, false, 0), (Object)MqttMessageIdVariableHeader.from((int)variableHeader.messageId()), null);
        LOGGER.debug("PUBREC - clientId: {}, messageId: {}", (Object)((String)channel.attr(AttributeKey.valueOf((String)"clientId")).get()), (Object)variableHeader.messageId());
        this.dupPublishMessageStoreService.remove((String)channel.attr(AttributeKey.valueOf((String)"clientId")).get(), variableHeader.messageId());
        DupPubRelMessageStore dupPubRelMessageStore = new DupPubRelMessageStore().setClientId((String)channel.attr(AttributeKey.valueOf((String)"clientId")).get()).setMessageId(variableHeader.messageId());
        this.dupPubRelMessageStoreService.put((String)channel.attr(AttributeKey.valueOf((String)"clientId")).get(), dupPubRelMessageStore);
        channel.writeAndFlush((Object)pubRelMessage);
    }
}

