/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.broker.protocol;

import cn.wizzer.iot.mqtt.server.broker.config.BrokerProperties;
import cn.wizzer.iot.mqtt.server.common.session.ISessionStoreService;
import cn.wizzer.iot.mqtt.server.common.session.SessionStore;
import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.util.AttributeKey;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingReq {
    private static final Logger LOGGER = LoggerFactory.getLogger(PingReq.class);
    private ISessionStoreService sessionStoreService;
    private BrokerProperties brokerProperties;
    private ChannelGroup channelGroup;
    private Map<String, ChannelId> channelIdMap;

    public PingReq(ISessionStoreService sessionStoreService, BrokerProperties brokerProperties, ChannelGroup channelGroup, Map<String, ChannelId> channelIdMap) {
        this.sessionStoreService = sessionStoreService;
        this.brokerProperties = brokerProperties;
        this.channelGroup = channelGroup;
        this.channelIdMap = channelIdMap;
    }

    public void processPingReq(Channel channel, MqttMessage msg) {
        String clientId = (String)channel.attr(AttributeKey.valueOf((String)"clientId")).get();
        if (this.sessionStoreService.containsKey(clientId)) {
            SessionStore sessionStore = this.sessionStoreService.get(clientId);
            ChannelId channelId = this.channelIdMap.get(sessionStore.getBrokerId() + "_" + sessionStore.getChannelId());
            if (this.brokerProperties.getId().equals(sessionStore.getBrokerId()) && channelId != null) {
                this.sessionStoreService.expire(clientId, sessionStore.getExpire());
                MqttMessage pingRespMessage = MqttMessageFactory.newMessage((MqttFixedHeader)new MqttFixedHeader(MqttMessageType.PINGRESP, false, MqttQoS.AT_MOST_ONCE, false, 0), null, null);
                LOGGER.debug("PINGREQ - clientId: {}", (Object)clientId);
                channel.writeAndFlush((Object)pingRespMessage);
            }
        }
    }
}

