/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.broker.internal;

import cn.wizzer.iot.mqtt.server.broker.cluster.RedisCluster;
import cn.wizzer.iot.mqtt.server.broker.config.BrokerProperties;
import cn.wizzer.iot.mqtt.server.broker.internal.InternalMessage;
import cn.wizzer.iot.mqtt.server.broker.service.KafkaService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IocBean
public class InternalCommunication {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalCommunication.class);
    @Inject
    private BrokerProperties brokerProperties;
    @Inject
    private KafkaService kafkaService;
    @Inject
    private RedisCluster redisCluster;

    public void internalSend(InternalMessage internalMessage) {
        String processId = Lang.JdkTool.getProcessId((String)"0");
        internalMessage.setBrokerId(this.brokerProperties.getId());
        internalMessage.setProcessId(processId);
        if (this.brokerProperties.getKafkaBrokerEnabled()) {
            this.kafkaService.send(internalMessage);
        }
        if (this.brokerProperties.getClusterEnabled()) {
            this.redisCluster.sendMessage(internalMessage);
        }
    }
}

