/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.iot.mqtt.server.auth.service;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.wizzer.iot.mqtt.server.common.auth.IAuthService;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import org.nutz.ioc.loader.annotation.IocBean;

@IocBean(create="init")
public class AuthService
implements IAuthService {
    private RSAPrivateKey privateKey;

    public boolean checkValid(String username, String password) {
        if (StrUtil.isBlank((CharSequence)username)) {
            return false;
        }
        if (StrUtil.isBlank((CharSequence)password)) {
            return false;
        }
        RSA rsa = new RSA((PrivateKey)this.privateKey, null);
        String value = rsa.encryptBcd(username, KeyType.PrivateKey);
        return value.equals(password);
    }

    public void init() {
        this.privateKey = (RSAPrivateKey)IoUtil.readObj((InputStream)AuthService.class.getClassLoader().getResourceAsStream("keystore/auth-private.key"));
    }
}

