/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.web.upload;

import cn.weforward.common.Dictionary;
import cn.weforward.common.KvPair;
import cn.weforward.common.io.BytesInputStream;
import cn.weforward.common.io.BytesOutputStream;
import cn.weforward.common.util.Bytes;
import cn.weforward.framework.web.upload.WebForm;
import cn.weforward.framework.web.upload.WebUpload;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class WebFileUpload
extends WebUpload {
    protected int m_MaxFileCount;
    protected String m_AllowFileExt;
    protected String m_DenialFileExt;
    protected int m_FileCount;
    protected Dictionary<String, Object> m_DirectSend;
    private static byte[] MARK_UNREACHABLE = new byte[0];

    public WebFileUpload() {
        this.m_DirectSend = Dictionary.Util.empty();
    }

    public WebFileUpload(List<KvPair<String, Object>> toFiles) {
        this.m_DirectSend = Dictionary.Util.valueOf(toFiles);
    }

    public int getFileCount() {
        return this.m_FileCount;
    }

    public int getMaxFileCount() {
        return this.m_MaxFileCount;
    }

    public void setMaxFileCount(int maxFileCount) {
        this.m_MaxFileCount = maxFileCount;
    }

    public String getAllowFileExt() {
        return this.m_AllowFileExt;
    }

    public void setAllowFileExt(String fileExt) {
        this.m_AllowFileExt = fileExt;
    }

    public String getDenialFileExt() {
        return this.m_DenialFileExt;
    }

    public void setDenialFileExt(String fileExt) {
        this.m_DenialFileExt = fileExt;
    }

    @Override
    protected WebForm onFetchForm(InputStream in, List<WebForm.Header> headers) throws IOException {
        WebFormMix form = new WebFormMix(headers);
        if (form.getFileName() != null && form.getFileName().length() != 0) {
            if (this.m_MaxFileCount > 0 && this.m_FileCount >= this.m_MaxFileCount) {
                throw new IOException("Over count:" + this.m_FileCount + ">" + this.m_MaxFileCount);
            }
            ++this.m_FileCount;
            String ext = form.getFileNameExt();
            if (ext != null) {
                ext = ext.length() == 0 ? null : String.valueOf(ext.toLowerCase()) + ';';
            }
            if (this.m_AllowFileExt != null && this.m_AllowFileExt.length() > 0) {
                if (ext == null || -1 == this.m_AllowFileExt.indexOf(ext)) {
                    throw new IOException("Without allow file type :" + ext + " not in " + this.m_AllowFileExt);
                }
            } else if (this.m_DenialFileExt != null && this.m_DenialFileExt.length() > 0 && ext != null && -1 != this.m_DenialFileExt.indexOf(ext)) {
                throw new IOException("Denial file type :" + ext + " in " + this.m_DenialFileExt);
            }
        }
        Object sendTo = this.m_DirectSend.get((Object)form.getName());
        form.setValue(in, sendTo);
        return form;
    }

    protected static class WebFormMix
    extends WebForm {
        protected int m_ContentLength = -1;
        protected byte[] m_Content;

        @Override
        public byte[] getBytes() throws IOException {
            if (this.m_ContentLength == 0) {
                return Bytes._nilBytes;
            }
            if (MARK_UNREACHABLE == this.m_Content) {
                throw new IOException("Unreachable");
            }
            return this.m_Content;
        }

        @Override
        public InputStream getStream() throws IOException {
            if (this.m_ContentLength == 0) {
                return BytesInputStream.empty();
            }
            if (this.m_Content != null) {
                if (MARK_UNREACHABLE == this.m_Content) {
                    throw new IOException("Unreachable");
                }
                return new ByteArrayInputStream(this.m_Content, 0, this.m_ContentLength);
            }
            throw new IOException("Unkown");
        }

        @Override
        public int getContentLength() {
            return this.m_ContentLength;
        }

        public WebFormMix(List<WebForm.Header> headers) {
            this.analyze(headers);
        }

        public void setContentLength(int length) {
            this.m_ContentLength = length;
        }

        public void setValue(InputStream content, Object sendTo) throws IOException {
            if (sendTo instanceof File) {
                File localFile = (File)sendTo;
                File dir = localFile.getParentFile();
                if (dir != null) {
                    dir.mkdirs();
                }
                Throwable throwable = null;
                Object var6_9 = null;
                try (FileOutputStream out = new FileOutputStream(localFile);){
                    this.m_ContentLength = content instanceof WebUpload.PartInputStream ? (int)(Integer.MAX_VALUE & ((WebUpload.PartInputStream)content).transfer(out)) : BytesOutputStream.transfer((InputStream)content, (OutputStream)out, (int)0);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.m_Content = MARK_UNREACHABLE;
                return;
            }
            if (sendTo instanceof OutputStream) {
                OutputStream out = (OutputStream)sendTo;
                this.m_ContentLength = content instanceof WebUpload.PartInputStream ? (int)(Integer.MAX_VALUE & ((WebUpload.PartInputStream)content).transfer(out)) : BytesOutputStream.transfer((InputStream)content, (OutputStream)out, (int)0);
                this.m_Content = MARK_UNREACHABLE;
                return;
            }
            BytesOutputStream bs = new BytesOutputStream(content);
            bs.close();
            this.m_Content = bs.detach();
            this.m_ContentLength = this.m_Content.length;
        }
    }
}

