/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.util;

import cn.weforward.common.util.FileUtil;
import cn.weforward.common.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VersionUtil {
    public static final Logger _Logger = LoggerFactory.getLogger(VersionUtil.class);

    public static String getVersion(List<String> clazzs) {
        StringBuilder sb = new StringBuilder(clazzs.size() * 24);
        for (String s : clazzs) {
            try {
                Class<?> classOf = Class.forName(s);
                s = VersionUtil.getVersionByJar(classOf, "Implementation-Version");
                if (s.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append(';');
                }
                sb.append(s);
            }
            catch (ClassNotFoundException e) {
                _Logger.warn(e.toString(), (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static String getMainVersionByJar(Class<?> clazz) {
        return VersionUtil.getVersionByJar(clazz, "Main-Version");
    }

    public static String getMainVersionByPom() {
        File file = new File(FileUtil.getAbsolutePath((String)"pom.xml", null));
        if (file.exists()) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                NodeList list = doc.getElementsByTagName("properties");
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    NodeList childlist = node.getChildNodes();
                    int j = 0;
                    while (j < childlist.getLength()) {
                        Node child = childlist.item(j);
                        if (StringUtil.eq((String)child.getNodeName(), (String)"main.version")) {
                            return child.getTextContent();
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                _Logger.warn("\u89e3\u6790xml\u5f02\u5e38", (Throwable)e);
            }
        }
        return "";
    }

    public static String getImplementationVersionByJar(Class<?> clazz) {
        return VersionUtil.getVersionByJar(clazz, "Implementation-Version");
    }

    public static String getImplementationVersionByPom() {
        File file = new File(FileUtil.getAbsolutePath((String)"pom.xml", null));
        if (file.exists()) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                NodeList list = doc.getElementsByTagName("version");
                if (list.getLength() > 0) {
                    Node node = list.item(0);
                    return node.getTextContent();
                }
            }
            catch (Exception e) {
                _Logger.warn("\u89e3\u6790xml\u5f02\u5e38", (Throwable)e);
            }
        }
        return "";
    }

    private static String getVersionByJar(Class<?> clazz, String key) {
        String jar;
        block3: {
            jar = "";
            try {
                jar = VersionUtil.findJarName(clazz);
                if (!StringUtil.isEmpty((String)jar)) break block3;
                return "";
            }
            catch (IOException e) {
                _Logger.warn("getJarVersion failed. " + clazz + " for " + jar, (Throwable)e);
                return "";
            }
        }
        JarFile jf = new JarFile(jar);
        Manifest mf = jf.getManifest();
        Attributes attributes = mf.getMainAttributes();
        jf.close();
        return StringUtil.toString((Object)attributes.getValue(key));
    }

    public static String findJarName(Class<?> clazz) {
        String name;
        int idx;
        if (clazz == null) {
            return "";
        }
        String jar = null;
        try {
            URL url;
            CodeSource cs = clazz.getProtectionDomain().getCodeSource();
            if (cs != null && (url = cs.getLocation()) != null) {
                jar = VersionUtil.decodeUrl(url.getFile());
            }
        }
        catch (SecurityException cs) {
            // empty catch block
        }
        if (jar == null) {
            return "";
        }
        if (jar.startsWith("file:/")) {
            jar = jar.substring(5);
        }
        if (-1 != (idx = jar.indexOf(33))) {
            jar = jar.substring(0, idx);
        }
        if (-1 == (idx = jar.lastIndexOf(47))) {
            idx = jar.lastIndexOf(92);
        }
        if (-1 == (idx = (name = -1 != idx ? jar.substring(idx + 1) : jar).lastIndexOf(46))) {
            _Logger.warn(clazz + " Not in JAR file: " + jar);
            return "";
        }
        return jar;
    }

    private static String decodeUrl(String url) {
        if (StringUtil.isEmpty((String)url)) {
            return url;
        }
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

