/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.support;

import cn.weforward.protocol.client.util.MappedUtil;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import java.util.Collections;

public class Global {
    public static final String PARAMS_NAME = "_global";
    public static final ThreadGlobal TLS = new ThreadGlobal();
    protected DtBase m_Base;
    protected FriendlyObject m_Object;

    public Global(DtBase base) {
        this.m_Base = base;
    }

    public DtBase getBase() {
        return this.m_Base;
    }

    public DtObject getObject() {
        if (this.m_Base instanceof DtObject) {
            return (DtObject)this.m_Base;
        }
        return null;
    }

    public FriendlyObject getFriendlyObject() {
        if (this.m_Object == null) {
            this.m_Object = FriendlyObject.valueOf((DtObject)this.getObject());
        }
        return this.m_Object;
    }

    public Iterable<String> keys() {
        DtObject v = this.getObject();
        if (v == null) {
            return Collections.emptyList();
        }
        return Collections.list(v.getAttributeNames());
    }

    public String getValue(String name) {
        return this.getFriendlyObject().getString(name);
    }

    public <E> E get(Class<E> clazz) {
        return (E)MappedUtil.fromBase(clazz, (DtBase)this.getObject());
    }

    public static final class ThreadGlobal {
        private ThreadLocal<Global> m_Session;

        public Global put(Global global) {
            Global old;
            if (global == null) {
                if (this.m_Session == null) {
                    return null;
                }
                Global old2 = this.m_Session.get();
                this.m_Session.set(global);
                return old2;
            }
            if (this.m_Session == null) {
                this.m_Session = new ThreadLocal();
                old = null;
            } else {
                old = this.m_Session.get();
            }
            this.m_Session.set(global);
            return old;
        }

        public Global get() {
            return this.m_Session == null ? null : this.m_Session.get();
        }

        public String getValue(String key) {
            Global g = this.get();
            return g == null ? null : g.getValue(key);
        }
    }
}

