/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.ext;

import cn.weforward.common.Destroyable;
import cn.weforward.common.Dictionary;
import cn.weforward.common.restful.RestfulRequest;
import cn.weforward.common.restful.RestfulResponse;
import cn.weforward.common.restful.RestfulService;
import cn.weforward.common.sys.Memory;
import cn.weforward.common.sys.Shutdown;
import cn.weforward.common.sys.VmStat;
import cn.weforward.common.util.ClassUtil;
import cn.weforward.common.util.ListUtil;
import cn.weforward.common.util.NumberUtil;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import cn.weforward.common.util.ThreadPool;
import cn.weforward.framework.ApiException;
import cn.weforward.framework.ApiMethod;
import cn.weforward.framework.Authorizer;
import cn.weforward.framework.ResourceDownloader;
import cn.weforward.framework.ResourceHandler;
import cn.weforward.framework.ResourceUploader;
import cn.weforward.framework.doc.DocObjectProvider;
import cn.weforward.framework.exception.ForwardException;
import cn.weforward.framework.ext.DebugMethod;
import cn.weforward.framework.ext.DocumentMethod;
import cn.weforward.framework.ext.LocalDocUriHandler;
import cn.weforward.framework.ext.MethodsRegister;
import cn.weforward.framework.ext.RpcEndPoint;
import cn.weforward.framework.ext.StreamEndPoint;
import cn.weforward.framework.ext.UriHandler;
import cn.weforward.framework.ext.UriHandlers;
import cn.weforward.framework.ext.VersionMethod;
import cn.weforward.framework.util.HostUtil;
import cn.weforward.framework.util.VersionUtil;
import cn.weforward.metrics.RemoteMeterRegistry;
import cn.weforward.protocol.Access;
import cn.weforward.protocol.AccessLoader;
import cn.weforward.protocol.AsyncResponse;
import cn.weforward.protocol.Header;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.Service;
import cn.weforward.protocol.aio.ServerHandlerFactory;
import cn.weforward.protocol.aio.http.HttpHeaderHelper;
import cn.weforward.protocol.aio.http.HttpHeaderOutput;
import cn.weforward.protocol.aio.http.RestfulServer;
import cn.weforward.protocol.aio.netty.NettyHttpServer;
import cn.weforward.protocol.aio.netty.NettyWebSocketFactory;
import cn.weforward.protocol.client.AbstractServiceInvoker;
import cn.weforward.protocol.client.DefaultServiceInvoker;
import cn.weforward.protocol.client.ServiceInvoker;
import cn.weforward.protocol.client.ServiceInvokerFactory;
import cn.weforward.protocol.client.netty.NettyWebSocketInvoker;
import cn.weforward.protocol.client.util.MappedUtil;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.doc.DocObject;
import cn.weforward.protocol.doc.DocSpecialWord;
import cn.weforward.protocol.exception.AuthException;
import cn.weforward.protocol.exception.SerialException;
import cn.weforward.protocol.exception.WeforwardException;
import cn.weforward.protocol.ext.Producer;
import cn.weforward.protocol.ext.ServiceRuntime;
import cn.weforward.protocol.gateway.ServiceRegister;
import cn.weforward.protocol.gateway.http.HttpServiceRegister;
import cn.weforward.protocol.ops.trace.ServiceTraceToken;
import cn.weforward.protocol.support.SimpleAccess;
import cn.weforward.protocol.support.SimpleProducer;
import cn.weforward.protocol.support.SimpleResponse;
import cn.weforward.protocol.support.datatype.FriendlyObject;
import cn.weforward.protocol.topic.Topic;
import cn.weforward.protocol.topic.TopicHub;
import cn.weforward.protocol.topic.TopicListener;
import cn.weforward.trace.RemoteTraceRegistry;
import cn.weforward.trace.TraceRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class WeforwardService
implements TopicHub,
AccessLoader,
RestfulService,
Destroyable,
ApplicationContextAware,
BeanPostProcessor {
    protected static final Logger _Logger = LoggerFactory.getLogger(WeforwardService.class);
    protected static final Timer _Timer = new Timer("WeforwardService-Timer", true);
    public static int EXECUTOR_QUEUE_TIMEOUT = NumberUtil.toInt((String)System.getProperty("WeforwardService.EXECUTOR_QUEUE_TIMEOUT"), (int)1000);
    public static int EXECUTOR_QUEUE_MULTIPLE = NumberUtil.toInt((String)System.getProperty("WeforwardService.EXECUTOR_QUEUE_MULTIPLE"), (int)5);
    static final int DEFAULT_HEARTBEAT_PERIOD = 59;
    protected AccessLoader m_MyAccessLoader;
    protected AccessLoader m_AccessLoader;
    protected String m_AccessId;
    protected String m_AccessKey;
    protected String m_Host;
    protected String m_No;
    protected String m_Version;
    protected String m_CompatibleVersion;
    protected String m_ImplementationVersion;
    protected String m_RunningId = System.getenv("RUNNING_ID");
    protected String m_GatewayUrl;
    protected int m_HeartbeatPeriod;
    protected List<ServiceRegister> m_ServiceRegisters;
    protected MethodsRegister m_MethodsRegister;
    protected RpcEndPoint m_RpcEndpoint;
    protected StreamEndPoint m_StreamEndpoint;
    protected String m_Description = "";
    protected String m_ModifyPath = "";
    protected String m_Note = "";
    protected List<Class<?>> m_ObjectClasses;
    protected List<String> m_ObjectPackages;
    protected List<Class<?>> m_StatusCodeClasses = new ArrayList();
    protected List<DocObject> m_Objects = new ArrayList<DocObject>();
    protected List<DocObjectProvider> m_ObjectProviders = new ArrayList<DocObjectProvider>();
    protected List<DocSpecialWord> m_DocSpecialWords = new ArrayList<DocSpecialWord>();
    protected Producer m_Producer;
    protected Executor m_Executor;
    protected TimerTask m_HbTask;
    protected int m_ElapseTime;
    protected int m_RequestMaxSize;
    protected boolean m_ForwardEnable;
    protected long m_StartTime;
    protected NettyHttpServer m_HttpServer;
    protected RestfulServer m_RestfulServer;
    protected Map<String, List<TopicListenerWrap<?>>> m_Listeners = new HashMap();
    protected List<ApplicationContextAware> m_ChildAwares = new ArrayList<ApplicationContextAware>();
    protected UriHandlers m_UriHandlers;
    protected boolean m_Local = false;
    protected ServiceInfo m_ServiceInfo;

    public WeforwardService(String name, String host, int port) throws Exception {
        this(name, host, port, null);
    }

    public WeforwardService(String name, String host, int port, String path) throws Exception {
        this(name, host, port, path, 50);
    }

    public WeforwardService(String name, String host, int port, String path, int threads) throws Exception {
        this.m_HttpServer = new NettyHttpServer(port);
        this.m_HttpServer.setName(name);
        this.m_HttpServer.setGzipEnabled(true);
        this.m_StartTime = System.currentTimeMillis();
        this.m_Host = WeforwardService.genHost(host);
        this.m_Producer = new SimpleProducer((AccessLoader)this);
        this.m_RpcEndpoint = new RpcEndPoint();
        this.m_RpcEndpoint.setBasePath(path);
        this.m_StreamEndpoint = new StreamEndPoint();
        this.m_RestfulServer = new RestfulServer((RestfulService)this);
        this.m_HttpServer.setHandlerFactory((ServerHandlerFactory)this.m_RestfulServer);
        this.m_UriHandlers = new UriHandlers();
        if (threads > 0) {
            ThreadPool tp = new ThreadPool(threads, name);
            if (EXECUTOR_QUEUE_MULTIPLE > 1) {
                tp.setQueueLengthMax(threads * EXECUTOR_QUEUE_MULTIPLE);
                tp.setQueueTimeout(EXECUTOR_QUEUE_TIMEOUT);
            }
            this.setExecutor((Executor)tp);
        }
        this.m_ServiceInfo = new ServiceInfo();
        this.setElapseTime(10000);
        this.onInit();
        this.m_HttpServer.start();
        this.setHeartbeatPeriod(59);
        Shutdown.register((Destroyable)this);
    }

    protected void onInit() {
    }

    public void setExecutor(Executor executor) {
        this.m_Executor = executor;
        this.m_RestfulServer.setExecutor(executor);
    }

    public void setMeterRegistryUrl(String url) throws MalformedURLException {
        if (StringUtil.isEmpty((String)url)) {
            return;
        }
        RemoteMeterRegistry registry = new RemoteMeterRegistry(url);
        registry.setServiceName(this.getName());
        registry.setServiceNo(this.getNo());
        this.setMeterRegistry((MeterRegistry)registry);
    }

    public void setMeterRegistry(MeterRegistry registry) {
        MeterRegistry old = this.m_RpcEndpoint.getMeterRegistry();
        if (old != null) {
            old.close();
        }
        this.m_RpcEndpoint.setMeterRegistry(registry);
        this.m_StreamEndpoint.setMeterRegistry(registry);
    }

    public void setTraceRegisterUrl(String url) throws MalformedURLException {
        if (StringUtil.isEmpty((String)url)) {
            return;
        }
        RemoteTraceRegistry registry = new RemoteTraceRegistry(url);
        registry.setServiceName(this.getName());
        registry.setServiceNo(this.getNo());
        this.setTraceRegister((TraceRegistry)registry);
    }

    public void setTraceRegister(TraceRegistry registry) {
        TraceRegistry old = this.m_RpcEndpoint.getTraceRegistry();
        if (old != null) {
            old.close();
        }
        this.m_RpcEndpoint.setTraceRegister(registry);
    }

    public void setQuickHandle(boolean enabled) {
        this.m_RestfulServer.setQuickHandle(enabled);
    }

    public void setDebugEnabled(boolean enabled) {
        if (this.m_HttpServer != null) {
            this.m_HttpServer.setDebugEnabled(enabled);
        }
    }

    public void setInnerMethodEnabled(boolean enabled) {
        if (enabled) {
            this.aware(new VersionMethod(this, Arrays.asList(this.getClass().getName())));
            this.aware(new DebugMethod(this));
            this.aware(new DocumentMethod(this));
        }
    }

    public void setMethodsAwareEnabled(boolean enabled) {
        this.m_MethodsRegister = enabled ? new MethodsRegister(this) : null;
    }

    public void setMaxHttpSize(int maxHttpSize) {
        if (this.m_HttpServer != null) {
            this.m_HttpServer.setMaxHttpSize(maxHttpSize);
        }
    }

    public void setElapseTime(int mills) {
        this.m_ElapseTime = mills;
    }

    public void setShowDocEnable(boolean enable) {
        if (enable) {
            if (this.m_UriHandlers.find("/__wf_doc/**") == null) {
                this.m_UriHandlers.add(new LocalDocUriHandler(() -> this.m_RpcEndpoint.getServiceDocument()));
            }
        } else {
            this.m_UriHandlers.remove("/__wf_doc/**");
        }
    }

    public void setForwardEnable(boolean enable) {
        this.m_ForwardEnable = enable;
    }

    public void setRequestMaxSize(int max) {
        this.m_RequestMaxSize = max;
    }

    public void setGzipEnabled(boolean enabled) {
        if (this.m_HttpServer != null) {
            this.m_HttpServer.setGzipEnabled(enabled);
        }
    }

    public void setGzipMinSize(int minSize) {
        if (this.m_HttpServer != null) {
            this.m_HttpServer.setGzipMinSize(minSize);
        }
    }

    public void setIdle(int secs) {
        if (this.m_HttpServer != null) {
            this.m_HttpServer.setIdle(secs);
        }
    }

    public void setHeartbeatPeriod(int seconds) {
        this.m_HeartbeatPeriod = seconds;
        if (this.m_HbTask != null) {
            this.m_HbTask.cancel();
        }
        if (seconds > 0) {
            final Runnable runner = new Runnable(){
                volatile boolean pending = false;

                @Override
                public void run() {
                    if (this.pending) {
                        return;
                    }
                    this.pending = true;
                    try {
                        WeforwardService.this.register();
                    }
                    finally {
                        this.pending = false;
                    }
                }
            };
            this.m_HbTask = new TimerTask(){

                @Override
                public void run() {
                    if (WeforwardService.this.m_HeartbeatPeriod < 1) {
                        this.cancel();
                        return;
                    }
                    Executor executor = WeforwardService.this.m_Executor;
                    if (executor != null) {
                        try {
                            executor.execute(runner);
                            return;
                        }
                        catch (OutOfMemoryError e) {
                            return;
                        }
                        catch (RuntimeException e) {
                            _Logger.warn("\u5ffd\u7565\u6267\u884c\u51fa\u9519", (Throwable)e);
                        }
                    }
                    runner.run();
                }
            };
            int period = seconds * 500;
            int delay = period > 10000 ? 10000 : period;
            _Timer.schedule(this.m_HbTask, delay, (long)period);
        }
    }

    public String getName() {
        if (this.m_HttpServer != null) {
            return this.m_HttpServer.getName();
        }
        return null;
    }

    public int getPort() {
        if (this.m_HttpServer != null) {
            return this.m_HttpServer.getPort();
        }
        return 0;
    }

    public String getHost() {
        return this.m_Host;
    }

    public void setNo(String no) {
        this.m_No = no;
        if (StringUtil.eq((String)this.m_No, (String)"x00ff")) {
            this.setShowDocEnable(true);
        }
    }

    public String getNo() {
        return this.m_No;
    }

    public void setVersion(String v) {
        this.m_Version = v;
    }

    public String getVersion() {
        if (this.m_Version != null) {
            return this.m_Version;
        }
        String v = VersionUtil.getMainVersionByJar(this.getClass());
        if (StringUtil.isEmpty((String)v)) {
            v = VersionUtil.getMainVersionByPom();
        }
        if (StringUtil.isEmpty((String)v)) {
            v = "1.0";
        }
        this.m_Version = v;
        return this.m_Version;
    }

    public void setCompatibleVersion(String version) {
        this.m_CompatibleVersion = version;
    }

    public String getCompatibleVersion() {
        return this.m_CompatibleVersion;
    }

    public String getImplementationVersion() {
        if (this.m_ImplementationVersion != null) {
            return this.m_ImplementationVersion;
        }
        String v = VersionUtil.getImplementationVersionByJar(this.getClass());
        if (StringUtil.isEmpty((String)v)) {
            v = VersionUtil.getImplementationVersionByPom();
        }
        if (StringUtil.isEmpty((String)v)) {
            v = "";
        }
        this.m_ImplementationVersion = v;
        return this.m_ImplementationVersion;
    }

    public long getStartTime() {
        return this.m_StartTime;
    }

    public long getUpTime() {
        return System.currentTimeMillis() - this.m_StartTime;
    }

    public void setDescription(String desc) {
        this.m_Description = desc;
    }

    public String getDescription() {
        return this.m_Description;
    }

    public void setNote(String note) {
        this.m_Note = note;
    }

    public String getNote() {
        return this.m_Note;
    }

    public void setModifyPath(String path) {
        this.m_ModifyPath = path;
    }

    public String getModifyPath() {
        return this.m_ModifyPath;
    }

    public void setRunningId(String id) {
        this.m_RunningId = id;
    }

    public String getRunningId() {
        return this.m_RunningId;
    }

    public void setObjectNameList(List<String> classes) {
        ArrayList list = new ArrayList(classes.size());
        for (String className : classes) {
            try {
                list.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                _Logger.warn("\u5ffd\u7565\u52a0\u8f7d[" + className + "]\u7c7b\u5f02\u5e38", (Throwable)e);
            }
        }
        this.m_ObjectClasses = list;
    }

    public List<Class<?>> getObjectClasses() {
        if (this.m_ObjectClasses == null) {
            return Collections.emptyList();
        }
        return this.m_ObjectClasses;
    }

    public void setObjectPackages(List<String> list) {
        this.m_ObjectPackages = list;
    }

    public List<String> getObjectPackages() {
        if (this.m_ObjectPackages == null) {
            return Collections.emptyList();
        }
        return this.m_ObjectPackages;
    }

    public void setStatusCodeClassName(String className) {
        try {
            this.setStatusCodeClass(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            _Logger.warn("\u5ffd\u7565\u52a0\u8f7d[" + className + "]\u7c7b\u5f02\u5e38", (Throwable)e);
        }
    }

    public void setStatusCodeClass(Class<?> clazz) {
        this.m_StatusCodeClasses = Collections.singletonList(clazz);
    }

    public void addStatusCodeClass(Class<?> clazz) {
        this.m_StatusCodeClasses.add(clazz);
    }

    public List<Class<?>> getStatusCodeClasses() {
        return this.m_StatusCodeClasses;
    }

    public List<DocObject> getObjects() {
        return this.m_Objects;
    }

    public List<DocObjectProvider> getObjectProviders() {
        return this.m_ObjectProviders;
    }

    public void addDocSpecialWord(DocSpecialWord word) {
        this.m_DocSpecialWords.add(word);
    }

    public void setDocSpecialWords(List<DocSpecialWord> words) {
        this.m_DocSpecialWords = words;
    }

    public List<DocSpecialWord> getDocSpecialWords() {
        return this.m_DocSpecialWords;
    }

    public void setNoneAuthorizer(Authorizer authorizer) {
        this.m_RpcEndpoint.register("", authorizer);
    }

    public void setUserAuthorizer(Authorizer authorizer) {
        this.m_RpcEndpoint.register("US", authorizer);
    }

    public void setServiceAuthorizer(Authorizer authorizer) {
        this.m_RpcEndpoint.register("H", authorizer);
    }

    public void setServicesUrl(String url) {
        this.setGatewayUrl(url);
    }

    public void setGatewayUrl(String url) {
        this.m_GatewayUrl = url;
        this.register();
    }

    public void setTopicListeners(List<TopicListener<?>> ls) {
        if (ls == null) {
            return;
        }
        for (TopicListener<?> l : ls) {
            this.subscribe(l);
        }
    }

    public void setAccessId(String aid) {
        this.m_AccessId = aid;
        this.initAccessLoader();
    }

    public void setAccessKey(String akey) {
        this.m_AccessKey = akey;
        this.initAccessLoader();
    }

    public void setAccessLoader(AccessLoader loader) {
        this.m_AccessLoader = loader;
    }

    public Access getValidAccess(String accessId) {
        Access access = null;
        if (this.m_MyAccessLoader != null) {
            access = this.m_MyAccessLoader.getValidAccess(accessId);
        }
        if (access == null && this.m_AccessLoader != null) {
            access = this.m_AccessLoader.getValidAccess(accessId);
        }
        return access;
    }

    public void registerMethod(ApiMethod method) {
        this.m_RpcEndpoint.register(method);
    }

    public void registerObject(DocObject o) {
        this.m_Objects.add(o);
    }

    public void registerObjectProvider(DocObjectProvider p) {
        this.m_ObjectProviders.add(p);
    }

    public void registerResources(ResourceHandler handler) {
        this.m_StreamEndpoint.register(handler);
    }

    public void registerResources(ResourceDownloader downloader) {
        this.m_StreamEndpoint.register(downloader);
    }

    public void registerResources(ResourceUploader uploader) {
        this.m_StreamEndpoint.register(uploader);
    }

    public static String genHost(String host) {
        if (host == null) {
            return null;
        }
        if (StringUtil.eq((String)host, (String)"*")) {
            host = HostUtil.getServiceIp(null);
            _Logger.info("\u81ea\u52a8\u83b7\u53d6IP:" + host);
        } else if (host.endsWith("*")) {
            host = HostUtil.getServiceIp(host.substring(0, host.length() - 1));
            _Logger.info("\u81ea\u52a8\u83b7\u53d6IP:" + host);
        }
        return host;
    }

    private String getDocumentMethod() {
        return this.m_RpcEndpoint.getDocumentMethod();
    }

    private String getDebugMethod() {
        return this.m_RpcEndpoint.getDebugMethod();
    }

    void aware(ApiMethod methods) {
        if (methods instanceof ApplicationContextAware) {
            this.m_ChildAwares.add((ApplicationContextAware)methods);
        }
    }

    Map<String, ApiMethod> getMethods() {
        return this.m_RpcEndpoint.getMethods();
    }

    private void initAccessLoader() {
        if (!StringUtil.isEmpty((String)this.m_AccessId) && !StringUtil.isEmpty((String)this.m_AccessKey)) {
            this.m_MyAccessLoader = new AccessLoader.Single(this.m_AccessId, this.m_AccessKey);
        }
    }

    protected List<ServiceRegister> openServiceRegister() {
        List<ServiceRegister> registers = this.m_ServiceRegisters;
        if (registers != null || this.isLocal() || StringUtil.isEmpty((String)this.m_GatewayUrl)) {
            return registers;
        }
        String[] urls = this.m_GatewayUrl.split(";");
        if (urls.length == 1) {
            String myHost;
            if (StringUtil.isEmpty((String)urls[0])) {
                this.m_GatewayUrl = "";
                return registers;
            }
            URI uri = URI.create(urls[0]);
            if (uri.getPort() == this.getPort() && (StringUtil.eq((String)"localhost", (String)(myHost = uri.getHost())) || StringUtil.eq((String)"127.0.0.1", (String)myHost) || StringUtil.eq((String)myHost, (String)this.getHost()))) {
                _Logger.warn("\u5f53\u524d\u4e3a\u672c\u673a\u8c03\u8bd5\u6a21\u5f0f " + urls[0]);
                this.m_Local = true;
                return registers;
            }
        }
        if (StringUtil.isEmpty((String)this.m_AccessId) || StringUtil.isEmpty((String)this.m_AccessKey)) {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("\u9700\u8981\u914d\u7f6eAccessId\u53caAccessKey");
            }
            return registers;
        }
        ArrayList<AbstractServiceInvoker> httpInvokers = new ArrayList<AbstractServiceInvoker>(urls.length);
        registers = new ArrayList<ServiceRegister>(urls.length);
        String[] stringArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            String url = stringArray[n2];
            if (!StringUtil.isEmpty((String)url)) {
                AbstractServiceInvoker invoker;
                if (NettyWebSocketFactory.isWebSocket((String)this.m_GatewayUrl)) {
                    NettyWebSocketInvoker wsInvoker = new NettyWebSocketInvoker((ServerHandlerFactory)this.m_RestfulServer, url, this.m_Producer);
                    wsInvoker.setAccessId(this.m_AccessId);
                    wsInvoker.setServiceName(HttpServiceRegister.getServiceName());
                    invoker = wsInvoker;
                    HttpServiceRegister register = new HttpServiceRegister((ServiceInvoker)wsInvoker);
                    register.setListener((HttpServiceRegister.Listener)new RegisterListener(url));
                    registers.add((ServiceRegister)register);
                    if (59 == this.m_HeartbeatPeriod) {
                        this.setHeartbeatPeriod(25);
                    }
                } else {
                    AbstractServiceInvoker serviceInvoker = ServiceInvokerFactory.createInvoker((String)url, (String)HttpServiceRegister.getServiceName(), (Producer)this.m_Producer);
                    serviceInvoker.setAccessId(this.m_AccessId);
                    invoker = serviceInvoker;
                    httpInvokers.add(serviceInvoker);
                }
                int timeout = this.m_HeartbeatPeriod > 10 ? this.m_HeartbeatPeriod / 2 * 1000 : 5000;
                invoker.setReadTimeout(timeout);
            }
            ++n2;
        }
        if (httpInvokers.size() > 0) {
            Object invoker = 1 == httpInvokers.size() ? (ServiceInvoker)httpInvokers.get(0) : new DefaultServiceInvoker(httpInvokers);
            HttpServiceRegister register = new HttpServiceRegister(invoker);
            register.setListener((HttpServiceRegister.Listener)new RegisterListener(invoker.toString()));
            registers.add((ServiceRegister)register);
        }
        this.m_ServiceRegisters = registers;
        return registers;
    }

    public boolean isLocal() {
        return this.m_Local;
    }

    public Service getServiceInfo() {
        return this.m_ServiceInfo;
    }

    protected void register() {
        List<ServiceRegister> registers = this.openServiceRegister();
        if (registers == null || registers.size() < 1) {
            return;
        }
        ServiceRuntime runtime = new ServiceRuntime();
        VmStat.refresh();
        Memory mem = VmStat.getMemory();
        runtime.memoryMax = mem.getMax();
        runtime.memoryAlloc = mem.getAlloc();
        runtime.memoryUsable = mem.getUsable();
        runtime.gcFullCount = mem.getGcCount();
        runtime.gcFullTime = mem.getGcTime();
        runtime.threadCount = VmStat.getThreadCount();
        runtime.cpuUsageRate = VmStat.getProcessCpuLoad();
        runtime.timestamp = System.currentTimeMillis();
        runtime.startTime = this.getStartTime();
        runtime.upTime = this.getUpTime();
        for (ServiceRegister register : registers) {
            try {
                register.registerService(this.getServiceInfo(), runtime);
            }
            catch (Throwable e) {
                _Logger.warn(this + " \u6ce8\u518c\u5f02\u5e38", e);
            }
        }
    }

    protected void unregister() {
        List<ServiceRegister> registers;
        TimerTask task = this.m_HbTask;
        if (task != null) {
            task.cancel();
        }
        if ((registers = this.openServiceRegister()) == null || registers.size() < 1) {
            return;
        }
        for (ServiceRegister register : registers) {
            try {
                register.unregisterService(this.getServiceInfo());
            }
            catch (Throwable e) {
                _Logger.warn(this + " \u6ce8\u9500\u5f02\u5e38", e);
            }
        }
    }

    public void destroy() {
        this.unregister();
        this.m_HttpServer.close();
    }

    public void precheck(RestfulRequest request, RestfulResponse response) throws IOException {
        String verb = request.getVerb();
        if ("OPTIONS".equals(verb)) {
            if (!StringUtil.isEmpty((String)((String)request.getHeaders().get((Object)"Access-Control-Request-Method")))) {
                response.setHeader("Access-Control-Allow-Origin", "*");
                response.setHeader("Access-Control-Allow-Methods", "POST");
                response.setHeader("Access-Control-Allow-Headers", "Authorization,Content-Type,Content-Encoding,WF-Tag,WF-Noise,WF-content-sign,HY-Tag,HY-Noise,User-Agent,X-Requested-With,Accept,Accept-Encoding");
                response.setHeader("Access-Control-Max-Age", "3600");
                response.setStatus(200);
            } else {
                response.setStatus(400);
            }
            response.openOutput().close();
            return;
        }
        if (!"POST".equals(verb) && !"GET".equals(verb)) {
            response.setStatus(405);
            response.openOutput().close();
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(RestfulRequest request, RestfulResponse response) throws IOException {
        block61: {
            path = request.getUri();
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Headers", "Authorization,Content-Type,Content-Encoding,WF-Tag,WF-Noise,WF-content-sign,HY-Tag,HY-Noise,User-Agent,X-Requested-With,Accept,Accept-Encoding");
            reqHeader = new Header(this.getName());
            HttpHeaderHelper.fromHttpHeaders((Dictionary)request.getHeaders(), (Header)reqHeader);
            channel = reqHeader.getChannel();
            if (StringUtil.eq((String)channel, (String)"stream")) {
                this.m_StreamEndpoint.handle(request, response);
                return;
            }
            if (reqHeader.getAuthType() == null) {
                v0 = uriHandler = this.m_UriHandlers == null ? null : this.m_UriHandlers.find(path);
                if (uriHandler != null) {
                    uriHandler.handle(request, response);
                    return;
                }
                response.setStatus(400);
                response.openOutput().close();
                return;
            }
            try {
                var7_8 = null;
                var8_12 = null;
                try {
                    content = request.getContent();
                    try {
                        wfrequest = this.m_Producer.fetchRequest(new Producer.Input(){

                            public Header readHeader() throws IOException {
                                return reqHeader;
                            }

                            public InputStream getInputStream() throws IOException {
                                return content;
                            }
                        });
                        if (this.m_Local) {
                            access = new SimpleAccess();
                            access.setAccessId(reqHeader.getAccessId());
                            wfrequest.setAccess((Access)access);
                        }
                    }
                    finally {
                        if (content != null) {
                            content.close();
                        }
                    }
                }
                catch (Throwable var8_13) {
                    if (var7_8 == null) {
                        var7_8 = var8_13;
                        throw var7_8;
                    }
                    if (var7_8 == var8_13) throw var7_8;
                    var7_8.addSuppressed(var8_13);
                    throw var7_8;
                }
            }
            catch (AuthException | SerialException | IOException e) {
                WeforwardService._Logger.warn("\u89e3\u6790\u8bf7\u6c42\u5f02\u5e38", e);
                response.setStatus(400);
                response.openOutput().close();
                return;
            }
            start = -9223372036854775808L;
            if (this.m_ElapseTime > 0 || this.getLogger().isDebugEnabled()) {
                start = System.currentTimeMillis();
            }
            response.setStatus(200);
            hyresponse = new WeResponse(response, reqHeader);
            traceToken = "";
            try {
                block64: {
                    block63: {
                        block62: {
                            traceToken = wfrequest.getTraceToken();
                            if (!StringUtil.isEmpty((String)traceToken)) {
                                ServiceTraceToken.TTT.put(traceToken);
                            }
                            if ((timeout = wfrequest.getWaitTimeout()) <= 0 || timeout > 2000000) {
                                timeout = 50;
                            }
                            if (timeout > 1) {
                                timeout = (timeout - 1) * 1000;
                                hyresponse.setResponseTimeout(timeout);
                            }
                            if (!StringUtil.eq((String)channel, (String)"topic")) break block62;
                            invoke = FriendlyObject.valueOf((DtObject)wfrequest.getServiceInvoke());
                            params = invoke.getFriendlyObject("params");
                            topic = params.getString("topic");
                            list = this.m_Listeners.get(topic);
                            if (list == null) break block63;
                            topicwrap = new TopicWrap(params);
                            var19_27 = list.iterator();
                            if (true) ** GOTO lbl88
                        }
                        content = this.m_RpcEndpoint.handle(wfrequest, (Response)hyresponse);
                        if (hyresponse.isAsync()) {
                            if (-9223372036854775808L == start) return;
                            start = System.currentTimeMillis() - start;
                            if (start > (long)this.m_ElapseTime) {
                                if (this.getLogger().isWarnEnabled() == false) return;
                                this.getLogger().warn("[use " + start + "ms] " + WeforwardService.getLogDetail(reqHeader));
                                return;
                            }
                            if (this.getLogger().isDebugEnabled() == false) return;
                            this.getLogger().debug("[use " + start + "ms] " + WeforwardService.getLogDetail(reqHeader));
                            return;
                        }
                        break block64;
                        do {
                            w = var19_27.next();
                            w.onReceive(topicwrap, topicwrap.getContent());
lbl88:
                            // 2 sources

                        } while (var19_27.hasNext());
                    }
                    content = null;
                }
                hyresponse.setServiceResult(RpcEndPoint.toResult(0, null, content));
            }
            catch (ForwardException e) {
                if (WeforwardService._Logger.isTraceEnabled()) {
                    WeforwardService._Logger.trace("forwardTo: " + WeforwardService.getLogDetail(reqHeader), (Object)e.getForwardTo(), (Object)e);
                }
                hyresponse.setForwardTo(e.getForwardTo());
                hyresponse.setResponseCode(5006);
                hyresponse.setResponseMsg(e.getMessage());
                if (-9223372036854775808L == start) break block61;
                start = System.currentTimeMillis() - start;
                if (start > (long)this.m_ElapseTime) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("[use " + start + "ms] " + WeforwardService.getLogDetail(reqHeader));
                    }
                    break block61;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("[use " + start + "ms] " + WeforwardService.getLogDetail(reqHeader));
                }
                break block61;
            }
            catch (ApiException e) {
                if (WeforwardService._Logger.isTraceEnabled()) {
                    WeforwardService._Logger.trace(" request:{}", (Object)request, (Object)e);
                }
                hyresponse.setServiceResult(RpcEndPoint.toResult(e));
                break block61;
                catch (WeforwardException e) {
                    if (9003 == e.getCode()) {
                        response.setStatus(503);
                        this.getLogger().warn(String.valueOf(WeforwardService.getLogDetail(reqHeader)) + "\n" + e.toString());
                    } else if (1001 == e.getCode()) {
                        this.getLogger().warn(String.valueOf(WeforwardService.getLogDetail(reqHeader)) + "\n" + e.toString());
                    } else {
                        this.getLogger().error(WeforwardService.getLogDetail(reqHeader), (Throwable)e);
                    }
                    hyresponse = this.createErrorResponse(response, reqHeader, e);
                    if (-9223372036854775808L == start) break block61;
                    {
                        catch (Throwable var20_30) {
                            throw var20_30;
                        }
                    }
                    start = System.currentTimeMillis() - start;
                    if (start > (long)this.m_ElapseTime) {
                        if (this.getLogger().isWarnEnabled()) {
                            this.getLogger().warn("[use " + start + "ms] " + WeforwardService.getLogDetail(reqHeader));
                        }
                        break block61;
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("[use " + start + "ms] " + WeforwardService.getLogDetail(reqHeader));
                    }
                    break block61;
                    catch (Throwable e) {
                        this.getLogger().error(String.valueOf(reqHeader.getLogDetail()) + " traceToken:" + traceToken, e);
                        hyresponse = this.createErrorResponse(response, reqHeader, e);
                        if (-9223372036854775808L == start) break block61;
                        start = System.currentTimeMillis() - start;
                        if (start > (long)this.m_ElapseTime) {
                            if (this.getLogger().isWarnEnabled()) {
                                this.getLogger().warn("[use " + start + "ms] " + WeforwardService.getLogDetail(reqHeader));
                            }
                            break block61;
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("[use " + start + "ms] " + WeforwardService.getLogDetail(reqHeader));
                        }
                        break block61;
                    }
                }
                finally {
                    if (-9223372036854775808L != start) {
                        start = System.currentTimeMillis() - start;
                        if (start > (long)this.m_ElapseTime) {
                            if (this.getLogger().isWarnEnabled()) {
                                this.getLogger().warn("[use " + start + "ms] " + WeforwardService.getLogDetail(reqHeader));
                            }
                        } else if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("[use " + start + "ms] " + WeforwardService.getLogDetail(reqHeader));
                        }
                    }
                }
            }
            if (-9223372036854775808L != start) {
                start = System.currentTimeMillis() - start;
                if (start > (long)this.m_ElapseTime) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("[use " + start + "ms] " + WeforwardService.getLogDetail(reqHeader));
                    }
                } else if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("[use " + start + "ms] " + WeforwardService.getLogDetail(reqHeader));
                }
            }
        }
        try {
            hyresponse.complete();
            return;
        }
        catch (IOException e) {
            this.getLogger().warn(WeforwardService.getLogDetail(reqHeader), (Throwable)e);
        }
    }

    private static String getLogDetail(Header header) {
        return "{s:" + header.getService() + ",acc:" + header.getAccessId() + ",at:" + header.getAuthType() + ",t:" + ServiceTraceToken.TTT.get() + "}";
    }

    public void timeout(RestfulRequest request, RestfulResponse response) throws IOException {
        response.setStatus(200);
        Header reqHeader = new Header(this.getName());
        HttpHeaderHelper.fromHttpHeaders((Dictionary)request.getHeaders(), (Header)reqHeader);
        WeResponse hyresponse = this.createErrorResponse(response, reqHeader, null);
        hyresponse.setResponseCode(5005);
        hyresponse.complete();
    }

    protected WeResponse createErrorResponse(RestfulResponse rsp, Header header, Throwable error) {
        Header respHeader = new Header(header.getService());
        String contentType = header.getContentType();
        if (StringUtil.isEmpty((String)contentType)) {
            contentType = "json";
        }
        respHeader.setContentType(contentType);
        String charset = header.getCharset();
        if (StringUtil.isEmpty((String)charset)) {
            charset = "utf-8";
        }
        respHeader.setCharset(charset);
        respHeader.setAuthType("WF-None");
        WeResponse resp = new WeResponse(rsp);
        resp.setHeader(respHeader);
        if (error instanceof WeforwardException) {
            resp.setResponseCode(((WeforwardException)error).getCode());
            resp.setResponseMsg(error.getMessage());
        } else if (error != null) {
            resp.setResponseCode(9999);
            resp.setResponseMsg(error.toString());
        } else {
            resp.setResponseCode(9999);
        }
        return resp;
    }

    protected Logger getLogger() {
        return _Logger;
    }

    public synchronized <E> void subscribe(TopicListener<E> l) {
        String name = l.getTopic();
        List<TopicListenerWrap<?>> list = this.m_Listeners.get(name);
        if (list == null) {
            list = new ArrayList();
        }
        for (TopicListenerWrap<?> wrap : list) {
            if (wrap.m_Listener != l) continue;
            return;
        }
        list.add(new TopicListenerWrap<E>(l));
        this.m_Listeners.put(name, list);
    }

    public synchronized <E> void unsubscribe(TopicListener<E> listener) {
        String name = listener.getTopic();
        List<TopicListenerWrap<?>> list = this.m_Listeners.get(name);
        if (list == null) {
            return;
        }
        ArrayList news = new ArrayList();
        for (TopicListenerWrap<?> w : list) {
            if (w.m_Listener == listener) continue;
            news.add(w);
        }
        this.m_Listeners.put(name, news);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        List<ApplicationContextAware> awares = this.m_ChildAwares;
        for (ApplicationContextAware aware : awares) {
            aware.setApplicationContext(applicationContext);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        MethodsRegister r = this.m_MethodsRegister;
        if (r != null) {
            r.register(bean);
        }
        return bean;
    }

    public void setUriHandlers(List<UriHandler> handlers) {
        if (ListUtil.isEmpty(handlers)) {
            return;
        }
        this.m_UriHandlers.addAll(handlers);
    }

    public String toString() {
        StringBuilder builder = StringBuilderPool._8k.poll();
        try {
            builder.append('{');
            if (this.m_HttpServer != null) {
                builder.append("http:");
                this.m_HttpServer.toString(builder);
            } else {
                builder.append(this.getHost()).append(':').append(this.getPort());
            }
            builder.append(",executor:").append(this.m_Executor);
            builder.append('}');
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderPool._8k.offer(builder);
        }
    }

    static class RegisterListener
    implements HttpServiceRegister.Listener {
        int failCounter;
        int succCounter;
        String note;

        RegisterListener(String note) {
            this.note = StringUtil.isEmpty((String)note) ? "" : " " + note;
        }

        public void success(ServiceRegister register, Service service) {
            ++this.succCounter;
            this.failCounter = 0;
            if (1 == this.succCounter) {
                _Logger.info("\u670d\u52a1\u6ce8\u518c\u6210\u529f " + service + this.note);
            } else if (_Logger.isDebugEnabled()) {
                _Logger.debug("\u670d\u52a1\u6b63\u5e38\u5fc3\u8df3 " + service + this.note);
            }
        }

        public boolean fail(ServiceRegister register, Service service, Throwable thr) {
            ++this.failCounter;
            int succ = this.succCounter;
            this.succCounter = 0;
            if (1 == this.failCounter) {
                if (succ > 0) {
                    _Logger.error("\u670d\u52a1\u5fc3\u8df3\u5931\u8d25 " + service + this.note, thr);
                } else {
                    _Logger.error("\u670d\u52a1\u6ce8\u518c\u5931\u8d25 " + service + this.note, thr);
                }
            } else {
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug("\u670d\u52a1\u6ce8\u518c/\u5fc3\u8df3\u5f02\u5e38 " + service + this.note, thr);
                }
                return 3 == this.failCounter;
            }
            return true;
        }

        public void offline(ServiceRegister register, Service service) {
            _Logger.info("\u670d\u52a1\u5df2\u4e0b\u7ebf " + service + this.note);
        }
    }

    class ServiceInfo
    implements Service {
        ServiceInfo() {
        }

        public String getName() {
            return WeforwardService.this.getName();
        }

        public String getDomain() {
            return WeforwardService.this.getHost();
        }

        public int getPort() {
            return WeforwardService.this.getPort();
        }

        public List<String> getUrls() {
            return null;
        }

        public String getNo() {
            return WeforwardService.this.getNo();
        }

        public String getVersion() {
            return WeforwardService.this.getVersion();
        }

        public String getCompatibleVersion() {
            return WeforwardService.this.getCompatibleVersion();
        }

        public String getBuildVersion() {
            return WeforwardService.this.getCompatibleVersion();
        }

        public int getHeartbeatPeriod() {
            return WeforwardService.this.m_HeartbeatPeriod > 0 ? WeforwardService.this.m_HeartbeatPeriod : 0;
        }

        public String getNote() {
            return WeforwardService.this.m_Note;
        }

        public String getDocumentMethod() {
            return WeforwardService.this.getDocumentMethod();
        }

        public String getDebugMethod() {
            return WeforwardService.this.getDebugMethod();
        }

        public String getRunningId() {
            return WeforwardService.this.getRunningId();
        }

        public int getRequestMaxSize() {
            return WeforwardService.this.m_RequestMaxSize;
        }

        public long getMarks() {
            return WeforwardService.this.m_ForwardEnable ? 1L : 0L;
        }

        public String toString() {
            StringBuilder builder = StringBuilderPool._8k.poll();
            try {
                builder.append("{name:");
                builder.append(this.getName());
                if (!StringUtil.isEmpty((String)this.getNo())) {
                    builder.append(",no:").append(this.getNo());
                }
                if (!StringUtil.isEmpty((String)this.getRunningId())) {
                    builder.append(",rid:").append(this.getRunningId());
                }
                if (!StringUtil.isEmpty((String)this.getVersion())) {
                    builder.append(",ver:").append(this.getVersion());
                }
                builder.append(",port:").append(this.getPort());
                if (!StringUtil.isEmpty((String)this.getDomain())) {
                    builder.append(",domain:").append(this.getDomain());
                }
                builder.append('}');
                String string = builder.toString();
                return string;
            }
            finally {
                StringBuilderPool._8k.offer(builder);
            }
        }
    }

    protected static class TopicListenerWrap<E> {
        Class<?> m_ContentClass;
        TopicListener<E> m_Listener;

        protected TopicListenerWrap() {
        }

        public TopicListenerWrap(TopicListener<E> l) {
            this.m_ContentClass = ClassUtil.find(l.getClass(), TopicListener.class, (String)"E");
            this.m_Listener = l;
        }

        public void onReceive(TopicWrap topic, DtBase content) {
            this.m_Listener.onReceive((Topic)topic, this.toContent(content));
        }

        protected E toContent(DtBase content) {
            if (content == null) {
                return null;
            }
            return (E)MappedUtil.fromBase(this.m_ContentClass, (DtBase)content);
        }
    }

    protected static class TopicWrap
    implements Topic {
        protected FriendlyObject m_Params;

        protected TopicWrap(FriendlyObject params) {
            this.m_Params = params;
        }

        public String getId() {
            return this.m_Params.getString("id");
        }

        public String getTopic() {
            return this.m_Params.getString("topic");
        }

        public String getTag() {
            return this.m_Params.getString("tag");
        }

        public String getDeliver() {
            return this.m_Params.getString("deliver");
        }

        public DtBase getContent() {
            return this.m_Params.getBase("content");
        }

        public String toString() {
            return String.valueOf(this.getTopic()) + ":" + this.getId();
        }
    }

    protected class WeResponse
    extends SimpleResponse
    implements AsyncResponse,
    Producer.Output,
    HttpHeaderOutput {
        protected RestfulResponse m_RestfulResponse;
        protected boolean m_Async;
        protected int m_ResponseTimeout;
        protected OutputStream m_ResponseOutput;

        public WeResponse(RestfulResponse rsp) {
            this.m_RestfulResponse = rsp;
        }

        public WeResponse(RestfulResponse rsp, Header reqHeader) {
            this.m_RestfulResponse = rsp;
            Header respHeader = new Header(reqHeader.getService());
            respHeader.setContentType(reqHeader.getContentType());
            respHeader.setCharset(reqHeader.getCharset());
            respHeader.setAuthType(reqHeader.getAuthType());
            respHeader.setAccessId(reqHeader.getAccessId());
            this.setHeader(respHeader);
        }

        public boolean isAsync() {
            return this.m_Async;
        }

        public void setServiceResult(int code, String message, DtBase content) {
            this.setServiceResult(RpcEndPoint.toResult(code, message, content));
        }

        public void setAsync() throws IOException {
            this.m_Async = true;
        }

        public void setResponseTimeout(int millis) throws IOException {
            this.m_ResponseTimeout = millis;
            this.m_RestfulResponse.setResponse(millis);
        }

        public int getResponseTimeout() {
            return this.m_ResponseTimeout;
        }

        public void complete() throws IOException {
            RestfulResponse rsp = this.m_RestfulResponse;
            if (rsp == null) {
                throw new EOFException(this.toString());
            }
            this.m_ResponseOutput = rsp.openOutput();
            try {
                try {
                    WeforwardService.this.m_Producer.make((Response)this, (Producer.Output)this);
                }
                catch (Throwable e) {
                    rsp.close();
                    this.m_ResponseOutput = null;
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    _Logger.error(e.toString(), e);
                    if (this.m_ResponseOutput != null) {
                        this.m_ResponseOutput.close();
                    }
                    this.m_RestfulResponse = null;
                }
            }
            finally {
                if (this.m_ResponseOutput != null) {
                    this.m_ResponseOutput.close();
                }
                this.m_RestfulResponse = null;
            }
        }

        public void put(String name, String value) throws IOException {
            this.m_RestfulResponse.setHeader(name, value);
        }

        public void writeHeader(Header header) throws IOException {
            HttpHeaderHelper.outHeaders((Header)this.getHeader(), (HttpHeaderOutput)this);
        }

        public OutputStream getOutputStream() throws IOException {
            return this.m_ResponseOutput;
        }
    }
}

