/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.ext;

import cn.weforward.common.execption.DuplicateNameException;
import cn.weforward.common.util.UriMatcher;
import cn.weforward.framework.ext.UriHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class UriHandlers {
    Map<String, UriHandler> m_Handlers = Collections.emptyMap();
    UriMatcher m_UriMatcher;

    UriHandlers() {
    }

    synchronized void add(UriHandler handler) {
        HashMap<String, UriHandler> map = new HashMap<String, UriHandler>(this.m_Handlers);
        String uri = handler.getUri().toLowerCase();
        UriHandler old = (UriHandler)map.get(uri);
        if (old != null && !old.equals(handler)) {
            throw new DuplicateNameException("URI\u91cd\u590d\uff1a" + uri);
        }
        map.put(uri, handler);
        this.m_Handlers = map;
        if (uri.indexOf(42) >= 0) {
            if (this.m_UriMatcher == null) {
                this.m_UriMatcher = new UriMatcher();
            }
            this.m_UriMatcher.addUri(uri);
        }
    }

    synchronized void addAll(List<UriHandler> handlers) {
        HashMap<String, UriHandler> map = new HashMap<String, UriHandler>(this.m_Handlers);
        ArrayList<String> wildcards = null;
        for (UriHandler handler : handlers) {
            String uri = handler.getUri().toLowerCase();
            UriHandler old = (UriHandler)map.get(uri);
            if (old != null && !old.equals(handler)) {
                throw new DuplicateNameException("URI\u91cd\u590d\uff1a" + uri);
            }
            map.put(uri, handler);
            if (uri.indexOf(42) < 0) continue;
            if (wildcards == null) {
                wildcards = new ArrayList<String>();
            }
            wildcards.add(uri);
        }
        this.m_Handlers = map;
        if (wildcards != null) {
            if (this.m_UriMatcher == null) {
                this.m_UriMatcher = new UriMatcher();
            }
            this.m_UriMatcher.addUris(wildcards);
        }
    }

    synchronized UriHandler remove(String uri) {
        if (this.m_Handlers.get(uri) == null) {
            return null;
        }
        HashMap<String, UriHandler> map = new HashMap<String, UriHandler>(this.m_Handlers);
        UriHandler handler = (UriHandler)map.remove(uri);
        this.m_Handlers = map;
        if (handler != null && uri.indexOf(42) >= 0 && this.m_UriMatcher != null) {
            this.m_UriMatcher.removeUri(uri);
        }
        return handler;
    }

    UriHandler find(String uri) {
        String match;
        Map<String, UriHandler> handlers = this.m_Handlers;
        if (handlers == null || handlers.isEmpty()) {
            return null;
        }
        UriHandler handler = handlers.get(uri);
        if (handler != null) {
            return handler;
        }
        UriMatcher matcher = this.m_UriMatcher;
        if (matcher != null && (match = matcher.match(uri)) != null) {
            handler = handlers.get(match);
            return handler;
        }
        return null;
    }
}

