/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.ext;

import cn.weforward.common.util.AntPathPattern;
import cn.weforward.common.util.StringUtil;
import cn.weforward.framework.ApiException;
import cn.weforward.framework.Authorizer;
import cn.weforward.framework.util.RequestUtil;
import cn.weforward.protocol.Access;
import cn.weforward.protocol.Request;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TenantAuthorizer
implements Authorizer {
    protected List<String> m_IgnoreUris;

    public void setIgnoreUris(List<String> uris) {
        if (uris == null) {
            this.m_IgnoreUris = Collections.emptyList();
        } else {
            this.m_IgnoreUris = new ArrayList<String>(uris);
            Collections.sort(this.m_IgnoreUris, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
        }
    }

    @Override
    public void auth(Request request) throws ApiException {
        String uri = RequestUtil.getMethod(request);
        if (StringUtil.isEmpty((String)uri)) {
            throw new ApiException(10001, "\u65b9\u6cd5\u540d\u4e3a\u7a7a");
        }
        Access access = request.getAccess();
        if (access == null) {
            throw ApiException.NO_LOGIN;
        }
        if (StringUtil.isEmpty((String)access.getTenant())) {
            throw ApiException.NO_LOGIN;
        }
        if (StringUtil.isEmpty((String)access.getOpenid())) {
            throw ApiException.NO_LOGIN;
        }
        if (TenantAuthorizer.match(this.m_IgnoreUris, uri) != null) {
            return;
        }
    }

    private static String match(List<String> patterns, String uri) {
        if (patterns == null) {
            return null;
        }
        for (String pattern : patterns) {
            if (!TenantAuthorizer.match(pattern, uri)) continue;
            return pattern;
        }
        return null;
    }

    private static boolean match(String pattern, String uri) {
        return AntPathPattern.match((String)pattern, (String)uri);
    }
}

