/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.ext;

import cn.weforward.common.io.BytesOutputStream;
import cn.weforward.common.json.JsonUtil;
import cn.weforward.common.restful.RestfulRequest;
import cn.weforward.common.restful.RestfulResponse;
import cn.weforward.common.util.ListUtil;
import cn.weforward.common.util.StringUtil;
import cn.weforward.framework.ResourceDownloader;
import cn.weforward.framework.ResourceException;
import cn.weforward.framework.ResourceHandler;
import cn.weforward.framework.ResourceUploader;
import cn.weforward.framework.WeforwardFile;
import cn.weforward.framework.util.WeforwardResourceHelper;
import cn.weforward.framework.web.upload.WebFileUpload;
import cn.weforward.framework.web.upload.WebForm;
import cn.weforward.metrics.WeforwardMetrics;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamEndPoint {
    static final Logger _Logger = LoggerFactory.getLogger(StreamEndPoint.class);
    protected List<ResourceHandler> m_Resuorces = new ArrayList<ResourceHandler>();
    protected List<ResourceUploader> m_Uploaders = new ArrayList<ResourceUploader>();
    protected List<ResourceDownloader> m_Downloaders = new ArrayList<ResourceDownloader>();
    private AtomicInteger m_CurrentRequest = new AtomicInteger();
    private MeterRegistry m_MeterRegistry;

    public void setMeterRegistry(MeterRegistry registry) {
        this.m_MeterRegistry = registry;
        if (this.m_MeterRegistry != null) {
            Gauge.builder((String)"weforward.service.stream.current.request", (Object)this.m_CurrentRequest, AtomicInteger::doubleValue).strongReference(true).register(this.m_MeterRegistry);
        }
    }

    public MeterRegistry getMeterRegistry() {
        return this.m_MeterRegistry;
    }

    public void register(ResourceHandler resources) {
        this.m_Resuorces.add(resources);
    }

    public void register(ResourceUploader u) {
        this.m_Uploaders.add(u);
    }

    public void register(ResourceDownloader d) {
        this.m_Downloaders.add(d);
    }

    public void handle(RestfulRequest request, RestfulResponse response) throws IOException {
        block11: {
            MeterRegistry mr = this.getMeterRegistry();
            long start = System.currentTimeMillis();
            int code = 0;
            Tags tags = Tags.empty();
            try {
                this.m_CurrentRequest.incrementAndGet();
                String path = request.getUri();
                if (mr != null) {
                    tags = WeforwardMetrics.TagHelper.of((Tag[])new Tag[]{WeforwardMetrics.TagHelper.method((String)path)});
                }
                this.doHandle(request, response);
            }
            catch (ResourceException e) {
                response.setHeader("Content-Type", "application/json;charset=utf-8");
                response.setStatus(200);
                code = e.getCode();
                this.error(response, code, e.getMessage());
                long end = System.currentTimeMillis();
                long amount = end - start;
                if (mr != null) {
                    tags = tags.and(new Tag[]{WeforwardMetrics.TagHelper.code((int)code)});
                    mr.timer("weforward.service.stream.requests", (Iterable)tags).record(amount, TimeUnit.MILLISECONDS);
                }
                this.m_CurrentRequest.decrementAndGet();
                break block11;
            }
            catch (RuntimeException e) {
                try {
                    _Logger.warn("\u5904\u7406\u5f02\u5e38," + request.getUri(), (Throwable)e);
                    response.setHeader("Content-Type", "application/json;charset=utf-8");
                    response.setStatus(500);
                    code = 30001;
                    this.error(response, code, e.getMessage());
                }
                catch (Throwable throwable) {
                    long end = System.currentTimeMillis();
                    long amount = end - start;
                    if (mr != null) {
                        tags = tags.and(new Tag[]{WeforwardMetrics.TagHelper.code((int)code)});
                        mr.timer("weforward.service.stream.requests", (Iterable)tags).record(amount, TimeUnit.MILLISECONDS);
                    }
                    this.m_CurrentRequest.decrementAndGet();
                    throw throwable;
                }
                long end = System.currentTimeMillis();
                long amount = end - start;
                if (mr != null) {
                    tags = tags.and(new Tag[]{WeforwardMetrics.TagHelper.code((int)code)});
                    mr.timer("weforward.service.stream.requests", (Iterable)tags).record(amount, TimeUnit.MILLISECONDS);
                }
                this.m_CurrentRequest.decrementAndGet();
                break block11;
            }
            long end = System.currentTimeMillis();
            long amount = end - start;
            if (mr != null) {
                tags = tags.and(new Tag[]{WeforwardMetrics.TagHelper.code((int)code)});
                mr.timer("weforward.service.stream.requests", (Iterable)tags).record(amount, TimeUnit.MILLISECONDS);
            }
            this.m_CurrentRequest.decrementAndGet();
        }
    }

    private void error(RestfulResponse response, int code, String msg) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream out = response.openOutput();){
            StringBuilder sb = new StringBuilder();
            sb.append("{\"code\":");
            sb.append(code);
            sb.append(",\"msg\":\"");
            JsonUtil.escape((CharSequence)msg, (Appendable)sb);
            sb.append("\"}");
            out.write(sb.toString().getBytes("utf-8"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doHandle(RestfulRequest request, RestfulResponse response) throws IOException {
        Object type2;
        String resourceId = (String)request.getParams().get((Object)"id");
        String contentType = (String)request.getHeaders().get((Object)"Content-Type");
        if (!ListUtil.isEmpty(this.m_Uploaders) && !StringUtil.isEmpty((String)contentType) && contentType.contains("multipart/form-data")) {
            WebFileUpload u = new WebFileUpload();
            u.input(request.getContent());
            ArrayList<WeforwardFile> files = new ArrayList<WeforwardFile>();
            int i = 0;
            while (i < u.size()) {
                WebForm form = u.get(i);
                type2 = form.getContentType();
                if (!StringUtil.isEmpty((String)type2)) {
                    files.add(WeforwardResourceHelper.newFile(form.getFileName(), form.getStream()));
                }
                ++i;
            }
            if (files.isEmpty()) {
                response.setStatus(400);
                response.openOutput().close();
                return;
            }
            WeforwardFile[] fs = new WeforwardFile[files.size()];
            fs = files.toArray(fs);
            for (ResourceUploader up : this.m_Uploaders) {
                boolean isOk = up.saveFile(resourceId, fs);
                if (!isOk) continue;
                response.setStatus(200);
                response.openOutput().close();
                return;
            }
        }
        for (ResourceDownloader d : this.m_Downloaders) {
            WeforwardFile file = d.findFile(resourceId);
            if (file == null) continue;
            String fileName = file.getName();
            if (StringUtil.isEmpty((String)fileName)) {
                fileName = "\u672a\u77e5";
            }
            fileName = fileName.replace('\"', ' ');
            try {
                fileName = new String(fileName.getBytes("gbk"), "iso8859-1");
            }
            catch (Throwable type2) {
                // empty catch block
            }
            type2 = file.getContentType();
            if (!StringUtil.isEmpty((String)type2)) {
                response.setHeader("Content-Type", (String)type2);
            } else {
                response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            }
            response.setStatus(200);
            Throwable throwable = null;
            Object var11_15 = null;
            try {
                InputStream in = file.getStream();
                try {
                    try (OutputStream out = response.openOutput();){
                        BytesOutputStream.transfer((InputStream)in, (OutputStream)out, (int)0);
                    }
                    if (in == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        for (ResourceHandler r : this.m_Resuorces) {
            if (!r.handle(request, response)) continue;
            return;
        }
        response.setStatus(404);
        response.openOutput().close();
    }
}

