/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.ext;

import cn.weforward.common.util.AntPathPattern;
import cn.weforward.common.util.StringUtil;
import cn.weforward.framework.ApiException;
import cn.weforward.framework.ApiMethod;
import cn.weforward.framework.Authorizer;
import cn.weforward.framework.WeforwardSession;
import cn.weforward.framework.exception.ApiBusinessException;
import cn.weforward.framework.exception.ForwardException;
import cn.weforward.framework.ext.DebugMethod;
import cn.weforward.framework.ext.DocumentMethod;
import cn.weforward.framework.ext.SimpleSession;
import cn.weforward.framework.support.AbstractWeforwardEndPoint;
import cn.weforward.framework.util.RequestUtil;
import cn.weforward.metrics.WeforwardMetrics;
import cn.weforward.protocol.Access;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.Response;
import cn.weforward.protocol.datatype.DtBase;
import cn.weforward.protocol.datatype.DtObject;
import cn.weforward.protocol.exception.WeforwardException;
import cn.weforward.protocol.ops.User;
import cn.weforward.protocol.ops.UserService;
import cn.weforward.protocol.ops.trace.SimpleServiceTraceToken;
import cn.weforward.protocol.support.datatype.SimpleDtNumber;
import cn.weforward.protocol.support.datatype.SimpleDtObject;
import cn.weforward.protocol.support.datatype.SimpleDtString;
import cn.weforward.protocol.support.doc.ServiceDocumentVo;
import cn.weforward.trace.ServiceTrace;
import cn.weforward.trace.TraceRegistry;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcEndPoint
extends AbstractWeforwardEndPoint {
    private static final Logger _Logger = LoggerFactory.getLogger(RpcEndPoint.class);
    private HashMap<String, ApiMethod> m_Methods;
    private List<String> m_AntUrls = Collections.emptyList();
    private String m_BasePath = "";
    private String m_Suffix = "";
    private Map<String, Authorizer> m_Authorizers;
    private String m_DocumentMethodName;
    private DocumentMethod m_DocumentMethod;
    private String m_DebugMethod;
    private AtomicInteger m_CurrentRequest;
    private MeterRegistry m_MeterRegistry;
    private TraceRegistry m_TraceRegistry;
    private UserService m_UserService;

    public RpcEndPoint() {
        this.m_Methods = new HashMap(10);
        this.m_Authorizers = new HashMap<String, Authorizer>();
        this.m_CurrentRequest = new AtomicInteger();
    }

    public String getBasePath() {
        return this.m_BasePath;
    }

    public void setMeterRegistry(MeterRegistry registry) {
        this.m_MeterRegistry = registry;
        if (this.m_MeterRegistry != null) {
            Gauge.builder((String)"weforward.service.rpc.current.request", (Object)this.m_CurrentRequest, AtomicInteger::doubleValue).strongReference(true).register(this.m_MeterRegistry);
        }
    }

    public MeterRegistry getMeterRegistry() {
        return this.m_MeterRegistry;
    }

    public void setTraceRegister(TraceRegistry registry) {
        this.m_TraceRegistry = registry;
    }

    public TraceRegistry getTraceRegistry() {
        return this.m_TraceRegistry;
    }

    protected Logger getLogger() {
        return _Logger;
    }

    public void register(String kind, Authorizer authorizer) {
        this.m_Authorizers.put(StringUtil.toString((Object)kind), authorizer);
    }

    public void setBasePath(String path) {
        this.m_BasePath = StringUtil.toString((Object)path);
    }

    public void setSuffix(String suffix) {
        this.m_Suffix = StringUtil.toString((Object)suffix);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DtBase handle(Request request, Response response) throws IOException, WeforwardException, ApiException {
        DtBase dtBase;
        long start = System.currentTimeMillis();
        int code = 0;
        MeterRegistry mr = this.getMeterRegistry();
        TraceRegistry tr = this.getTraceRegistry();
        String traceToken = request.getTraceToken();
        Tags tags = Tags.empty();
        try {
            this.m_CurrentRequest.incrementAndGet();
            String path = RequestUtil.getMethod(request);
            if (mr != null) {
                tags = WeforwardMetrics.TagHelper.of((Tag[])new Tag[]{WeforwardMetrics.TagHelper.method((String)path)});
            }
            Access access = request.getAccess();
            String kind = null;
            if (access != null) {
                kind = Access.Helper.getKind((String)access.getAccessId());
            }
            SimpleSession session = new SimpleSession(request);
            if (this.m_UserService != null && StringUtil.eq((String)"US", (String)kind)) {
                User user = this.m_UserService.getUserByAccess(request.getAccess().getAccessId());
                session.bindOperator(user);
            }
            WeforwardSession.TLS.putSession(session);
            Authorizer a = this.m_Authorizers.get(StringUtil.toString((Object)kind));
            if (a != null) {
                a.auth(request);
            }
            dtBase = this.doHandle(kind, path, session, request, response);
        }
        catch (ApiException e) {
            try {
                code = e.getCode();
                throw e;
                catch (ForwardException e2) {
                    code = 0;
                    throw e2;
                }
                catch (RuntimeException e3) {
                    code = 30001;
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                long amount = end - start;
                if (mr != null) {
                    tags = tags.and(new Tag[]{WeforwardMetrics.TagHelper.code((int)code)});
                    mr.timer("weforward.service.rpc.requests", (Iterable)tags).record(amount, TimeUnit.MILLISECONDS);
                }
                if (tr != null && !StringUtil.isEmpty((String)traceToken)) {
                    SimpleServiceTraceToken token = SimpleServiceTraceToken.valueOf((String)traceToken);
                    tr.register(ServiceTrace.newTrace((String)token.getSpanId(), (String)token.getParentId(), (String)token.getTraceId(), (long)start, (long)amount, (Iterable)tags));
                }
                this.m_CurrentRequest.decrementAndGet();
                WeforwardSession.TLS.putSession(null);
                throw throwable;
            }
        }
        long end = System.currentTimeMillis();
        long amount = end - start;
        if (mr != null) {
            tags = tags.and(new Tag[]{WeforwardMetrics.TagHelper.code((int)code)});
            mr.timer("weforward.service.rpc.requests", (Iterable)tags).record(amount, TimeUnit.MILLISECONDS);
        }
        if (tr != null && !StringUtil.isEmpty((String)traceToken)) {
            SimpleServiceTraceToken token = SimpleServiceTraceToken.valueOf((String)traceToken);
            tr.register(ServiceTrace.newTrace((String)token.getSpanId(), (String)token.getParentId(), (String)token.getTraceId(), (long)start, (long)amount, (Iterable)tags));
        }
        this.m_CurrentRequest.decrementAndGet();
        WeforwardSession.TLS.putSession(null);
        return dtBase;
    }

    protected void register(ApiMethod method) {
        List<String> old;
        if (method == null) {
            return;
        }
        String key = String.valueOf(this.m_BasePath) + method.getName() + this.m_Suffix;
        if (RpcEndPoint.isAntUrl(key)) {
            List<String> list;
            old = this.m_AntUrls;
            if (old == null) {
                list = Collections.singletonList(key);
            } else {
                list = new ArrayList<String>(old.size() + 1);
                list.addAll(old);
                list.add(key);
            }
            this.m_AntUrls = list;
        }
        if (method instanceof DocumentMethod) {
            this.m_DocumentMethodName = key;
            this.m_DocumentMethod = (DocumentMethod)method;
        }
        if (method instanceof DebugMethod) {
            this.m_DebugMethod = key;
        }
        if (_Logger.isDebugEnabled()) {
            _Logger.debug("reigster method " + key);
        }
        if ((old = this.m_Methods.put(key, method)) != null) {
            _Logger.error("\u5b58\u5728\u540c\u540d\u7684\u65b9\u6cd5:" + key + "\uff0c" + old + "\u88ab\u66ff\u6362");
        }
    }

    Map<String, ApiMethod> getMethods() {
        return this.m_Methods;
    }

    String getDocumentMethod() {
        return this.m_DocumentMethodName;
    }

    ServiceDocumentVo getServiceDocument() {
        return this.m_DocumentMethod == null ? null : this.m_DocumentMethod.getServiceDocument();
    }

    String getDebugMethod() {
        return this.m_DebugMethod;
    }

    private DtBase doHandle(String kind, String path, WeforwardSession session, Request request, Response response) throws ApiException {
        ApiMethod method = this.m_Methods.get(path);
        if (method == null && !this.m_AntUrls.isEmpty()) {
            for (String ant : this.m_AntUrls) {
                if (!AntPathPattern.match((String)ant, (String)path)) continue;
                method = this.m_Methods.get(ant);
                break;
            }
        }
        if (method == null) {
            throw new ApiException(10001, "[" + path + "(" + kind + ")]\u65b9\u6cd5\u4e0d\u5b58\u5728");
        }
        String mkind = method.getKind();
        if (!StringUtil.isEmpty((String)mkind) && !StringUtil.eq((String)mkind, (String)kind)) {
            throw ApiException.METHOD_KIND_NO_MATCH;
        }
        if (!method.isAllow(session)) {
            throw ApiException.AUTH_FAILED;
        }
        DtObject params = RequestUtil.getParams(request);
        return method.handle(path, params, request, response);
    }

    protected static DtObject toResult(ApiException e) {
        SimpleDtObject m = new SimpleDtObject();
        m.put("code", (DtBase)SimpleDtNumber.valueOf((int)e.getCode()));
        m.put("msg", (DtBase)SimpleDtString.valueOf((String)e.getMessage()));
        if (e instanceof ApiBusinessException) {
            m.put("business_code", (DtBase)SimpleDtNumber.valueOf((int)((ApiBusinessException)e).getBusinessCode()));
        }
        return m;
    }

    protected static DtObject toResult(int code, String message, DtBase content) {
        SimpleDtObject m = new SimpleDtObject();
        m.put("code", (DtBase)SimpleDtNumber.valueOf((int)code));
        m.put("msg", (DtBase)SimpleDtString.valueOf((String)message));
        if (content != null) {
            m.put("content", content);
        }
        return m;
    }
}

